/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInput;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInputData;
import org.pentaho.hbase.mapping.MappingAdmin;
import org.pentaho.hbase.shim.api.ColumnFilter;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Step(id="HBaseInput", image="HB.png", name="HBase Input", description="Reads data from a HBase table according to a mapping", categoryDescription="Big Data")
public class HBaseInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = HBaseInputMeta.class;
    protected String m_zookeeperHosts;
    protected String m_zookeeperPort;
    protected String m_coreConfigURL;
    protected String m_defaultConfigURL;
    protected String m_sourceTableName;
    protected String m_sourceMappingName;
    protected String m_keyStart;
    protected String m_keyStop;
    protected String m_scannerCacheSize;
    protected transient Mapping m_cachedMapping;
    protected List<HBaseValueMeta> m_outputFields;
    protected List<ColumnFilter> m_filters;
    protected boolean m_matchAnyFilter;
    protected Mapping m_mapping;

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public void setZookeeperHosts(String z) {
        this.m_zookeeperHosts = z;
    }

    public String getZookeeperHosts() {
        return this.m_zookeeperHosts;
    }

    public void setZookeeperPort(String port) {
        this.m_zookeeperPort = port;
    }

    public String getZookeeperPort() {
        return this.m_zookeeperPort;
    }

    public void setCoreConfigURL(String coreConfig) {
        this.m_coreConfigURL = coreConfig;
        this.m_cachedMapping = null;
    }

    public String getCoreConfigURL() {
        return this.m_coreConfigURL;
    }

    public void setDefaulConfigURL(String defaultConfig) {
        this.m_defaultConfigURL = defaultConfig;
        this.m_cachedMapping = null;
    }

    public String getDefaultConfigURL() {
        return this.m_defaultConfigURL;
    }

    public void setSourceTableName(String sourceTable) {
        this.m_sourceTableName = sourceTable;
        this.m_cachedMapping = null;
    }

    public String getSourceTableName() {
        return this.m_sourceTableName;
    }

    public void setSourceMappingName(String sourceMapping) {
        this.m_sourceMappingName = sourceMapping;
        this.m_cachedMapping = null;
    }

    public String getSourceMappingName() {
        return this.m_sourceMappingName;
    }

    public void setMatchAnyFilter(boolean a) {
        this.m_matchAnyFilter = a;
    }

    public boolean getMatchAnyFilter() {
        return this.m_matchAnyFilter;
    }

    public void setKeyStartValue(String start) {
        this.m_keyStart = start;
    }

    public String getKeyStartValue() {
        return this.m_keyStart;
    }

    public void setKeyStopValue(String stop) {
        this.m_keyStop = stop;
    }

    public String getKeyStopValue() {
        return this.m_keyStop;
    }

    public void setScannerCacheSize(String s) {
        this.m_scannerCacheSize = s;
    }

    public String getScannerCacheSize() {
        return this.m_scannerCacheSize;
    }

    public void setOutputFields(List<HBaseValueMeta> fields) {
        this.m_outputFields = fields;
    }

    public List<HBaseValueMeta> getOutputFields() {
        return this.m_outputFields;
    }

    public void setColumnFilters(List<ColumnFilter> list) {
        this.m_filters = list;
    }

    public List<ColumnFilter> getColumnFilters() {
        return this.m_filters;
    }

    public void setDefault() {
        this.m_coreConfigURL = null;
        this.m_defaultConfigURL = null;
        this.m_cachedMapping = null;
        this.m_sourceTableName = null;
        this.m_sourceMappingName = null;
        this.m_keyStart = null;
        this.m_keyStop = null;
    }

    private String getIndexValues(HBaseValueMeta vm) {
        Object[] labels = vm.getIndex();
        StringBuffer vals = new StringBuffer();
        vals.append("{");
        for (int i = 0; i < labels.length; ++i) {
            if (i != labels.length - 1) {
                vals.append(labels[i].toString().trim()).append(",");
                continue;
            }
            vals.append(labels[i].toString().trim()).append("}");
        }
        return vals.toString();
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_zookeeperHosts)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"zookeeper_hosts", (String)this.m_zookeeperHosts));
        }
        if (!Const.isEmpty((String)this.m_zookeeperPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"zookeeper_port", (String)this.m_zookeeperPort));
        }
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"core_config_url", (String)this.m_coreConfigURL));
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"default_config_url", (String)this.m_defaultConfigURL));
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_table_name", (String)this.m_sourceTableName));
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"source_mapping_name", (String)this.m_sourceMappingName));
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_start", (String)this.m_keyStart));
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_stop", (String)this.m_keyStop));
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"scanner_cache_size", (String)this.m_scannerCacheSize));
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"output_fields"));
            for (HBaseValueMeta vm : this.m_outputFields) {
                retval.append("\n        ").append(XMLHandler.openTag((String)"field"));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"table_name", (String)vm.getTableName()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"mapping_name", (String)vm.getMappingName()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"alias", (String)vm.getAlias()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"family", (String)vm.getColumnFamily()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"column", (String)vm.getColumnName()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"key", (boolean)vm.isKey()));
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)vm.getType())));
                String format = vm.getConversionMask();
                retval.append("\n            ").append(XMLHandler.addTagValue((String)"format", (String)format));
                if (vm.getStorageType() == 2) {
                    retval.append("\n            ").append(XMLHandler.addTagValue((String)"index_values", (String)this.getIndexValues(vm)));
                }
                retval.append("\n        ").append(XMLHandler.closeTag((String)"field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"output_fields"));
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"column_filters"));
            for (ColumnFilter f : this.m_filters) {
                f.appendXML(retval);
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"column_filters"));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"match_any_filter", (boolean)this.m_matchAnyFilter));
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        Mapping tempMapping;
        Node filters;
        Node fields;
        this.m_zookeeperHosts = XMLHandler.getTagValue((Node)stepnode, (String)"zookeeper_hosts");
        this.m_zookeeperPort = XMLHandler.getTagValue((Node)stepnode, (String)"zookeeper_port");
        this.m_coreConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"core_config_url");
        this.m_defaultConfigURL = XMLHandler.getTagValue((Node)stepnode, (String)"default_config_url");
        this.m_sourceTableName = XMLHandler.getTagValue((Node)stepnode, (String)"source_table_name");
        this.m_sourceMappingName = XMLHandler.getTagValue((Node)stepnode, (String)"source_mapping_name");
        this.m_keyStart = XMLHandler.getTagValue((Node)stepnode, (String)"key_start");
        this.m_keyStop = XMLHandler.getTagValue((Node)stepnode, (String)"key_stop");
        this.m_scannerCacheSize = XMLHandler.getTagValue((Node)stepnode, (String)"scanner_cache_size");
        String m = XMLHandler.getTagValue((Node)stepnode, (String)"match_any_filter");
        if (!Const.isEmpty((String)m)) {
            this.m_matchAnyFilter = m.equalsIgnoreCase("Y");
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"output_fields")) != null && XMLHandler.countNodes((Node)fields, (String)"field") > 0) {
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.m_outputFields = new ArrayList<HBaseValueMeta>();
            for (int i = 0; i < nrfields; ++i) {
                String indexValues;
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                String isKey = XMLHandler.getTagValue((Node)fieldNode, (String)"key").trim();
                String alias = XMLHandler.getTagValue((Node)fieldNode, (String)"alias").trim();
                String colFamily = "";
                String colName = alias;
                if (!isKey.equalsIgnoreCase("Y")) {
                    if (XMLHandler.getTagValue((Node)fieldNode, (String)"family") != null) {
                        colFamily = XMLHandler.getTagValue((Node)fieldNode, (String)"family").trim();
                    }
                    if (XMLHandler.getTagValue((Node)fieldNode, (String)"column") != null) {
                        colName = XMLHandler.getTagValue((Node)fieldNode, (String)"column").trim();
                    }
                }
                String typeS = XMLHandler.getTagValue((Node)fieldNode, (String)"type").trim();
                HBaseValueMeta vm = new HBaseValueMeta(colFamily + "," + colName + "," + alias, ValueMeta.getType((String)typeS), -1, -1);
                vm.setTableName(XMLHandler.getTagValue((Node)fieldNode, (String)"table_name"));
                vm.setTableName(XMLHandler.getTagValue((Node)fieldNode, (String)"mapping_name"));
                vm.setKey(isKey.equalsIgnoreCase("Y"));
                String format = XMLHandler.getTagValue((Node)fieldNode, (String)"format");
                if (!Const.isEmpty((String)format)) {
                    vm.setConversionMask(format);
                }
                if (!Const.isEmpty((String)(indexValues = XMLHandler.getTagValue((Node)fieldNode, (String)"index_values")))) {
                    Object[] labels = indexValues.replace("{", "").replace("}", "").split(",");
                    if (labels.length < 1) {
                        throw new KettleXMLException("Indexed/nominal type must have at least one label declared");
                    }
                    for (int j = 0; j < labels.length; ++j) {
                        labels[j] = ((String)labels[j]).trim();
                    }
                    vm.setIndex(labels);
                    vm.setStorageType(2);
                }
                this.m_outputFields.add(vm);
            }
        }
        if ((filters = XMLHandler.getSubNode((Node)stepnode, (String)"column_filters")) != null && XMLHandler.countNodes((Node)filters, (String)"filter") > 0) {
            int nrFilters = XMLHandler.countNodes((Node)filters, (String)"filter");
            this.m_filters = new ArrayList<ColumnFilter>();
            for (int i = 0; i < nrFilters; ++i) {
                Node filterNode = XMLHandler.getSubNodeByNr((Node)filters, (String)"filter", (int)i);
                this.m_filters.add(ColumnFilter.getFilter((Node)filterNode));
            }
        }
        this.m_mapping = (tempMapping = new Mapping()).loadXML(stepnode) ? tempMapping : null;
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        if (!Const.isEmpty((String)this.m_zookeeperHosts)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "zookeeper_hosts", this.m_zookeeperHosts);
        }
        if (!Const.isEmpty((String)this.m_zookeeperPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "zookeeper_port", this.m_zookeeperPort);
        }
        if (!Const.isEmpty((String)this.m_coreConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "core_config_url", this.m_coreConfigURL);
        }
        if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "default_config_url", this.m_defaultConfigURL);
        }
        if (!Const.isEmpty((String)this.m_sourceTableName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_table_name", this.m_sourceTableName);
        }
        if (!Const.isEmpty((String)this.m_sourceMappingName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "source_mapping_name", this.m_sourceMappingName);
        }
        if (!Const.isEmpty((String)this.m_keyStart)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_start", this.m_keyStart);
        }
        if (!Const.isEmpty((String)this.m_keyStop)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_stop", this.m_keyStop);
        }
        if (!Const.isEmpty((String)this.m_scannerCacheSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "scanner_cache_size", this.m_scannerCacheSize);
        }
        if (this.m_outputFields != null && this.m_outputFields.size() > 0) {
            for (i = 0; i < this.m_outputFields.size(); ++i) {
                HBaseValueMeta vm = this.m_outputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "table_name", vm.getTableName());
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_name", vm.getMappingName());
                rep.saveStepAttribute(id_transformation, id_step, i, "alias", vm.getAlias());
                rep.saveStepAttribute(id_transformation, id_step, i, "family", vm.getColumnFamily());
                rep.saveStepAttribute(id_transformation, id_step, i, "column", vm.getColumnName());
                rep.saveStepAttribute(id_transformation, id_step, i, "key", vm.isKey());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", ValueMeta.getTypeDesc((int)vm.getType()));
                String format = vm.getConversionMask();
                rep.saveStepAttribute(id_transformation, id_step, i, "format", format);
                if (vm.getStorageType() != 2) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "index_values", this.getIndexValues(vm));
            }
        }
        if (this.m_filters != null && this.m_filters.size() > 0) {
            for (i = 0; i < this.m_filters.size(); ++i) {
                ColumnFilter f = this.m_filters.get(i);
                f.saveRep(rep, id_transformation, id_step, i);
            }
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "match_any_filter", this.m_matchAnyFilter);
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        Mapping tempMapping;
        int nrFilters;
        this.m_zookeeperHosts = rep.getStepAttributeString(id_step, 0, "zookeeper_hosts");
        this.m_zookeeperPort = rep.getStepAttributeString(id_step, 0, "zookeeper_port");
        this.m_coreConfigURL = rep.getStepAttributeString(id_step, 0, "core_config_url");
        this.m_defaultConfigURL = rep.getStepAttributeString(id_step, 0, "default_config_url");
        this.m_sourceTableName = rep.getStepAttributeString(id_step, 0, "source_table_name");
        this.m_sourceMappingName = rep.getStepAttributeString(id_step, 0, "source_mapping_name");
        this.m_keyStart = rep.getStepAttributeString(id_step, 0, "key_start");
        this.m_keyStop = rep.getStepAttributeString(id_step, 0, "key_stop");
        this.m_matchAnyFilter = rep.getStepAttributeBoolean(id_step, 0, "match_any_filter");
        this.m_scannerCacheSize = rep.getStepAttributeString(id_step, 0, "scanner_cache_size");
        int nrfields = rep.countNrStepAttributes(id_step, "table_name");
        if (nrfields > 0) {
            this.m_outputFields = new ArrayList<HBaseValueMeta>();
            for (int i = 0; i < nrfields; ++i) {
                String indexValues;
                String typeS;
                String alias;
                String colName;
                String colFamily = rep.getStepAttributeString(id_step, i, "family");
                if (!Const.isEmpty((String)colFamily)) {
                    colFamily = colFamily.trim();
                }
                if (!Const.isEmpty((String)(colName = rep.getStepAttributeString(id_step, i, "column")))) {
                    colName = colName.trim();
                }
                if (!Const.isEmpty((String)(alias = rep.getStepAttributeString(id_step, i, "alias")))) {
                    alias = alias.trim();
                }
                if (!Const.isEmpty((String)(typeS = rep.getStepAttributeString(id_step, i, "type")))) {
                    typeS = typeS.trim();
                }
                boolean isKey = rep.getStepAttributeBoolean(id_step, i, "key");
                HBaseValueMeta vm = new HBaseValueMeta(colFamily + "," + colName + "," + alias, ValueMeta.getType((String)typeS), -1, -1);
                vm.setTableName(rep.getStepAttributeString(id_step, i, "table_name"));
                vm.setTableName(rep.getStepAttributeString(id_step, i, "mapping_name"));
                vm.setKey(isKey);
                String format = rep.getStepAttributeString(id_step, i, "format");
                if (!Const.isEmpty((String)format)) {
                    vm.setConversionMask(format);
                }
                if (!Const.isEmpty((String)(indexValues = rep.getStepAttributeString(id_step, i, "index_values")))) {
                    Object[] labels = indexValues.replace("{", "").replace("}", "").split(",");
                    if (labels.length < 1) {
                        throw new KettleXMLException("Indexed/nominal type must have at least one label declared");
                    }
                    for (int j = 0; j < labels.length; ++j) {
                        labels[j] = ((String)labels[j]).trim();
                    }
                    vm.setIndex(labels);
                    vm.setStorageType(2);
                }
                this.m_outputFields.add(vm);
            }
        }
        if ((nrFilters = rep.countNrStepAttributes(id_step, "cf_comparison_opp")) > 0) {
            this.m_filters = new ArrayList<ColumnFilter>();
            for (int i = 0; i < nrFilters; ++i) {
                this.m_filters.add(ColumnFilter.getFilter((Repository)rep, (int)i, (ObjectId)id_step));
            }
        }
        this.m_mapping = (tempMapping = new Mapping()).readRep(rep, id_step) ? tempMapping : null;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        RowMeta r = new RowMeta();
        try {
            this.getFields((RowMetaInterface)r, "testName", null, null, null);
            CheckResult cr = new CheckResult(1, "Step can connect to HBase. Named mapping exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        catch (Exception ex) {
            CheckResult cr = new CheckResult(4, ex.getMessage(), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseInput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new HBaseInputData();
    }

    private void setupCachedMapping(VariableSpace space) throws KettleStepException {
        if (Const.isEmpty((String)this.m_coreConfigURL) && Const.isEmpty((String)this.m_zookeeperHosts)) {
            throw new KettleStepException("No output fields available (missing connection details)!");
        }
        if (this.m_mapping == null && (Const.isEmpty((String)this.m_sourceTableName) || Const.isEmpty((String)this.m_sourceMappingName))) {
            throw new KettleStepException("No output fields available (missing table mapping details)!");
        }
        if (this.m_cachedMapping == null) {
            if (this.m_mapping != null) {
                this.m_cachedMapping = this.m_mapping;
            } else {
                HBaseConnection conf = null;
                String coreConf = null;
                String defaultConf = null;
                String zookeeperHosts = null;
                String zookeeperPort = null;
                try {
                    if (!Const.isEmpty((String)this.m_coreConfigURL)) {
                        coreConf = space.environmentSubstitute(this.m_coreConfigURL);
                    }
                    if (!Const.isEmpty((String)this.m_defaultConfigURL)) {
                        defaultConf = space.environmentSubstitute(this.m_defaultConfigURL);
                    }
                    if (!Const.isEmpty((String)this.m_zookeeperHosts)) {
                        zookeeperHosts = space.environmentSubstitute(this.m_zookeeperHosts);
                    }
                    if (!Const.isEmpty((String)this.m_zookeeperPort)) {
                        zookeeperPort = space.environmentSubstitute(zookeeperPort);
                    }
                    ArrayList<String> forLogging = new ArrayList<String>();
                    conf = HBaseInputData.getHBaseConnection(zookeeperHosts, zookeeperPort, coreConf, defaultConf, forLogging);
                    for (String m : forLogging) {
                        this.logBasic(m);
                    }
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
                MappingAdmin mappingAdmin = null;
                try {
                    mappingAdmin = new MappingAdmin(conf);
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
                try {
                    this.m_cachedMapping = mappingAdmin.getMapping(this.m_sourceTableName, this.m_sourceMappingName);
                }
                catch (Exception ex) {
                    throw new KettleStepException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        rowMeta.clear();
        if (this.m_outputFields != null) {
            for (HBaseValueMeta vm : this.m_outputFields) {
                vm.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)vm);
            }
        } else {
            this.setupCachedMapping(space);
            int kettleType = this.m_cachedMapping.getKeyType() == Mapping.KeyType.DATE || this.m_cachedMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE ? 3 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.STRING ? 2 : (this.m_cachedMapping.getKeyType() == Mapping.KeyType.BINARY ? 8 : 5));
            ValueMeta keyMeta = new ValueMeta(this.m_cachedMapping.getKeyName(), kettleType);
            keyMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)keyMeta);
            Map mappedColumnsByAlias = this.m_cachedMapping.getMappedColumns();
            Set aliasSet = mappedColumnsByAlias.keySet();
            for (String alias : aliasSet) {
                HBaseValueMeta columnMeta = (HBaseValueMeta)mappedColumnsByAlias.get(alias);
                columnMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)columnMeta);
            }
        }
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.hbaseinput.HBaseInputDialog";
    }
}

