/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.util.JSON;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;

public class MongoDbInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbInputMeta.class;
    private MongoDbInputMeta meta;
    private MongoDbInputData data;

    public MongoDbInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
            String query = this.environmentSubstitute(this.meta.getJsonQuery());
            String fields = this.environmentSubstitute(this.meta.getFieldsName());
            if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
                this.data.cursor = this.data.collection.find();
            } else {
                DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
                DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
                this.data.cursor = this.data.collection.find(dbObject, dbObject2);
            }
        }
        if (this.data.cursor.hasNext() && !this.isStopped()) {
            String json = this.data.cursor.next().toString();
            Object[] row = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int index = 0;
            row[index++] = json;
            this.putRow(this.data.outputRowMeta, row);
            return true;
        }
        this.setOutputDone();
        return false;
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.meta = (MongoDbInputMeta)stepMetaInterface;
            this.data = (MongoDbInputData)stepDataInterface;
            String hostname = this.environmentSubstitute(this.meta.getHostname());
            int port = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.meta.getDbName());
            String collection = this.environmentSubstitute(this.meta.getCollection());
            try {
                this.data.mongo = new Mongo(hostname, port);
                this.data.mongo.slaveOk();
                this.data.db = this.data.mongo.getDB(db);
                String realUser = this.environmentSubstitute(this.meta.getAuthenticationUser());
                String realPass = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getAuthenticationPassword()));
                if (!(Const.isEmpty((String)realUser) && Const.isEmpty((String)realPass) || this.data.db.authenticate(realUser, realPass.toCharArray()))) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorAuthenticating.Exception", (String[])new String[0]));
                }
                this.data.collection = this.data.db.getCollection(collection);
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{hostname, "" + port, db, collection}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.cursor != null) {
            this.data.cursor.close();
        }
        if (this.data.mongo != null) {
            this.data.mongo.close();
        }
        super.dispose(smi, sdi);
    }
}

