/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInput;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Step(id="MongoDbInput", image="mongodb-input.png", name="MongoDb Input", description="Reads from a Mongo DB collection", categoryDescription="Big Data")
public class MongoDbInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MongoDbInputMeta.class;
    private String hostname;
    private String port;
    private String dbName;
    private String collection;
    private String jsonFieldName;
    private String fields;
    private String authenticationUser;
    private String authenticationPassword;
    private String jsonQuery;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        MongoDbInputMeta retval = (MongoDbInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.hostname = XMLHandler.getTagValue((Node)stepnode, (String)"hostname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.dbName = XMLHandler.getTagValue((Node)stepnode, (String)"db_name");
            this.fields = XMLHandler.getTagValue((Node)stepnode, (String)"fields_name");
            this.collection = XMLHandler.getTagValue((Node)stepnode, (String)"collection");
            this.jsonFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"json_field_name");
            this.jsonQuery = XMLHandler.getTagValue((Node)stepnode, (String)"json_query");
            this.authenticationUser = XMLHandler.getTagValue((Node)stepnode, (String)"auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.hostname = "localhost";
        this.port = "27017";
        this.dbName = "db";
        this.collection = "collection";
        this.jsonFieldName = "json";
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta jsonValueMeta = new ValueMeta(this.jsonFieldName, 2);
        jsonValueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)jsonValueMeta);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"db_name", (String)this.dbName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fields_name", (String)this.fields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"collection", (String)this.collection));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_field_name", (String)this.jsonFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_query", (String)this.jsonQuery));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        return retval.toString();
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.hostname = rep.getStepAttributeString(id_step, "hostname");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.dbName = rep.getStepAttributeString(id_step, "db_name");
            this.fields = rep.getStepAttributeString(id_step, "fields_name");
            this.collection = rep.getStepAttributeString(id_step, "collection");
            this.jsonFieldName = rep.getStepAttributeString(id_step, "json_field_name");
            this.jsonQuery = rep.getStepAttributeString(id_step, "json_query");
            this.authenticationUser = rep.getStepAttributeString(id_step, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "hostname", this.hostname);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "db_name", this.dbName);
            rep.saveStepAttribute(id_transformation, id_step, "fields_name", this.fields);
            rep.saveStepAttribute(id_transformation, id_step, "collection", this.collection);
            rep.saveStepAttribute(id_transformation, id_step, "json_field_name", this.jsonFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "json_query", this.jsonQuery);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.authenticationUser);
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MongoDbInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new MongoDbInputData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getFieldsName() {
        return this.fields;
    }

    public void setFieldsName(String fields) {
        this.fields = fields;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getJsonFieldName() {
        return this.jsonFieldName;
    }

    public void setJsonFieldName(String jsonFieldName) {
        this.jsonFieldName = jsonFieldName;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }
}

