/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.vfs.KettleVFS;

public class PluginPropertiesUtil {
    public static final String PLUGIN_PROPERTIES_FILE = "plugin.properties";
    private static final String VERSION_PLACEHOLDER = "@VERSION@";

    protected Properties loadProperties(PluginInterface plugin, String relativeName) throws KettleFileException, IOException {
        if (plugin == null) {
            throw new NullPointerException();
        }
        FileObject propFile = KettleVFS.getFileObject((String)(plugin.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + relativeName));
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        Properties p = new Properties();
        p.load(KettleVFS.getInputStream((FileObject)propFile));
        return p;
    }

    public Properties loadPluginProperties(PluginInterface plugin) throws KettleFileException, IOException {
        return this.loadProperties(plugin, PLUGIN_PROPERTIES_FILE);
    }

    public String getVersion() {
        String version = "1.3.0";
        return VERSION_PLACEHOLDER.equals(version) ? null : version;
    }
}

