/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.cellinput;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInputData;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInputMeta;

public class PaloCellInput
extends BaseStep
implements StepInterface {
    private PaloCellInputMeta meta;
    private PaloCellInputData data;
    private ListenerWithException listener;

    public PaloCellInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public final boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.logBasic("Getting row meta.");
        final RowMetaInterface rowMeta = this.data.helper.getCellRowMeta(this.meta.getCube(), this.meta.getFields(), this.meta.getCubeMeasure());
        this.logBasic("Number of fields:" + this.meta.getFields().size());
        this.logBasic("Row Meta Size: " + rowMeta.size());
        this.logBasic("Creating Listener.");
        this.listener = new ListenerWithException(){
            private boolean stop = false;
            private boolean cancel = false;

            public void oneMoreElement(Object element) {
                Object[] row = (Object[])element;
                try {
                    assert (rowMeta.size() != row.length);
                    PaloCellInput.this.incrementLinesInput();
                    PaloCellInput.this.putRow(rowMeta, row);
                }
                catch (Exception ex) {
                    this.throwedException = ex;
                    this.cancel();
                }
            }

            public void prepareElements(int maxNumberOfElements) {
            }

            public void stop() {
                this.stop = true;
            }

            public void resume() {
                this.stop = false;
            }

            public boolean getStop() {
                return this.stop;
            }

            public void cancel() {
                this.cancel = true;
            }

            public boolean getCancel() {
                return this.cancel;
            }
        };
        this.data.helper.getCells(this.meta.getCube(), rowMeta, (PaloHelper.Listener)this.listener);
        if (this.listener.throwedException != null) {
            throw new KettleException("Failed to process some row", (Throwable)this.listener.throwedException);
        }
        this.setOutputDone();
        return false;
    }

    public void pauseRunning() {
        this.listener.stop();
        this.logDebug("Process Stopped");
    }

    public void stopAll() {
        this.listener.cancel();
        this.logDebug("Process Cancelled");
    }

    public void resumeRunning() {
        this.listener.resume();
        this.logDebug("Process Resumed");
    }

    public final boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloCellInputMeta)smi;
        this.data = (PaloCellInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Meta Fields: " + this.meta.getFields().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta());
                this.data.helper.connect();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.helper.disconnect();
        super.dispose(smi, sdi);
    }

    private abstract class ListenerWithException
    implements PaloHelper.Listener {
        protected Exception throwedException = null;

        private ListenerWithException() {
        }
    }
}

