/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.celloutput;

import java.util.ArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputData;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputMeta;

public class PaloCellOutput
extends BaseStep
implements StepInterface {
    private PaloCellOutputMeta meta;
    private PaloCellOutputData data;

    public PaloCellOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public final boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PaloCellOutputMeta)smi;
        this.data = (PaloCellOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.logDebug("No More Rows.");
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.logBasic("First Row Analysis.");
            this.data.indexes = new int[this.meta.getFields().size() + 1];
            for (int i = 0; i < this.data.indexes.length - 1; ++i) {
                this.data.indexes[i] = this.getInputRowMeta().indexOfValue(this.meta.getFields().get(i).getFieldName());
            }
            this.data.indexes[this.data.indexes.length - 1] = this.getInputRowMeta().indexOfValue(this.meta.getMeasure().getFieldName());
            this.logBasic("First Row Ok.");
            if (this.meta.getClearCube()) {
                try {
                    this.data.helper.clearCube(this.meta.getCube());
                }
                catch (Exception ex) {
                    throw new KettleException("Failed to clear Cube");
                }
            }
        }
        String row = "";
        try {
            Object[] newRow = new Object[this.meta.getFields().size() + 1];
            for (int i = 0; i < this.data.indexes.length; ++i) {
                if (i == this.data.indexes.length - 1) {
                    if (this.meta.getMeasureType().equals("Numeric")) {
                        newRow[i] = this.getInputRowMeta().getNumber(r, this.data.indexes[i]);
                        continue;
                    }
                    newRow[i] = this.getInputRowMeta().getString(r, this.data.indexes[i]);
                    continue;
                }
                newRow[i] = this.getInputRowMeta().getString(r, this.data.indexes[i]);
            }
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            rows.add(newRow);
            try {
                this.data.helper.addCells(this.meta.getCube(), rows);
                this.incrementLinesOutput();
            }
            catch (Exception ex) {
                for (int k = 0; k < newRow.length; ++k) {
                    row = row + " " + this.getInputRowMeta().getString(r, k);
                }
                throw ex;
            }
        }
        catch (Exception e) {
            throw new KettleException("Failed to add Cell Row: " + row, (Throwable)e);
        }
        return true;
    }

    public final boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloCellOutputMeta)smi;
        this.data = (PaloCellOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Meta Fields: " + this.meta.getFields().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta());
                this.data.helper.connect();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.helper.disconnect();
        super.dispose(smi, sdi);
    }
}

