/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.dimoutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.palo.core.DimensionGroupingCollection;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputData;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputMeta;

public class PaloDimOutput
extends BaseStep
implements StepInterface {
    private PaloDimOutputMeta meta;
    private PaloDimOutputData data;
    private List<String[]> currentTransformationRows = null;

    public PaloDimOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public final boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PaloDimOutputMeta)smi;
        this.data = (PaloDimOutputData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            this.logBasic("First Row Analysis:");
            if (this.meta.getLevels().size() == 0) {
                throw new KettleException("Number of levels must be greater that 0 to process the rows");
            }
            this.logBasic("Number of defined levels: " + this.meta.getLevels().size());
            this.data.indexes = new int[this.meta.getLevels().size()];
            for (int i = 0; i < this.data.indexes.length; ++i) {
                String fieldName = this.meta.getLevels().get(i).getFieldName();
                int numRow = this.getInputRowMeta().indexOfValue(fieldName);
                if (numRow < 0) {
                    throw new KettleException("DimOutput: failed to find input row meta for ".concat(this.meta.getLevels().get(i).getLevelName()));
                }
                this.data.indexes[i] = numRow;
                this.logDebug(this.meta.getLevels().get(i).getLevelName() + " has index: " + numRow);
            }
        }
        if (r == null) {
            try {
                this.logBasic("All rows have been read. Looking for consolidations");
                this.logDebug("Read rows:" + this.currentTransformationRows.size());
                DimensionGroupingCollection newDimension = this.data.helper.getConsolidations(this.meta.getDimension(), this.currentTransformationRows);
                this.logBasic("Consolidations got.");
                this.logBasic(newDimension == null ? "Null Consolidations" : " Consolidations Ok");
                this.logBasic("Add Dimension " + this.meta.getDimension());
                this.data.helper.addDimension(this.meta.getDimension(), newDimension, this.meta.getCreateNewDimension(), this.meta.getClearDimension(), this.meta.getClearConsolidations(), this.meta.getElementType());
                this.logBasic("Dimension Added.");
                this.setOutputDone();
                return false;
            }
            catch (Exception e) {
                throw new KettleException("Failed to add dimension rows", (Throwable)e);
            }
        }
        try {
            String[] newRow = new String[this.meta.getLevels().size()];
            for (int i = 0; i < this.data.indexes.length; ++i) {
                newRow[i] = r[this.data.indexes[i]].toString();
            }
            this.incrementLinesOutput();
            this.currentTransformationRows.add(newRow);
        }
        catch (Exception e) {
            throw new KettleException("Failed to add row to the row buffer", (Throwable)e);
        }
        return true;
    }

    public final boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloDimOutputMeta)smi;
        this.data = (PaloDimOutputData)sdi;
        this.currentTransformationRows = new ArrayList<String[]>();
        if (super.init(smi, sdi)) {
            try {
                this.logBasic("Meta Levels:" + this.meta.getLevels().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta());
                this.data.helper.connect();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.helper.disconnect();
        super.dispose(smi, sdi);
    }
}

