/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.palo.cellinput;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInputData;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInputMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PaloCellInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    public static final String STRING_PALO_LIB_WARNING_PARAMETER = "PaloLibWarning";
    private static Class<?> PKG = PaloCellInputMeta.class;
    private final PaloCellInputMeta meta;
    private TableView tableViewFields;
    private Combo comboCube;
    private Text textStepName;
    private Text textMeasureName;
    private Label labelStepName;
    private Label labelMeasureName;
    private Button buttonGetDimensions;
    private Button buttonClearDimensions;
    private Label labelCube;
    private Button buttonOk;
    private Button buttonCancel;
    private Button buttonPreview;
    private CCombo addConnectionLine;
    private Label labelMeasureType;
    private Combo comboMeasureType;
    private ColumnInfo[] colinf;

    public PaloCellInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (PaloCellInputMeta)((Object)in);
    }

    public String open() {
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 2052);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelCube = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelCube.setLayoutData((Object)fd);
        this.comboCube = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboCube.setLayoutData((Object)fd);
        this.labelMeasureName = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboCube, margin);
        this.labelMeasureName.setLayoutData((Object)fd);
        this.textMeasureName = new Text((Composite)this.shell, 2052);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboCube, margin);
        this.textMeasureName.setLayoutData((Object)fd);
        this.labelMeasureType = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.textMeasureName, margin);
        this.labelMeasureType.setLayoutData((Object)fd);
        this.comboMeasureType = new Combo((Composite)this.shell, 12);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.textMeasureName, margin);
        this.comboMeasureType.setLayoutData((Object)fd);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaloCellInputDialog.this.meta.setChanged();
            }
        };
        this.colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 1, false, true), new ColumnInfo(this.getLocalizedColumn(1), 1, false), new ColumnInfo(this.getLocalizedColumn(2), 2, new String[]{"String", "Number"}, true)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2052, this.colinf, 10, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 280);
        this.tableViewFields.setBounds(5, 150, 477, 280);
        this.tableViewFields.setReadonly(true);
        this.tableViewFields.setSortable(false);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.comboMeasureType, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.buttonGetDimensions = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.comboMeasureType, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonGetDimensions.setLayoutData((Object)fd);
        this.buttonClearDimensions = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.buttonGetDimensions, margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonClearDimensions.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonPreview = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonPreview.setText(BaseMessages.getString((String)"System.Button.Preview"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonPreview, this.buttonCancel}, margin, null);
        this.buttonGetDimensions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.doGetDimensions();
            }
        });
        this.buttonClearDimensions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.doClearDimensions();
            }
        });
        this.comboCube.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.doSelectCube();
            }
        });
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.cancel();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.ok();
            }
        });
        this.buttonPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.preview();
            }
        });
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCellInputDialog.this.doSelectConnection(false);
            }
        });
        this.fillLocalizedData();
        this.fillStoredData();
        this.doSelectConnection(false);
        this.props.setLook((Control)this.tableViewFields);
        this.props.setLook((Control)this.comboCube);
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.textMeasureName);
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.labelMeasureName);
        this.props.setLook((Control)this.buttonGetDimensions);
        this.props.setLook((Control)this.buttonClearDimensions);
        this.props.setLook((Control)this.labelCube);
        this.props.setLook((Control)this.buttonOk);
        this.props.setLook((Control)this.buttonCancel);
        this.props.setLook((Control)this.buttonPreview);
        this.props.setLook((Control)this.addConnectionLine);
        this.props.setLook((Control)this.labelMeasureType);
        this.props.setLook((Control)this.comboMeasureType);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloCellInputDialog.this.cancel();
            }
        });
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        PaloCellInputDialog.showPaloLibWarningDialog(this.shell);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void fillStoredData() {
        int indexType;
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        this.tableViewFields.table.removeAll();
        if (this.meta.getFields().size() > 0) {
            for (DimensionField level : this.meta.getFields()) {
                this.tableViewFields.add(new String[]{level.getDimensionName(), level.getFieldName(), level.getFieldType()});
            }
            this.tableViewFields.setRowNums();
            this.tableViewFields.optWidth(true);
        }
        if (this.meta.getCube() != null) {
            this.comboCube.add(this.meta.getCube());
            this.comboCube.select(0);
        }
        this.comboMeasureType.setItems(new String[]{"String", "Number"});
        if (this.meta.getCubeMeasure() != null && this.meta.getCubeMeasure().getFieldType() != null && (indexType = this.comboMeasureType.indexOf(this.meta.getCubeMeasure().getFieldType())) >= 0) {
            this.comboMeasureType.select(indexType);
        }
        if (this.meta.getCubeMeasure() != null && this.meta.getCubeMeasure().getFieldName() != null) {
            this.textMeasureName.setText(this.meta.getCubeMeasure().getFieldName());
        }
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"PaloCellInputDialog.ColumnDimension", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"PaloCellInputDialog.ColumnField", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"PaloCellInputDialog.ColumnType", (String[])new String[0]);
            }
        }
        return "";
    }

    private void fillLocalizedData() {
        this.buttonGetDimensions.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.GetDimensions", (String[])new String[0]));
        this.buttonClearDimensions.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.ClearDimensions", (String[])new String[0]));
        this.labelCube.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.SelectCube", (String[])new String[0]));
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.StepName", (String[])new String[0]));
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.PaloCellInput", (String[])new String[0]));
        this.labelMeasureName.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.MeasureName", (String[])new String[0]));
        this.labelMeasureType.setText(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.MeasureType", (String[])new String[0]));
    }

    private void doClearDimensions() {
        this.tableViewFields.table.removeAll();
    }

    private void doGetDimensions() {
        try {
            if (this.comboCube.getText() != null && this.comboCube.getText() != "") {
                DatabaseMeta dbMeta;
                if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                    PaloCellInputData data = new PaloCellInputData(dbMeta);
                    data.helper.connect();
                    List cubeDimensions = data.helper.getCubeDimensions(this.comboCube.getText());
                    this.tableViewFields.table.removeAll();
                    for (int i = 0; i < cubeDimensions.size(); ++i) {
                        TableItem item = new TableItem(this.tableViewFields.table, 0);
                        item.setText(1, (String)cubeDimensions.get(i));
                        item.setText(2, (String)cubeDimensions.get(i));
                    }
                    this.tableViewFields.removeEmptyRows();
                    this.tableViewFields.setRowNums();
                    this.tableViewFields.optWidth(true);
                    this.tableViewFields.setReadonly(true);
                    data.helper.disconnect();
                }
            } else {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), new Exception(BaseMessages.getString(PKG, (String)"PaloCellInputDialog.SelectCubeFirstError", (String[])new String[0])));
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void doSelectCube() {
    }

    private void doSelectConnection(boolean clearCurrentData) {
        try {
            DatabaseMeta dbMeta;
            if (clearCurrentData) {
                this.tableViewFields.table.removeAll();
                this.comboCube.removeAll();
            }
            if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                PaloCellInputData data = new PaloCellInputData(dbMeta);
                data.helper.connect();
                List cubes = data.helper.getCubesNames();
                for (String cubeName : cubes) {
                    if (this.comboCube.indexOf(cubeName) != -1) continue;
                    this.comboCube.add(cubeName);
                }
                data.helper.disconnect();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloCellInputDialog.RetreiveCubesErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloCellInputDialog.RetreiveCubesError", (String[])new String[0]), ex);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.meta);
            this.dispose();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloCellInputDialog.FailedToSaveDataErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloCellInputDialog.FailedToSaveDataError", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public static void showPaloLibWarningDialog(Shell shell) {
        PropsUI props = PropsUI.getInstance();
        if ("Y".equalsIgnoreCase(props.getCustomParameter(STRING_PALO_LIB_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(shell, BaseMessages.getString(PKG, (String)"PaloCellInputDialog.PaloLibWarningDialog.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"PaloCellInputDialog.PaloLibWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"PaloCellInputDialog.PaloLibWarningDialog.Option1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"PaloCellInputDialog.PaloLibWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(props.getCustomParameter(STRING_PALO_LIB_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            props.setCustomParameter(STRING_PALO_LIB_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            props.saveProps();
        }
    }

    private void getInfo(PaloCellInputMeta myMeta) throws KettleException {
        this.stepname = this.textStepName.getText();
        ArrayList<DimensionField> fields = new ArrayList<DimensionField>();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            DimensionField field = new DimensionField(this.tableViewFields.table.getItem(i).getText(1), this.tableViewFields.table.getItem(i).getText(2), this.tableViewFields.table.getItem(i).getText(3));
            fields.add(field);
        }
        myMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        myMeta.setCubeMeasureName(new DimensionField("Measure", this.textMeasureName.getText(), this.comboMeasureType.getText()));
        myMeta.setLevels(fields);
        myMeta.setCube(this.comboCube.getText());
        myMeta.setChanged(true);
    }

    private void preview() {
        PaloCellInputMeta oneMeta = new PaloCellInputMeta();
        try {
            this.getInfo(oneMeta);
            if (oneMeta.getFields() == null || oneMeta.getFields().size() == 0) {
                throw new KettleException("Fields must be defined to do a preview");
            }
            for (DimensionField field : oneMeta.getFields()) {
                if (!Const.isEmpty((String)field.getFieldType())) continue;
                throw new KettleException("All fields must have an output type to do the preview");
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.textStepName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, 500, BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Message", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.textStepName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.textStepName.getText(), progressDialog.getPreviewRowsMeta(this.textStepName.getText()), progressDialog.getPreviewRows(this.textStepName.getText()), loggingText);
            prd.open();
        }
    }
}

