/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.palo.diminput;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.palo.core.PaloDimensionLevel;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.diminput.PaloDimInputData;
import org.pentaho.di.trans.steps.palo.diminput.PaloDimInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.palo.cellinput.PaloCellInputDialog;

public class PaloDimInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = PaloDimInputMeta.class;
    private final PaloDimInputMeta meta;
    private TableView tableViewFields;
    private Combo comboDimension;
    private Text textStepName;
    private Button buttonClearLevels;
    private Button buttonGetLevels;
    private Label labelStepName;
    private Label labelDimension;
    private Button buttonOk;
    private Button buttonCancel;
    private Button buttonPreview;
    private CCombo addConnectionLine;

    public PaloDimInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (PaloDimInputMeta)((Object)in);
    }

    public String open() {
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelDimension = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelDimension.setLayoutData((Object)fd);
        this.comboDimension = new Combo((Composite)this.shell, 8);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboDimension.setLayoutData((Object)fd);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaloDimInputDialog.this.meta.setChanged();
            }
        };
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 1, false, true), new ColumnInfo(this.getLocalizedColumn(1), 1, false, true), new ColumnInfo(this.getLocalizedColumn(2), 1, false, false), new ColumnInfo(this.getLocalizedColumn(3), 2, new String[]{"String", "Number"}, true)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2052, colinf, 10, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 280);
        this.tableViewFields.setBounds(5, 125, 477, 280);
        this.tableViewFields.setReadonly(true);
        this.tableViewFields.setSortable(false);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.comboDimension, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.buttonGetLevels = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.comboDimension, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonGetLevels.setLayoutData((Object)fd);
        this.buttonClearLevels = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.buttonGetLevels, margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonClearLevels.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonPreview = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonPreview.setText(BaseMessages.getString((String)"System.Button.Preview"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonPreview, this.buttonCancel}, margin, null);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.cancel();
            }
        });
        this.buttonPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.preview();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.ok();
            }
        });
        this.buttonClearLevels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.doClearLevels();
            }
        });
        this.buttonGetLevels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.doGetLevels();
            }
        });
        this.comboDimension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.doSelectDimension();
            }
        });
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloDimInputDialog.this.doSelectConnection(false);
            }
        });
        this.fillLocalizationData();
        this.fillStoredData();
        this.doSelectConnection(false);
        this.props.setLook((Control)this.tableViewFields);
        this.props.setLook((Control)this.comboDimension);
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.buttonClearLevels);
        this.props.setLook((Control)this.buttonGetLevels);
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.labelDimension);
        this.props.setLook((Control)this.buttonOk);
        this.props.setLook((Control)this.buttonCancel);
        this.props.setLook((Control)this.buttonPreview);
        this.props.setLook((Control)this.addConnectionLine);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloDimInputDialog.this.cancel();
            }
        });
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        PaloCellInputDialog.showPaloLibWarningDialog(this.shell);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"PaloDimInputDialog.ColumnLevelName", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"PaloDimInputDialog.ColumnLevelNumber", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"PaloDimInputDialog.ColumnField", (String[])new String[0]);
            }
            case 3: {
                return BaseMessages.getString(PKG, (String)"PaloDimInputDialog.ColumnType", (String[])new String[0]);
            }
        }
        return "";
    }

    private void fillLocalizationData() {
        this.labelDimension.setText(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.SelectDimension", (String[])new String[0]));
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.StepName", (String[])new String[0]));
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.PaloDimInput", (String[])new String[0]));
        this.buttonGetLevels.setText(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.GetLevels", (String[])new String[0]));
        this.buttonClearLevels.setText(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.ClearLevels", (String[])new String[0]));
    }

    private void fillStoredData() {
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.meta.getDimension() != null) {
            this.comboDimension.add(this.meta.getDimension());
            this.comboDimension.select(0);
        }
        this.tableViewFields.table.removeAll();
        if (this.meta.getLevels().size() > 0) {
            for (PaloDimensionLevel level : this.meta.getLevels()) {
                this.tableViewFields.add(new String[]{level.getLevelName(), String.valueOf(level.getLevelNumber()), level.getFieldName(), level.getFieldType()});
            }
            this.tableViewFields.setRowNums();
            this.tableViewFields.optWidth(true);
        }
    }

    private void doSelectConnection(boolean clearCurrentData) {
        try {
            DatabaseMeta dbMeta;
            if (clearCurrentData) {
                this.tableViewFields.table.removeAll();
                this.comboDimension.removeAll();
            }
            if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                PaloDimInputData data = new PaloDimInputData(dbMeta);
                data.helper.connect();
                List dimensions = data.helper.getDimensionsNames();
                for (String dimensionName : dimensions) {
                    if (this.comboDimension.indexOf(dimensionName) != -1) continue;
                    this.comboDimension.add(dimensionName);
                }
                data.helper.disconnect();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloDimInputDialog.RetreiveDimensionsErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloDimInputDialog.RetreiveDimensionsError", (String[])new String[0]), ex);
        }
    }

    private void doSelectDimension() {
    }

    private void doClearLevels() {
        this.tableViewFields.table.removeAll();
    }

    private void doGetLevels() {
        if (this.comboDimension.getText() != null && this.comboDimension.getText() != "") {
            try {
                DatabaseMeta dbMeta;
                if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
                    PaloDimInputData data = new PaloDimInputData(dbMeta);
                    this.tableViewFields.table.removeAll();
                    data.helper.connect();
                    List levels = data.helper.getDimensionLevels(this.comboDimension.getText());
                    for (PaloDimensionLevel level : levels) {
                        this.tableViewFields.add(new String[]{level.getLevelName(), String.valueOf(level.getLevelNumber()), level.getFieldName()});
                    }
                    this.tableViewFields.setRowNums();
                    this.tableViewFields.optWidth(true);
                    data.helper.disconnect();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(this.shell, BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Title"), BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message"), ex);
            }
        } else {
            new ErrorDialog(this.shell, BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Title"), BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message"), new Exception(BaseMessages.getString(PKG, (String)"PaloDimInputDialog.SelectDimensionFirstError", (String[])new String[0])));
        }
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.meta);
            this.dispose();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloDimInputDialog.FailedToSaveDataErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloDimInputDialog.FailedToSaveDataError", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getInfo(PaloDimInputMeta myMeta) throws KettleException {
        this.stepname = this.textStepName.getText();
        ArrayList<PaloDimensionLevel> levels = new ArrayList<PaloDimensionLevel>();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            PaloDimensionLevel level = new PaloDimensionLevel(this.tableViewFields.table.getItem(i).getText(1), Integer.parseInt(this.tableViewFields.table.getItem(i).getText(2)), this.tableViewFields.table.getItem(i).getText(3), this.tableViewFields.table.getItem(i).getText(4));
            levels.add(level);
        }
        myMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        myMeta.setLevels(levels);
        myMeta.setDimension(this.comboDimension.getText());
        myMeta.setChanged(true);
    }

    private void preview() {
        PaloDimInputMeta oneMeta = new PaloDimInputMeta();
        try {
            this.getInfo(oneMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloInputDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloInputDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.textStepName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, 500, BaseMessages.getString((String)"System.Dialog.EnterPreviewSize.Title"), BaseMessages.getString((String)"System.Dialog.EnterPreviewSize.Message"));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.textStepName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((String)"System.Dialog.PreviewError.Title"), BaseMessages.getString((String)"System.Dialog.PreviewError.Message"), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.textStepName.getText(), progressDialog.getPreviewRowsMeta(this.textStepName.getText()), progressDialog.getPreviewRows(this.textStepName.getText()), loggingText);
            prd.open();
        }
    }
}

