/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.springframework.beans.factory.InitializingBean;

public class CipherEncryptionService
implements IPasswordService,
InitializingBean {
    private String saltString = "_CyPh3r_";
    private String algorithm = "PBEWithMD5AndDES";
    private String encryptionKey = "P3ntah0C1ph3r";
    private final int saltLength = 8;
    private int iterations = 19;
    private AlgorithmParameterSpec paramSpec;
    private SecretKey secretKey;

    public void setSalt(String value) {
        this.saltString = value;
    }

    public String getSalt() {
        return this.saltString;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setEncryptionKey(String value) {
        this.encryptionKey = value;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setIterations(int value) {
        this.iterations = value;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void afterPropertiesSet() throws ObjectFactoryException {
        if (this.saltString == null || this.algorithm == null || this.encryptionKey == null) {
            throw new ObjectFactoryException("Required properties not set - need Salt, algorithm and encryption key");
        }
        if (this.saltString.length() != this.saltLength) {
            if (this.saltString.length() < 8) {
                this.saltString = (this.saltString + "!@#$%^&*").substring(0, 8);
            } else if (this.saltString.length() > 8) {
                this.saltString = this.saltString.substring(0, 8);
            }
        }
        byte[] saltBytes = this.saltString.getBytes();
        this.paramSpec = new PBEParameterSpec(saltBytes, this.getIterations());
        PBEKeySpec skeySpec = new PBEKeySpec(this.getEncryptionKey().toCharArray(), saltBytes, this.getIterations());
        try {
            this.secretKey = SecretKeyFactory.getInstance(this.getAlgorithm()).generateSecret(skeySpec);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ObjectFactoryException("Encryption requested not available");
        }
    }

    public String decrypt(String encryptedPassword) throws PasswordServiceException {
        try {
            Cipher decCipher = Cipher.getInstance(this.secretKey.getAlgorithm());
            decCipher.init(2, (Key)this.secretKey, this.paramSpec);
            byte[] toDecryptBytes = Base64.decodeBase64((byte[])encryptedPassword.getBytes());
            byte[] decryptedBytes = decCipher.doFinal(toDecryptBytes);
            return new String(decryptedBytes, LocaleHelper.getSystemEncoding());
        }
        catch (Exception ex) {
            throw new PasswordServiceException((Throwable)ex);
        }
    }

    public String encrypt(String clearPassword) throws PasswordServiceException {
        try {
            Cipher encCipher = Cipher.getInstance(this.secretKey.getAlgorithm());
            encCipher.init(1, (Key)this.secretKey, this.paramSpec);
            byte[] toEncryptBytes = clearPassword.getBytes(LocaleHelper.getSystemEncoding());
            byte[] encBytes = encCipher.doFinal(toEncryptBytes);
            byte[] base64Bytes = Base64.encodeBase64((byte[])encBytes);
            return new String(base64Bytes);
        }
        catch (Exception ex) {
            throw new PasswordServiceException((Throwable)ex);
        }
    }

    public static void main(String[] args) {
        block5: {
            CipherEncryptionService service = new CipherEncryptionService();
            try {
                service.afterPropertiesSet();
                if (args.length != 2) {
                    throw new IllegalArgumentException("Usage: CipherEncryptionService encrypt|decrypt password");
                }
                if (args[0].equalsIgnoreCase("encrypt")) {
                    System.out.println(service.encrypt(args[1]));
                    break block5;
                }
                if (args[0].equalsIgnoreCase("decrypt")) {
                    System.out.println(service.decrypt(args[1]));
                    break block5;
                }
                throw new IllegalArgumentException("Usage: CipherEncryptionService encrypt|decrypt password");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

