/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.pentaho.platform.engine.security.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.security.providers.encoding.PasswordEncoder;

public class DefaultPentahoPasswordEncoder
implements PasswordEncoder {
    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        Validate.notNull((Object)rawPass, (String)Messages.getString("DefaultPentahoPasswordEncoder.ERROR_0001_RAWPASS_CANNOT_BE_NULL"));
        return StringUtil.isEmpty((String)rawPass) ? rawPass : new String(Base64.encodeBase64((byte[])rawPass.getBytes()));
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        Validate.notNull((Object)encPass, (String)Messages.getString("DefaultPentahoPasswordEncoder.ERROR_0002_ENCPASS_CANNOT_BE_NULL"));
        Validate.notNull((Object)rawPass, (String)Messages.getString("DefaultPentahoPasswordEncoder.ERROR_0001_RAWPASS_CANNOT_BE_NULL"));
        String encodedRawPass = this.encodePassword(rawPass, salt);
        return encPass.equals(encodedRawPass);
    }
}

