/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.security.Principal;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class SecurityHelper {
    private static final Log logger = LogFactory.getLog(SecurityHelper.class);
    public static final String SESSION_PRINCIPAL = "SECURITY_PRINCIPAL";
    public static final String DefaultAnonymousRole = PentahoSystem.getSystemSetting((String)"anonymous-authentication/anonymous-role", (String)"Anonymous");
    public static final String DefaultAnonymousUser = PentahoSystem.getSystemSetting((String)"anonymous-authentication/anonymous-user", (String)"anonymousUser");

    public static Authentication getAuthentication(IPentahoSession session, boolean allowAnonymous) {
        Principal principal = (Principal)session.getAttribute(SESSION_PRINCIPAL);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("principal from IPentahoSession: " + principal));
            if (null != principal) {
                logger.debug((Object)("principal class: " + principal.getClass().getName()));
            }
        }
        if (principal instanceof Authentication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"principal is an instance of Authentication");
            }
            return (Authentication)principal;
        }
        if (principal != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"principal is not an instance of Authentication");
                logger.debug((Object)"attempting role fetch with username");
            }
            IUserDetailsRoleListService roleListService = PentahoSystem.getUserDetailsRoleListService();
            List roles = roleListService.getRolesForUser(principal.getName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rolesForUser from roleListService:" + roles));
            }
            if (!roles.isEmpty()) {
                GrantedAuthority[] grantedAuthorities = new GrantedAuthority[roles.size()];
                for (int i = 0; i < roles.size(); ++i) {
                    grantedAuthorities[i] = new GrantedAuthorityImpl((String)roles.get(i));
                }
                UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)principal.getName(), null, grantedAuthorities);
                return auth;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"either principal is null or user has no roles");
        }
        if (allowAnonymous) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"there is no principal in IPentahoSession");
                logger.debug((Object)"creating token with username anonymous and role Anonymous");
            }
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)DefaultAnonymousUser, null, (GrantedAuthority[])new GrantedAuthorityImpl[]{new GrantedAuthorityImpl(DefaultAnonymousRole)});
            return auth;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"there is no principal in IPentahoSession");
            logger.debug((Object)"and allowAnonymous is false");
        }
        return null;
    }

    public static Principal getPrincipal(IPentahoSession session) {
        Principal principal = (Principal)session.getAttribute(SESSION_PRINCIPAL);
        return principal;
    }

    public static void setPrincipal(Principal principal, IPentahoSession session) {
        session.setAttribute(SESSION_PRINCIPAL, (Object)principal);
    }

    public static boolean isPentahoAdministrator(IPentahoSession session) {
        IAclVoter voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)session);
        return voter.isPentahoAdministrator(session);
    }

    public static boolean isGranted(IPentahoSession session, GrantedAuthority role) {
        IAclVoter voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)session);
        return voter.isGranted(session, role);
    }

    public static boolean canHaveACLS(ISolutionFile aFile) {
        if (aFile.isDirectory()) {
            return true;
        }
        return PentahoSystem.getACLFileExtensionList().contains(aFile.getExtension());
    }

    public static boolean hasAccess(IAclHolder aHolder, int actionOperation, IPentahoSession session) {
        IAclVoter voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)session);
        int aclMask = -1;
        switch (actionOperation) {
            case 0: {
                aclMask = 1;
                break;
            }
            case 1: 
            case 2: {
                aclMask = 8;
                break;
            }
            case 3: {
                aclMask = 16;
                break;
            }
            case 4: {
                aclMask = 60;
                break;
            }
            default: {
                aclMask = 1;
            }
        }
        return voter.hasAccess(session, aHolder, aclMask);
    }

    public static boolean hasAccess(IAclSolutionFile aFile, int actionOperation, IPentahoSession session) {
        if (aFile == null) {
            return false;
        }
        if (!aFile.isDirectory()) {
            List extensionList = PentahoSystem.getACLFileExtensionList();
            String fName = aFile.getFileName();
            int posn = fName.lastIndexOf(46);
            if (posn >= 0) {
                if (extensionList.indexOf(fName.substring(posn)) < 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        IAclVoter voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)session);
        int aclMask = -1;
        switch (actionOperation) {
            case 1: {
                aclMask = 1;
                break;
            }
            case 60: {
                return SecurityHelper.isPentahoAdministrator(session);
            }
            case 2: {
                aclMask = 2;
                break;
            }
            case 4: {
                aclMask = 4;
                break;
            }
            case 8: {
                aclMask = 8;
                break;
            }
            case 16: {
                aclMask = 16;
                break;
            }
            case 32: {
                aclMask = 32;
                break;
            }
            default: {
                aclMask = 1;
            }
        }
        return voter.hasAccess(session, (IAclHolder)aFile, aclMask);
    }
}

