/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionMgr;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleUser;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.springframework.security.GrantedAuthorityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityPermissionMgr
implements IPermissionMgr {
    private static final SpringSecurityPermissionMgr singletonPermMgr = new SpringSecurityPermissionMgr();

    private SpringSecurityPermissionMgr() {
    }

    public static SpringSecurityPermissionMgr instance() {
        return singletonPermMgr;
    }

    public Map<IPermissionRecipient, IPermissionMask> getPermissions(Object domainInstance) {
        IAclHolder aclHolder = (IAclHolder)domainInstance;
        List aclList = aclHolder.getAccessControls();
        return this.transformEntries(aclList);
    }

    public Map<IPermissionRecipient, IPermissionMask> getEffectivePermissions(Object domainInstance) {
        IAclHolder aclHolder = (IAclHolder)domainInstance;
        List aclList = aclHolder.getEffectiveAccessControls();
        return this.transformEntries(aclList);
    }

    protected Map<IPermissionRecipient, IPermissionMask> transformEntries(List<IPentahoAclEntry> entriesFromHolder) {
        LinkedHashMap<IPermissionRecipient, IPermissionMask> permissionsMap = new LinkedHashMap<IPermissionRecipient, IPermissionMask>();
        for (IPentahoAclEntry pentahoAclEntry : entriesFromHolder) {
            Object permissionRecipient = null;
            if (pentahoAclEntry.getRecipient() instanceof GrantedAuthorityImpl) {
                GrantedAuthorityImpl grantedAuthorityImpl = (GrantedAuthorityImpl)pentahoAclEntry.getRecipient();
                permissionRecipient = new SimpleRole(grantedAuthorityImpl.toString());
            } else {
                permissionRecipient = pentahoAclEntry.getRecipient() instanceof SimpleRole ? new SimpleRole((String)pentahoAclEntry.getRecipient()) : new SimpleUser((String)pentahoAclEntry.getRecipient());
            }
            SimplePermissionMask permissionMask = new SimplePermissionMask(pentahoAclEntry.getMask());
            permissionsMap.put((IPermissionRecipient)permissionRecipient, permissionMask);
        }
        return permissionsMap;
    }

    public void setPermission(IPermissionRecipient permissionRecipient, IPermissionMask permission, Object object) {
        if (object == null || !(object instanceof IAclHolder)) {
            return;
        }
        IAclHolder aclHolder = (IAclHolder)object;
        PentahoAclEntry entry = new PentahoAclEntry();
        if (permissionRecipient instanceof SimpleRole) {
            entry.setRecipient(new GrantedAuthorityImpl(permissionRecipient.getName()));
        } else {
            entry.setRecipient(permissionRecipient.getName());
        }
        entry.addPermission(permission.getMask());
        aclHolder.getAccessControls().add(entry);
    }

    public void setPermissions(Map<IPermissionRecipient, IPermissionMask> permissionsMap, Object object) {
        if (object == null || !(object instanceof IAclHolder)) {
            return;
        }
        IAclHolder aclHolder = (IAclHolder)object;
        Set<Map.Entry<IPermissionRecipient, IPermissionMask>> mapEntrySet = permissionsMap.entrySet();
        ArrayList<PentahoAclEntry> aclList = new ArrayList<PentahoAclEntry>();
        for (Map.Entry<IPermissionRecipient, IPermissionMask> mapEntry : mapEntrySet) {
            PentahoAclEntry pentahoAclEntry = new PentahoAclEntry();
            IPermissionRecipient permissionRecipient = mapEntry.getKey();
            if (permissionRecipient instanceof SimpleRole) {
                pentahoAclEntry.setRecipient(new GrantedAuthorityImpl(permissionRecipient.getName()));
            } else {
                pentahoAclEntry.setRecipient(permissionRecipient.getName());
            }
            pentahoAclEntry.addPermission(mapEntry.getValue().getMask());
            aclList.add(pentahoAclEntry);
        }
        aclHolder.resetAccessControls(aclList);
    }
}

