/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import org.pentaho.platform.engine.security.messages.Messages;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;

public class UseridAttributeLdapContextMapper
extends LdapUserDetailsMapper {
    private String ldapUsernameAttribute = "samAccountName";

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, GrantedAuthority[] authorities) {
        String usernameAttributeValue = ctx.getStringAttribute(this.getLdapUsernameAttribute());
        if (usernameAttributeValue == null) {
            throw new IllegalStateException(Messages.getErrorString("UseridAttributeLdapContextMapper.ERROR_0001_ATTRIBUTE_NOT_FOUND", this.getLdapUsernameAttribute()));
        }
        UserDetails rtn = super.mapUserFromContext(ctx, usernameAttributeValue, authorities);
        return rtn;
    }

    public void setLdapUsernameAttribute(String value) {
        this.ldapUsernameAttribute = value;
    }

    public String getLdapUsernameAttribute() {
        return this.ldapUsernameAttribute;
    }
}

