/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls.voter;

import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;

public abstract class AbstractPentahoAclVoter
implements IAclVoter,
IPentahoInitializer {
    protected GrantedAuthority adminRole;

    public abstract Authentication getAuthentication(IPentahoSession var1);

    public GrantedAuthority getAdminRole() {
        return this.adminRole;
    }

    public void setAdminRole(GrantedAuthority value) {
        this.adminRole = value;
    }

    public void init(IPentahoSession session) {
        ISystemSettings settings = PentahoSystem.getSystemSettings();
        String roleName = settings.getSystemSetting("acl-voter/admin-role", "Admin");
        this.adminRole = new GrantedAuthorityImpl(roleName);
    }

    public boolean isPentahoAdministrator(IPentahoSession session) {
        return this.isGranted(session, this.adminRole);
    }

    public boolean isGranted(IPentahoSession session, GrantedAuthority role) {
        Authentication auth = this.getAuthentication(session);
        if (auth != null && auth.isAuthenticated()) {
            GrantedAuthority[] userAuths = auth.getAuthorities();
            if (userAuths == null) {
                return false;
            }
            for (GrantedAuthority element : userAuths) {
                if (!element.equals(role)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

