/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userrole;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.UserSession;
import org.pentaho.platform.engine.security.messages.Messages;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class UserDetailsRoleListService
implements InitializingBean,
IUserDetailsRoleListService {
    private IUserRoleListService userRoleListService;

    public void setUserRoleListService(IUserRoleListService value) {
        this.userRoleListService = value;
    }

    public IUserRoleListService getUserRoleListService() {
        return this.userRoleListService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.userRoleListService == null) {
            throw new Exception(Messages.getString("UserDetailsRoleListService.ERROR_0001_USERROLELISTSERVICE_NOT_SET"));
        }
        PentahoSystem.setUserDetailsRoleListService((IUserDetailsRoleListService)this);
    }

    public List getAllRoles() {
        GrantedAuthority[] auths;
        ArrayList<String> rtn = new ArrayList<String>();
        for (GrantedAuthority element : auths = this.userRoleListService.getAllAuthorities()) {
            rtn.add(element.getAuthority());
        }
        return rtn;
    }

    public List getAllUsers() {
        String[] users;
        ArrayList<String> rtn = new ArrayList<String>();
        for (String element : users = this.userRoleListService.getAllUsernames()) {
            rtn.add(element);
        }
        return rtn;
    }

    public List getAllUsersInRole(String role) {
        String[] users = this.userRoleListService.getUsernamesInRole((GrantedAuthority)new GrantedAuthorityImpl(role));
        ArrayList<String> rtn = new ArrayList<String>();
        for (String element : users) {
            rtn.add(element);
        }
        return rtn;
    }

    public List getRolesForUser(String userName) {
        GrantedAuthority[] auths;
        ArrayList<String> rtn = new ArrayList<String>();
        for (GrantedAuthority element : auths = this.userRoleListService.getAuthoritiesForUser(userName)) {
            rtn.add(element.getAuthority());
        }
        return rtn;
    }

    public IPentahoSession getEffectiveUserSession(String userName, IParameterProvider paramProvider) {
        UserSession session = new UserSession(userName, null, false, paramProvider);
        session.setAuthenticated(userName);
        GrantedAuthority[] auths = this.userRoleListService.getAuthoritiesForUser(userName);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userName, null, auths);
        session.setAttribute("SECURITY_PRINCIPAL", (Object)auth);
        session.doStartupActions(paramProvider);
        return session;
    }
}

