/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ReplicationTargetChooser;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.UserGroupInformation;

public class NamenodeFsck {
    public static final Log LOG = LogFactory.getLog((String)NameNode.class.getName());
    public static final String CORRUPT_STATUS = "is CORRUPT";
    public static final String HEALTHY_STATUS = "is HEALTHY";
    public static final String NONEXISTENT_STATUS = "does not exist";
    public static final String FAILURE_STATUS = "FAILED";
    private final NameNode namenode;
    private final NetworkTopology networktopology;
    private final int totalDatanodes;
    private final short minReplication;
    private final InetAddress remoteAddress;
    private String lostFound = null;
    private boolean lfInited = false;
    private boolean lfInitedOk = false;
    private boolean showFiles = false;
    private boolean showOpenFiles = false;
    private boolean showBlocks = false;
    private boolean showLocations = false;
    private boolean showRacks = false;
    private boolean doMove = false;
    private boolean doDelete = false;
    private String path = "/";
    private final Configuration conf;
    private final PrintWriter out;
    Random r = new Random();

    NamenodeFsck(Configuration conf, NameNode namenode, NetworkTopology networktopology, Map<String, String[]> pmap, PrintWriter out, int totalDatanodes, short minReplication, InetAddress remoteAddress) {
        this.conf = conf;
        this.namenode = namenode;
        this.networktopology = networktopology;
        this.out = out;
        this.totalDatanodes = totalDatanodes;
        this.minReplication = minReplication;
        this.remoteAddress = remoteAddress;
        for (String key : pmap.keySet()) {
            if (key.equals("path")) {
                this.path = pmap.get("path")[0];
                continue;
            }
            if (key.equals("move")) {
                this.doMove = true;
                continue;
            }
            if (key.equals("delete")) {
                this.doDelete = true;
                continue;
            }
            if (key.equals("files")) {
                this.showFiles = true;
                continue;
            }
            if (key.equals("blocks")) {
                this.showBlocks = true;
                continue;
            }
            if (key.equals("locations")) {
                this.showLocations = true;
                continue;
            }
            if (key.equals("racks")) {
                this.showRacks = true;
                continue;
            }
            if (!key.equals("openforwrite")) continue;
            this.showOpenFiles = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsck() {
        long startTime = System.currentTimeMillis();
        try {
            String msg = "FSCK started by " + UserGroupInformation.getCurrentUser() + " from " + this.remoteAddress + " for path " + this.path + " at " + new Date();
            LOG.info((Object)msg);
            this.out.println(msg);
            this.namenode.getNamesystem().logFsckEvent(this.path, this.remoteAddress);
            Result res = new Result(this.conf);
            HdfsFileStatus file = this.namenode.getFileInfo(this.path);
            if (file != null) {
                this.check(this.path, file, res);
                this.out.println(res);
                this.out.println(" Number of data-nodes:\t\t" + this.totalDatanodes);
                this.out.println(" Number of racks:\t\t" + this.networktopology.getNumOfRacks());
                this.out.println("FSCK ended at " + new Date() + " in " + (System.currentTimeMillis() - startTime) + " milliseconds");
                if (res.isHealthy()) {
                    this.out.print("\n\nThe filesystem under path '" + this.path + "' " + HEALTHY_STATUS);
                } else {
                    this.out.print("\n\nThe filesystem under path '" + this.path + "' " + CORRUPT_STATUS);
                }
            } else {
                this.out.print("\n\nPath '" + this.path + "' " + NONEXISTENT_STATUS);
            }
        }
        catch (Exception e) {
            String errMsg = "Fsck on path '" + this.path + "' " + FAILURE_STATUS;
            LOG.warn((Object)errMsg, (Throwable)e);
            this.out.println("FSCK ended at " + new Date() + " in " + (System.currentTimeMillis() - startTime) + " milliseconds");
            this.out.println(e.getMessage());
            this.out.print("\n\n" + errMsg);
        }
        finally {
            this.out.close();
        }
    }

    private void check(String parent, HdfsFileStatus file, Result res) throws IOException {
        String path = file.getFullName(parent);
        boolean isOpen = false;
        if (file.isDir()) {
            DirectoryListing thisListing;
            byte[] lastReturnedName = HdfsFileStatus.EMPTY_NAME;
            if (this.showFiles) {
                this.out.println(path + " <dir>");
            }
            res.totalDirs++;
            do {
                assert (lastReturnedName != null);
                thisListing = this.namenode.getListing(path, lastReturnedName);
                if (thisListing == null) {
                    return;
                }
                HdfsFileStatus[] files = thisListing.getPartialListing();
                for (int i = 0; i < files.length; ++i) {
                    this.check(path, files[i], res);
                }
                lastReturnedName = thisListing.getLastName();
            } while (thisListing.hasMore());
            return;
        }
        long fileLen = file.getLen();
        LocatedBlocks blocks = this.namenode.getNamesystem().getBlockLocations(path, 0L, fileLen, false, false);
        if (blocks == null) {
            return;
        }
        isOpen = blocks.isUnderConstruction();
        if (isOpen && !this.showOpenFiles) {
            res.totalOpenFilesSize += fileLen;
            res.totalOpenFilesBlocks += blocks.locatedBlockCount();
            res.totalOpenFiles++;
            return;
        }
        res.totalFiles++;
        res.totalSize += fileLen;
        res.totalBlocks += blocks.locatedBlockCount();
        if (this.showOpenFiles && isOpen) {
            this.out.print(path + " " + fileLen + " bytes, " + blocks.locatedBlockCount() + " block(s), OPENFORWRITE: ");
        } else if (this.showFiles) {
            this.out.print(path + " " + fileLen + " bytes, " + blocks.locatedBlockCount() + " block(s): ");
        } else {
            this.out.print('.');
        }
        if (res.totalFiles % 100L == 0L) {
            this.out.println();
            this.out.flush();
        }
        int missing = 0;
        int corrupt = 0;
        long missize = 0L;
        int underReplicatedPerFile = 0;
        int misReplicatedPerFile = 0;
        StringBuffer report = new StringBuffer();
        int i = 0;
        for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
            int missingRacks;
            Block block = lBlk.getBlock();
            boolean isCorrupt = lBlk.isCorrupt();
            String blkName = block.toString();
            DatanodeInfo[] locs = lBlk.getLocations();
            res.totalReplicas += locs.length;
            short targetFileReplication = file.getReplication();
            if (locs.length > targetFileReplication) {
                res.excessiveReplicas += locs.length - targetFileReplication;
                res.numOverReplicatedBlocks += 1L;
            }
            if (isCorrupt) {
                ++corrupt;
                res.corruptBlocks++;
                this.out.print("\n" + path + ": CORRUPT block " + block.getBlockName() + "\n");
            }
            if (locs.length >= this.minReplication) {
                res.numMinReplicatedBlocks++;
            }
            if (locs.length < targetFileReplication && locs.length > 0) {
                res.missingReplicas += targetFileReplication - locs.length;
                res.numUnderReplicatedBlocks += 1L;
                ++underReplicatedPerFile;
                if (!this.showFiles) {
                    this.out.print("\n" + path + ": ");
                }
                this.out.println(" Under replicated " + block + ". Target Replicas is " + targetFileReplication + " but found " + locs.length + " replica(s).");
            }
            if ((missingRacks = ReplicationTargetChooser.verifyBlockPlacement(lBlk, targetFileReplication, this.networktopology)) > 0) {
                res.numMisReplicatedBlocks++;
                ++misReplicatedPerFile;
                if (!this.showFiles) {
                    if (underReplicatedPerFile == 0) {
                        this.out.println();
                    }
                    this.out.print(path + ": ");
                }
                this.out.println(" Replica placement policy is violated for " + block + ". Block should be additionally replicated on " + missingRacks + " more rack(s).");
            }
            report.append(i + ". " + blkName + " len=" + block.getNumBytes());
            if (locs.length == 0) {
                report.append(" MISSING!");
                res.addMissing(block.toString(), block.getNumBytes());
                ++missing;
                missize += block.getNumBytes();
            } else {
                report.append(" repl=" + locs.length);
                if (this.showLocations || this.showRacks) {
                    StringBuffer sb = new StringBuffer("[");
                    for (int j = 0; j < locs.length; ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        if (this.showRacks) {
                            sb.append(NodeBase.getPath(locs[j]));
                            continue;
                        }
                        sb.append(locs[j]);
                    }
                    sb.append(']');
                    report.append(" " + sb.toString());
                }
            }
            report.append('\n');
            ++i;
        }
        if (missing > 0 || corrupt > 0) {
            if (!this.showFiles && missing > 0) {
                this.out.print("\n" + path + ": MISSING " + missing + " blocks of total size " + missize + " B.");
            }
            res.corruptFiles++;
            try {
                if (this.doMove && !isOpen) {
                    this.copyBlocksToLostFound(parent, file, blocks);
                }
                if (this.doDelete && !isOpen) {
                    LOG.warn((Object)("\n - deleting corrupted file " + path));
                    this.namenode.delete(path, true);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("error processing " + path + ": " + e.toString()));
            }
        }
        if (this.showFiles) {
            if (missing > 0) {
                this.out.print(" MISSING " + missing + " blocks of total size " + missize + " B\n");
            } else if (underReplicatedPerFile == 0 && misReplicatedPerFile == 0) {
                this.out.print(" OK\n");
            }
            if (this.showBlocks) {
                this.out.print(report.toString() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlocksToLostFound(String parent, HdfsFileStatus file, LocatedBlocks blocks) throws IOException {
        DFSClient dfs = new DFSClient(NameNode.getAddress(this.conf), this.conf);
        try {
            String errmsg;
            String target;
            String fullName;
            block18: {
                if (!this.lfInited) {
                    this.lostFoundInit(dfs);
                }
                if (!this.lfInitedOk) {
                    return;
                }
                fullName = file.getFullName(parent);
                target = this.lostFound + fullName;
                errmsg = "Failed to move " + fullName + " to /lost+found";
                if (this.namenode.mkdirs(target, file.getPermission())) break block18;
                LOG.warn((Object)errmsg);
                return;
            }
            try {
                int chain = 0;
                OutputStream fos = null;
                for (LocatedBlock lBlk : blocks.getLocatedBlocks()) {
                    LocatedBlock lblock = lBlk;
                    DatanodeInfo[] locs = lblock.getLocations();
                    if (locs == null || locs.length == 0) {
                        if (fos == null) continue;
                        fos.flush();
                        fos.close();
                        fos = null;
                        continue;
                    }
                    if (fos == null) {
                        fos = dfs.create(target + "/" + chain, true);
                        if (fos != null) {
                            ++chain;
                        } else {
                            throw new IOException(errmsg + ": could not store chain " + chain);
                        }
                    }
                    try {
                        this.copyBlock(dfs, lblock, fos);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOG.warn((Object)(" - could not copy block " + lblock.getBlock() + " to " + target));
                        fos.flush();
                        fos.close();
                        fos = null;
                    }
                }
                if (fos != null) {
                    fos.close();
                }
                LOG.warn((Object)("\n - copied corrupted file " + fullName + " to /lost+found"));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn((Object)(errmsg + ": " + e.getMessage()));
            }
        }
        finally {
            dfs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlock(DFSClient dfs, LocatedBlock lblock, OutputStream fos) throws Exception {
        int failures = 0;
        InetSocketAddress targetAddr = null;
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        Socket s = null;
        BlockReader blockReader = null;
        Block block = lblock.getBlock();
        while (s == null) {
            DatanodeInfo chosenNode;
            try {
                chosenNode = this.bestNode(dfs, lblock.getLocations(), deadNodes);
                targetAddr = NetUtils.createSocketAddr(chosenNode.getName());
            }
            catch (IOException ie) {
                if (failures >= 3) {
                    throw new IOException("Could not obtain block " + lblock);
                }
                LOG.info((Object)("Could not obtain block from any node:  " + ie));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                deadNodes.clear();
                ++failures;
                continue;
            }
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
                blockReader = DFSClient.RemoteBlockReader.newBlockReader(s, targetAddr.toString() + ":" + block.getBlockId(), block.getBlockId(), lblock.getBlockToken(), block.getGenerationStamp(), 0L, -1L, this.conf.getInt("io.file.buffer.size", 4096));
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to connect to " + targetAddr + ":" + ex));
                deadNodes.add(chosenNode);
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iex) {
                        // empty catch block
                    }
                }
                s = null;
            }
        }
        if (blockReader == null) {
            throw new Exception("Could not open data stream for " + lblock.getBlock());
        }
        byte[] buf = new byte[1024];
        int cnt = 0;
        boolean success = true;
        long bytesRead = 0L;
        try {
            while ((cnt = blockReader.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, cnt);
                bytesRead += (long)cnt;
            }
            if (bytesRead != block.getNumBytes()) {
                throw new IOException("Recorded block size is " + block.getNumBytes() + ", but datanode returned " + bytesRead + " bytes");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e1) {}
        }
        if (!success) {
            throw new Exception("Could not copy block data for " + lblock.getBlock());
        }
    }

    private DatanodeInfo bestNode(DFSClient dfs, DatanodeInfo[] nodes, TreeSet<DatanodeInfo> deadNodes) throws IOException {
        DatanodeInfo chosenNode;
        if (nodes == null || nodes.length - deadNodes.size() < 1) {
            throw new IOException("No live nodes contain current block");
        }
        while (deadNodes.contains(chosenNode = nodes[this.r.nextInt(nodes.length)])) {
        }
        return chosenNode;
    }

    private void lostFoundInit(DFSClient dfs) {
        this.lfInited = true;
        try {
            String lfName = "/lost+found";
            if (!dfs.exists(lfName)) {
                this.lfInitedOk = dfs.mkdirs(lfName);
                this.lostFound = lfName;
            } else if (!dfs.isDirectory(lfName)) {
                LOG.warn((Object)"Cannot use /lost+found : a regular file with this name exists.");
                this.lfInitedOk = false;
            } else {
                this.lostFound = lfName;
                this.lfInitedOk = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lfInitedOk = false;
        }
        if (this.lostFound == null) {
            LOG.warn((Object)"Cannot initialize /lost+found .");
            this.lfInitedOk = false;
        }
    }

    private static class Result {
        private List<String> missingIds = new ArrayList<String>();
        private long missingSize = 0L;
        private long corruptFiles = 0L;
        private long corruptBlocks = 0L;
        private long excessiveReplicas = 0L;
        private long missingReplicas = 0L;
        private long numOverReplicatedBlocks = 0L;
        private long numUnderReplicatedBlocks = 0L;
        private long numMisReplicatedBlocks = 0L;
        private long numMinReplicatedBlocks = 0L;
        private long totalBlocks = 0L;
        private long totalOpenFilesBlocks = 0L;
        private long totalFiles = 0L;
        private long totalOpenFiles = 0L;
        private long totalDirs = 0L;
        private long totalSize = 0L;
        private long totalOpenFilesSize = 0L;
        private long totalReplicas = 0L;
        final short replication;

        private Result(Configuration conf) {
            this.replication = (short)conf.getInt("dfs.replication", 3);
        }

        boolean isHealthy() {
            return this.missingIds.size() == 0 && this.corruptBlocks == 0L;
        }

        void addMissing(String id, long size) {
            this.missingIds.add(id);
            this.missingSize += size;
        }

        float getReplicationFactor() {
            if (this.totalBlocks == 0L) {
                return 0.0f;
            }
            return (float)this.totalReplicas / (float)this.totalBlocks;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("Status: " + (this.isHealthy() ? "HEALTHY" : "CORRUPT"));
            res.append("\n Total size:\t" + this.totalSize + " B");
            if (this.totalOpenFilesSize != 0L) {
                res.append(" (Total open files size: " + this.totalOpenFilesSize + " B)");
            }
            res.append("\n Total dirs:\t" + this.totalDirs);
            res.append("\n Total files:\t" + this.totalFiles);
            if (this.totalOpenFiles != 0L) {
                res.append(" (Files currently being written: " + this.totalOpenFiles + ")");
            }
            res.append("\n Total blocks (validated):\t" + this.totalBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (avg. block size " + this.totalSize / this.totalBlocks + " B)");
            }
            if (this.totalOpenFilesBlocks != 0L) {
                res.append(" (Total open file blocks (not validated): " + this.totalOpenFilesBlocks + ")");
            }
            if (this.corruptFiles > 0L) {
                res.append("\n  ********************************");
                res.append("\n  CORRUPT FILES:\t" + this.corruptFiles);
                if (this.missingSize > 0L) {
                    res.append("\n  MISSING BLOCKS:\t" + this.missingIds.size());
                    res.append("\n  MISSING SIZE:\t\t" + this.missingSize + " B");
                }
                if (this.corruptBlocks > 0L) {
                    res.append("\n  CORRUPT BLOCKS: \t" + this.corruptBlocks);
                }
                res.append("\n  ********************************");
            }
            res.append("\n Minimally replicated blocks:\t" + this.numMinReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numMinReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Over-replicated blocks:\t" + this.numOverReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numOverReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Under-replicated blocks:\t" + this.numUnderReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numUnderReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Mis-replicated blocks:\t\t" + this.numMisReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numMisReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Default replication factor:\t" + this.replication);
            res.append("\n Average block replication:\t" + this.getReplicationFactor());
            res.append("\n Corrupt blocks:\t\t" + this.corruptBlocks);
            res.append("\n Missing replicas:\t\t" + this.missingReplicas);
            if (this.totalReplicas > 0L) {
                res.append(" (" + (float)(this.missingReplicas * 100L) / (float)this.totalReplicas + " %)");
            }
            return res.toString();
        }
    }
}

