/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    static final String QUEUE_STATE_SUFFIX = "state";
    static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    static final String QUEUE_ACLS_FILE_NAME = "mapred-queue-acls.xml";
    private boolean aclsEnabled;
    final HashMap<String, Queue> queues = new HashMap();

    public QueueManager(Configuration conf) {
        this.checkDeprecation(conf);
        conf.addResource(QUEUE_ACLS_FILE_NAME);
        this.aclsEnabled = conf.getBoolean("mapred.acls.enabled", false);
        this.queues.putAll(this.parseQueues(conf));
    }

    private synchronized Map<String, Queue> parseQueues(Configuration conf) {
        String[] queueNameValues;
        HashMap<String, Queue> queues = new HashMap<String, Queue>();
        for (String name : queueNameValues = conf.getStrings("mapred.queue.names", "default")) {
            queues.put(name, new Queue(name, this.getQueueAcls(name, conf), this.getQueueState(name, conf)));
        }
        return queues;
    }

    public synchronized Set<String> getQueues() {
        return this.queues.keySet();
    }

    public synchronized boolean hasAccess(String queueName, QueueACL qACL, UserGroupInformation ugi) {
        AccessControlList acl;
        if (!this.aclsEnabled) {
            return true;
        }
        Queue q = this.queues.get(queueName);
        if (null == q) {
            LOG.info((Object)("Queue " + queueName + " is not present"));
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checking access for : " + QueueManager.toFullPropertyName(queueName, qACL.getAclName())));
        }
        return (acl = q.getAcls().get(QueueManager.toFullPropertyName(queueName, qACL.getAclName()))) != null && acl.isUserAllowed(ugi);
    }

    synchronized boolean isRunning(String queueName) {
        Queue q = this.queues.get(queueName);
        return q != null && Queue.QueueState.RUNNING.equals((Object)q.getState());
    }

    public synchronized void setSchedulerInfo(String queueName, Object queueInfo) {
        Queue q = this.queues.get(queueName);
        if (q != null) {
            q.setSchedulingInfo(queueInfo);
        }
    }

    public synchronized Object getSchedulerInfo(String queueName) {
        Queue q = this.queues.get(queueName);
        return q != null ? q.getSchedulingInfo() : null;
    }

    synchronized void refreshQueues(Configuration conf) throws IOException {
        this.checkDeprecation(conf);
        conf.addResource(QUEUE_ACLS_FILE_NAME);
        Map<String, Queue> newQueues = this.parseQueues(conf);
        this.checkQueuesForDeletion(this.queues, newQueues);
        this.queues.clear();
        this.queues.putAll(newQueues);
        LOG.info((Object)("Queues acls, state and configs refreshed: " + this.queues.size() + " queues present now."));
    }

    private void checkQueuesForDeletion(Map<String, Queue> currentQueues, Map<String, Queue> newQueues) {
        for (String queue : currentQueues.keySet()) {
            if (newQueues.containsKey(queue)) continue;
            throw new IllegalArgumentException("Couldn't find queue '" + queue + "' during refresh!");
        }
        for (String queue : newQueues.keySet()) {
            if (currentQueues.containsKey(queue)) continue;
            newQueues.get(queue).setState(Queue.QueueState.STOPPED);
        }
    }

    private void checkDeprecation(Configuration conf) {
        String[] queues = conf.getStrings("mapred.queue.names");
        if (queues != null) {
            for (String queue : queues) {
                for (QueueACL oper : QueueACL.values()) {
                    String aclString = conf.get(QueueManager.toFullPropertyName(queue, oper.getAclName()));
                    if (aclString == null) continue;
                    LOG.warn((Object)"Configuring queue ACLs in mapred-site.xml or hadoop-site.xml is deprecated. Configure queue ACLs in mapred-queue-acls.xml");
                    return;
                }
            }
        }
    }

    HashMap<String, AccessControlList> getQueueAcls(String name, Configuration conf) {
        HashMap<String, AccessControlList> map = new HashMap<String, AccessControlList>();
        for (QueueACL oper : QueueACL.values()) {
            String aclKey = QueueManager.toFullPropertyName(name, oper.getAclName());
            map.put(aclKey, new AccessControlList(conf.get(aclKey, "*")));
        }
        return map;
    }

    Queue.QueueState getQueueState(String name, Configuration conf) {
        return conf.getEnum(QueueManager.toFullPropertyName(name, QUEUE_STATE_SUFFIX), Queue.QueueState.RUNNING);
    }

    static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    synchronized JobQueueInfo getJobQueueInfo(String queue) {
        Queue q = this.queues.get(queue);
        if (q != null) {
            JobQueueInfo qInfo = new JobQueueInfo();
            qInfo.setQueueName(q.getName());
            qInfo.setQueueState(q.getState().getStateName());
            Object schedInfo = q.getSchedulingInfo();
            qInfo.setSchedulingInfo(schedInfo == null ? null : schedInfo.toString());
            return qInfo;
        }
        return null;
    }

    synchronized JobQueueInfo[] getJobQueueInfos() {
        ArrayList<JobQueueInfo> ret = new ArrayList<JobQueueInfo>();
        for (String qName : this.getQueues()) {
            ret.add(this.getJobQueueInfo(qName));
        }
        return ret.toArray(new JobQueueInfo[ret.size()]);
    }

    synchronized QueueAclsInfo[] getQueueAcls(UserGroupInformation ugi) throws IOException {
        ArrayList<QueueAclsInfo> queueAclsInfolist = new ArrayList<QueueAclsInfo>();
        QueueACL[] acls = QueueACL.values();
        for (String queueName : this.getQueues()) {
            QueueAclsInfo queueAclsInfo = null;
            ArrayList<String> operationsAllowed = null;
            for (QueueACL qACL : acls) {
                if (!this.hasAccess(queueName, qACL, ugi)) continue;
                if (operationsAllowed == null) {
                    operationsAllowed = new ArrayList<String>();
                }
                operationsAllowed.add(qACL.getAclName());
            }
            if (operationsAllowed == null) continue;
            queueAclsInfo = new QueueAclsInfo(queueName, operationsAllowed.toArray(new String[operationsAllowed.size()]));
            queueAclsInfolist.add(queueAclsInfo);
        }
        return queueAclsInfolist.toArray(new QueueAclsInfo[queueAclsInfolist.size()]);
    }

    synchronized AccessControlList getQueueACL(String queueName, QueueACL qACL) {
        if (this.aclsEnabled) {
            Queue q = this.queues.get(queueName);
            assert (q != null);
            return q.getAcls().get(QueueManager.toFullPropertyName(queueName, qACL.getAclName()));
        }
        return new AccessControlList("*");
    }

    static void dumpConfiguration(Writer writer) throws IOException {
        Configuration conf = new Configuration(false);
        conf.addResource(QUEUE_ACLS_FILE_NAME);
        Configuration.dumpConfiguration(conf, writer);
    }

    static enum QueueACL {
        SUBMIT_JOB("acl-submit-job"),
        ADMINISTER_JOBS("acl-administer-jobs");

        private final String aclName;

        private QueueACL(String aclName) {
            this.aclName = aclName;
        }

        final String getAclName() {
            return this.aclName;
        }
    }
}

