/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class analysejobhistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block26: {
            Comparator<JobHistory.Task> cFinishMapRed;
            Comparator<JobHistory.Task> cShuffle;
            long avgShuffleTime;
            long avgReduceTime;
            JobHistory.Task[] reduceTasks;
            JobHistory.JobInfo job;
            int showTasks;
            String encodedLogFileName;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block25: {
                block24: {
                    String jobid;
                    block23: {
                        String logFile;
                        ServletContext application;
                        block22: {
                            PageContext pageContext = null;
                            HttpSession session = null;
                            application = null;
                            ServletConfig config = null;
                            out = null;
                            analysejobhistory_jsp page = this;
                            _jspx_out = null;
                            _jspx_page_context = null;
                            response.setContentType("text/html; charset=UTF-8");
                            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                            application = pageContext.getServletContext();
                            config = pageContext.getServletConfig();
                            session = pageContext.getSession();
                            _jspx_out = out = pageContext.getOut();
                            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                            out.write("\n\n\n");
                            out.write(10);
                            out.write("\n<html>\n");
                            logFile = request.getParameter("logFile");
                            if (logFile != null) break block22;
                            out.println("Missing job!!");
                            _jspxFactory.releasePageContext(_jspx_page_context);
                            return;
                        }
                        encodedLogFileName = JobHistory.JobInfo.encodeJobHistoryFilePath(logFile);
                        jobid = JSPUtil.getJobID(new Path(encodedLogFileName).getName());
                        String numTasks = request.getParameter("numTasks");
                        showTasks = 10;
                        if (numTasks != null) {
                            showTasks = Integer.parseInt(numTasks);
                        }
                        FileSystem fs = (FileSystem)application.getAttribute("fileSys");
                        JobTracker jobTracker = (JobTracker)application.getAttribute("job.tracker");
                        job = JSPUtil.checkAccessAndGetJobInfo(request, response, jobTracker, fs, new Path(logFile));
                        if (job != null) break block23;
                        _jspxFactory.releasePageContext(_jspx_page_context);
                        return;
                    }
                    out.write("\n<head>\n  <title>Analyze Job - Hadoop Job ");
                    out.print(jobid);
                    out.write("</title>\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n  <link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n</head>\n\n<body>\n<h2>Hadoop Job <a href=\"jobdetailshistory.jsp?logFile=");
                    out.print(encodedLogFileName);
                    out.write(34);
                    out.write(62);
                    out.print(jobid);
                    out.write(" </a></h2>\n<b>User : </b> ");
                    out.print(HtmlQuoting.quoteHtmlChars(job.get(JobHistory.Keys.USER)));
                    out.write("<br/> \n<b>JobName : </b> ");
                    out.print(HtmlQuoting.quoteHtmlChars(job.get(JobHistory.Keys.JOBNAME)));
                    out.write("<br/> \n<b>JobConf : </b> ");
                    out.print(job.get(JobHistory.Keys.JOBCONF));
                    out.write("<br/> \n<b>Submitted At : </b> ");
                    out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, job.getLong(JobHistory.Keys.SUBMIT_TIME), 0L));
                    out.write("<br/> \n<b>Launched At : </b> ");
                    out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, job.getLong(JobHistory.Keys.LAUNCH_TIME), job.getLong(JobHistory.Keys.SUBMIT_TIME)));
                    out.write("<br/>\n<b>Finished At : </b>  ");
                    out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, job.getLong(JobHistory.Keys.FINISH_TIME), job.getLong(JobHistory.Keys.LAUNCH_TIME)));
                    out.write("<br/>\n<b>Status : </b> ");
                    out.print(job.get(JobHistory.Keys.JOB_STATUS) == null ? "Incomplete" : job.get(JobHistory.Keys.JOB_STATUS));
                    out.write("<br/> \n<hr/>\n<center>\n");
                    if (JobHistory.Values.SUCCESS.name().equals(job.get(JobHistory.Keys.JOB_STATUS))) break block24;
                    out.print("<h3>No Analysis available as job did not finish</h3>");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                Map<String, JobHistory.Task> tasks = job.getAllTasks();
                int finishedMaps = job.getInt(JobHistory.Keys.FINISHED_MAPS);
                int finishedReduces = job.getInt(JobHistory.Keys.FINISHED_REDUCES);
                JobHistory.Task[] mapTasks = new JobHistory.Task[finishedMaps];
                reduceTasks = new JobHistory.Task[finishedReduces];
                int mapIndex = 0;
                int reduceIndex = 0;
                long avgMapTime = 0L;
                avgReduceTime = 0L;
                avgShuffleTime = 0L;
                block9: for (JobHistory.Task task : tasks.values()) {
                    Map<String, JobHistory.TaskAttempt> attempts = task.getTaskAttempts();
                    for (JobHistory.TaskAttempt attempt : attempts.values()) {
                        if (!attempt.get(JobHistory.Keys.TASK_STATUS).equals(JobHistory.Values.SUCCESS.name())) continue;
                        long avgFinishTime = attempt.getLong(JobHistory.Keys.FINISH_TIME) - attempt.getLong(JobHistory.Keys.START_TIME);
                        if (JobHistory.Values.MAP.name().equals(task.get(JobHistory.Keys.TASK_TYPE))) {
                            mapTasks[mapIndex++] = attempt;
                            avgMapTime += avgFinishTime;
                            continue block9;
                        }
                        if (!JobHistory.Values.REDUCE.name().equals(task.get(JobHistory.Keys.TASK_TYPE))) continue block9;
                        reduceTasks[reduceIndex++] = attempt;
                        avgShuffleTime += attempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED) - attempt.getLong(JobHistory.Keys.START_TIME);
                        avgReduceTime += attempt.getLong(JobHistory.Keys.FINISH_TIME) - attempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED);
                        continue block9;
                    }
                }
                if (finishedMaps > 0) {
                    avgMapTime /= (long)finishedMaps;
                }
                if (finishedReduces > 0) {
                    avgReduceTime /= (long)finishedReduces;
                    avgShuffleTime /= (long)finishedReduces;
                }
                Comparator<JobHistory.Task> cMap = new Comparator<JobHistory.Task>(){

                    @Override
                    public int compare(JobHistory.Task t1, JobHistory.Task t2) {
                        long l1 = t1.getLong(JobHistory.Keys.FINISH_TIME) - t1.getLong(JobHistory.Keys.START_TIME);
                        long l2 = t2.getLong(JobHistory.Keys.FINISH_TIME) - t2.getLong(JobHistory.Keys.START_TIME);
                        return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
                    }
                };
                cShuffle = new Comparator<JobHistory.Task>(){

                    @Override
                    public int compare(JobHistory.Task t1, JobHistory.Task t2) {
                        long l1 = t1.getLong(JobHistory.Keys.SHUFFLE_FINISHED) - t1.getLong(JobHistory.Keys.START_TIME);
                        long l2 = t2.getLong(JobHistory.Keys.SHUFFLE_FINISHED) - t2.getLong(JobHistory.Keys.START_TIME);
                        return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
                    }
                };
                cFinishMapRed = new Comparator<JobHistory.Task>(){

                    @Override
                    public int compare(JobHistory.Task t1, JobHistory.Task t2) {
                        long l1 = t1.getLong(JobHistory.Keys.FINISH_TIME);
                        long l2 = t2.getLong(JobHistory.Keys.FINISH_TIME);
                        return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
                    }
                };
                if (mapTasks.length > 0) {
                    Arrays.sort(mapTasks, cMap);
                    JobHistory.Task minMap = mapTasks[mapTasks.length - 1];
                    out.write("\n\n<h3>Time taken by best performing Map task \n<a href=\"taskdetailshistory.jsp?logFile=");
                    out.print(encodedLogFileName);
                    out.write("&tipid=");
                    out.print(minMap.get(JobHistory.Keys.TASKID));
                    out.write("\">\n");
                    out.print(minMap.get(JobHistory.Keys.TASKID));
                    out.write("</a> : ");
                    out.print(StringUtils.formatTimeDiff(minMap.getLong(JobHistory.Keys.FINISH_TIME), minMap.getLong(JobHistory.Keys.START_TIME)));
                    out.write("</h3>\n<h3>Average time taken by Map tasks: \n");
                    out.print(StringUtils.formatTimeDiff(avgMapTime, 0L));
                    out.write("</h3>\n<h3>Worse performing map tasks</h3>\n<table class=\"jobtasks datatable\">\n<thead>\n<tr><th>Task Id</th><th>Time taken</th></tr>\n</thead>\n<tbody>\n");
                    for (int i = 0; i < showTasks && i < mapTasks.length; ++i) {
                        out.write("\n    <tr>\n    <td><a href=\"taskdetailshistory.jsp?logFile=");
                        out.print(encodedLogFileName);
                        out.write("&tipid=");
                        out.print(mapTasks[i].get(JobHistory.Keys.TASKID));
                        out.write("\">\n        ");
                        out.print(mapTasks[i].get(JobHistory.Keys.TASKID));
                        out.write("</a></td>\n    <td>");
                        out.print(StringUtils.formatTimeDiff(mapTasks[i].getLong(JobHistory.Keys.FINISH_TIME), mapTasks[i].getLong(JobHistory.Keys.START_TIME)));
                        out.write("</td>\n    </tr>\n");
                    }
                    out.write("\n</tbody>\n</table>\n");
                    Arrays.sort(mapTasks, cFinishMapRed);
                    JobHistory.Task lastMap = mapTasks[0];
                    out.write("\n\n<h3>The last Map task \n<a href=\"taskdetailshistory.jsp?logFile=");
                    out.print(encodedLogFileName);
                    out.write("\n&tipid=");
                    out.print(lastMap.get(JobHistory.Keys.TASKID));
                    out.write(34);
                    out.write(62);
                    out.print(lastMap.get(JobHistory.Keys.TASKID));
                    out.write("</a> \nfinished at (relative to the Job launch time): \n");
                    out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, lastMap.getLong(JobHistory.Keys.FINISH_TIME), job.getLong(JobHistory.Keys.LAUNCH_TIME)));
                    out.write("</h3>\n<hr/>\n\n");
                }
                if (reduceTasks.length > 0) break block25;
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                Arrays.sort(reduceTasks, cShuffle);
                JobHistory.Task minShuffle = reduceTasks[reduceTasks.length - 1];
                out.write("\n<h3>Time taken by best performing shufflejobId\n<a href=\"taskdetailshistory.jsp?logFile=");
                out.print(encodedLogFileName);
                out.write("\n&tipid=");
                out.print(minShuffle.get(JobHistory.Keys.TASKID));
                out.write(34);
                out.write(62);
                out.print(minShuffle.get(JobHistory.Keys.TASKID));
                out.write("</a> : \n");
                out.print(StringUtils.formatTimeDiff(minShuffle.getLong(JobHistory.Keys.SHUFFLE_FINISHED), minShuffle.getLong(JobHistory.Keys.START_TIME)));
                out.write("</h3>\n<h3>Average time taken by Shuffle: \n");
                out.print(StringUtils.formatTimeDiff(avgShuffleTime, 0L));
                out.write("</h3>\n<h3>Worse performing Shuffle(s)</h3>\n<table class=\"jobtasks datatable\">\n<thead>\n<tr><th>Task Id</th><th>Time taken</th></tr>\n</thead><tbody>\n");
                for (int i = 0; i < showTasks && i < reduceTasks.length; ++i) {
                    out.write("\n    <tr>\n    <td><a href=\"taskdetailshistory.jsp?logFile=\n");
                    out.print(encodedLogFileName);
                    out.write("&tipid=");
                    out.print(reduceTasks[i].get(JobHistory.Keys.TASKID));
                    out.write("\">\n");
                    out.print(reduceTasks[i].get(JobHistory.Keys.TASKID));
                    out.write("</a></td>\n    <td>");
                    out.print(StringUtils.formatTimeDiff(reduceTasks[i].getLong(JobHistory.Keys.SHUFFLE_FINISHED), reduceTasks[i].getLong(JobHistory.Keys.START_TIME)));
                    out.write("\n    </td>\n    </tr>\n");
                }
                out.write("\n</tbody>\n</table>\n");
                Comparator<JobHistory.Task> cFinishShuffle = new Comparator<JobHistory.Task>(){

                    @Override
                    public int compare(JobHistory.Task t1, JobHistory.Task t2) {
                        long l1 = t1.getLong(JobHistory.Keys.SHUFFLE_FINISHED);
                        long l2 = t2.getLong(JobHistory.Keys.SHUFFLE_FINISHED);
                        return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
                    }
                };
                Arrays.sort(reduceTasks, cFinishShuffle);
                JobHistory.Task lastShuffle = reduceTasks[0];
                out.write("\n\n<h3>The last Shuffle  \n<a href=\"taskdetailshistory.jsp?logFile=");
                out.print(encodedLogFileName);
                out.write("\n&tipid=");
                out.print(lastShuffle.get(JobHistory.Keys.TASKID));
                out.write(34);
                out.write(62);
                out.print(lastShuffle.get(JobHistory.Keys.TASKID));
                out.write("\n</a> finished at (relative to the Job launch time): \n");
                out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, lastShuffle.getLong(JobHistory.Keys.SHUFFLE_FINISHED), job.getLong(JobHistory.Keys.LAUNCH_TIME)));
                out.write("</h3>\n\n");
                Comparator<JobHistory.Task> cReduce = new Comparator<JobHistory.Task>(){

                    @Override
                    public int compare(JobHistory.Task t1, JobHistory.Task t2) {
                        long l1 = t1.getLong(JobHistory.Keys.FINISH_TIME) - t1.getLong(JobHistory.Keys.SHUFFLE_FINISHED);
                        long l2 = t2.getLong(JobHistory.Keys.FINISH_TIME) - t2.getLong(JobHistory.Keys.SHUFFLE_FINISHED);
                        return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
                    }
                };
                Arrays.sort(reduceTasks, cReduce);
                JobHistory.Task minReduce = reduceTasks[reduceTasks.length - 1];
                out.write("\n<hr/>\n<h3>Time taken by best performing Reduce task : \n<a href=\"taskdetailshistory.jsp?logFile=");
                out.print(encodedLogFileName);
                out.write("&tipid=");
                out.print(minReduce.get(JobHistory.Keys.TASKID));
                out.write("\">\n");
                out.print(minReduce.get(JobHistory.Keys.TASKID));
                out.write("</a> : \n");
                out.print(StringUtils.formatTimeDiff(minReduce.getLong(JobHistory.Keys.FINISH_TIME), minReduce.getLong(JobHistory.Keys.SHUFFLE_FINISHED)));
                out.write("</h3>\n\n<h3>Average time taken by Reduce tasks: \n");
                out.print(StringUtils.formatTimeDiff(avgReduceTime, 0L));
                out.write("</h3>\n<h3>Worse performing reduce tasks</h3>\n<table class=\"jobtasks datatable\">\n<thead>\n<tr><th>Task Id</th><th>Time taken</th></tr>\n</thead>\n<tbody>\n");
                for (int i = 0; i < showTasks && i < reduceTasks.length; ++i) {
                    out.write("\n    <tr>\n    <td><a href=\"taskdetailshistory.jsp?logFile=");
                    out.print(encodedLogFileName);
                    out.write("&tipid=");
                    out.print(reduceTasks[i].get(JobHistory.Keys.TASKID));
                    out.write("\">\n        ");
                    out.print(reduceTasks[i].get(JobHistory.Keys.TASKID));
                    out.write("</a></td>\n    <td>");
                    out.print(StringUtils.formatTimeDiff(reduceTasks[i].getLong(JobHistory.Keys.FINISH_TIME), reduceTasks[i].getLong(JobHistory.Keys.SHUFFLE_FINISHED)));
                    out.write("</td>\n    </tr>\n");
                }
                out.write("\n</tbody>\n</table>\n");
                Arrays.sort(reduceTasks, cFinishMapRed);
                JobHistory.Task lastReduce = reduceTasks[0];
                out.write("\n\n<h3>The last Reduce task \n<a href=\"taskdetailshistory.jsp?logFile=");
                out.print(encodedLogFileName);
                out.write("\n&tipid=");
                out.print(lastReduce.get(JobHistory.Keys.TASKID));
                out.write(34);
                out.write(62);
                out.print(lastReduce.get(JobHistory.Keys.TASKID));
                out.write("\n</a> finished at (relative to the Job launch time): \n");
                out.print(StringUtils.getFormattedTimeWithDiff(dateFormat, lastReduce.getLong(JobHistory.Keys.FINISH_TIME), job.getLong(JobHistory.Keys.LAUNCH_TIME)));
                out.write("</h3>\n</center>\n</body></html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block26;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

