/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class taskdetailshistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printTaskAttempt(JobHistory.TaskAttempt taskAttempt, String type, JspWriter out, String logFile) throws Exception {
        out.print("<tr>");
        out.print("<td>" + taskAttempt.get(JobHistory.Keys.TASK_ATTEMPT_ID) + "</td>");
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, taskAttempt.getLong(JobHistory.Keys.START_TIME), 0L) + "</td>");
        if (JobHistory.Values.REDUCE.name().equals(type)) {
            JobHistory.ReduceAttempt reduceAttempt = (JobHistory.ReduceAttempt)taskAttempt;
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, reduceAttempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED), reduceAttempt.getLong(JobHistory.Keys.START_TIME)) + "</td>");
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, reduceAttempt.getLong(JobHistory.Keys.SORT_FINISHED), reduceAttempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED)) + "</td>");
        }
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, taskAttempt.getLong(JobHistory.Keys.FINISH_TIME), taskAttempt.getLong(JobHistory.Keys.START_TIME)) + "</td>");
        out.print("<td>" + taskAttempt.get(JobHistory.Keys.HOSTNAME) + "</td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars(taskAttempt.get(JobHistory.Keys.ERROR)) + "</td>");
        out.print("<td>");
        String taskLogsUrl = JobHistory.getTaskLogsUrl(taskAttempt);
        if (taskLogsUrl != null) {
            String tailFourKBUrl = taskLogsUrl + "&start=-4097";
            String tailEightKBUrl = taskLogsUrl + "&start=-8193";
            String entireLogUrl = taskLogsUrl + "&all=true";
            out.print("<a href=\"" + tailFourKBUrl + "\">Last 4KB</a><br/>");
            out.print("<a href=\"" + tailEightKBUrl + "\">Last 8KB</a><br/>");
            out.print("<a href=\"" + entireLogUrl + "\">All</a><br/>");
        } else {
            out.print("n/a");
        }
        out.print("</td>");
        Counters counters = Counters.fromEscapedCompactString(taskAttempt.get(JobHistory.Keys.COUNTERS));
        if (counters != null) {
            TaskAttemptID attemptId = TaskAttemptID.forName(taskAttempt.get(JobHistory.Keys.TASK_ATTEMPT_ID));
            TaskID tipid = attemptId.getTaskID();
            JobID jobId = tipid.getJobID();
            out.print("<td><a href=\"/taskstatshistory.jsp?attemptid=" + attemptId + "&logFile=" + logFile + "\">" + counters.size() + "</a></td>");
        } else {
            out.print("<td></td>");
        }
        out.print("</tr>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block16: {
            JobHistory.JobInfo job;
            String jobid;
            String encodedLogFileName;
            String tipid;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block15: {
                String logFile;
                ServletContext application;
                block14: {
                    PageContext pageContext = null;
                    HttpSession session = null;
                    application = null;
                    ServletConfig config = null;
                    out = null;
                    taskdetailshistory_jsp page = this;
                    _jspx_out = null;
                    _jspx_page_context = null;
                    response.setContentType("text/html; charset=UTF-8");
                    _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                    application = pageContext.getServletContext();
                    config = pageContext.getServletConfig();
                    session = pageContext.getSession();
                    _jspx_out = out = pageContext.getOut();
                    this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                    out.write("\n\n\n");
                    out.write(10);
                    out.write(10);
                    out.write(10);
                    logFile = request.getParameter("logFile");
                    tipid = request.getParameter("tipid");
                    if (logFile != null && tipid != null) break block14;
                    out.println("Missing job!!");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                encodedLogFileName = JobHistory.JobInfo.encodeJobHistoryFilePath(logFile);
                jobid = JSPUtil.getJobID(new Path(encodedLogFileName).getName());
                FileSystem fs = (FileSystem)application.getAttribute("fileSys");
                JobTracker jobTracker = (JobTracker)application.getAttribute("job.tracker");
                job = JSPUtil.checkAccessAndGetJobInfo(request, response, jobTracker, fs, new Path(logFile));
                if (job != null) break block15;
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                JobHistory.Task task = job.getAllTasks().get(tipid);
                String type = task.get(JobHistory.Keys.TASK_TYPE);
                out.write("\n<html>\n<head>\n<title>");
                out.print(tipid);
                out.write(" attempts for ");
                out.print(jobid);
                out.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n</head>\n<body>\n<h2>");
                out.print(tipid);
                out.write(" attempts for <a href=\"jobdetailshistory.jsp?logFile=");
                out.print(encodedLogFileName);
                out.write("\"> ");
                out.print(jobid);
                out.write(" </a></h2>\n<center>\n<table class=\"jobtasks datatable\">\n<thead>\n<tr><th>Task Id</th><th>Start Time</th>\n");
                if (JobHistory.Values.REDUCE.name().equals(type)) {
                    out.write("\n    <th>Shuffle Finished</th><th>Sort Finished</th>\n");
                }
                out.write("\n<th>Finish Time</th><th>Host</th><th>Error</th><th>Task Logs</th>\n<th>Counters</th></tr>\n</thead>\n<tbody>\n");
                for (JobHistory.TaskAttempt attempt : task.getTaskAttempts().values()) {
                    this.printTaskAttempt(attempt, type, out, encodedLogFileName);
                }
                out.write("\n</tbody>\n</table>\n</center>\n");
                if (JobHistory.Values.MAP.name().equals(type)) {
                    out.write("\n<h3>Input Split Locations</h3>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
                    for (String split : StringUtils.split(task.get(JobHistory.Keys.SPLITS))) {
                        out.println("<tr><td>" + split + "</td></tr>");
                    }
                    out.write("\n</table>    \n");
                }
                out.write(10);
                out.write("\n</body>\n</html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

