/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

public class SequenceFileAsBinaryInputFormat
extends SequenceFileInputFormat<BytesWritable, BytesWritable> {
    @Override
    public RecordReader<BytesWritable, BytesWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new SequenceFileAsBinaryRecordReader();
    }

    public static class SequenceFileAsBinaryRecordReader
    extends RecordReader<BytesWritable, BytesWritable> {
        private SequenceFile.Reader in;
        private long start;
        private long end;
        private boolean done = false;
        private DataOutputBuffer buffer = new DataOutputBuffer();
        private SequenceFile.ValueBytes vbytes;
        private BytesWritable key = null;
        private BytesWritable value = null;

        @Override
        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Path path = ((FileSplit)split).getPath();
            Configuration conf = context.getConfiguration();
            FileSystem fs = path.getFileSystem(conf);
            this.in = new SequenceFile.Reader(fs, path, conf);
            this.end = ((FileSplit)split).getStart() + split.getLength();
            if (((FileSplit)split).getStart() > this.in.getPosition()) {
                this.in.sync(((FileSplit)split).getStart());
            }
            this.start = this.in.getPosition();
            this.vbytes = this.in.createValueBytes();
            this.done = this.start >= this.end;
        }

        @Override
        public BytesWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        @Override
        public BytesWritable getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public String getKeyClassName() {
            return this.in.getKeyClassName();
        }

        public String getValueClassName() {
            return this.in.getValueClassName();
        }

        @Override
        public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
            boolean eof;
            if (this.done) {
                return false;
            }
            long pos = this.in.getPosition();
            boolean bl = eof = -1 == this.in.nextRawKey(this.buffer);
            if (!eof) {
                if (this.key == null) {
                    this.key = new BytesWritable();
                }
                if (this.value == null) {
                    this.value = new BytesWritable();
                }
                this.key.set(this.buffer.getData(), 0, this.buffer.getLength());
                this.buffer.reset();
                this.in.nextRawValue(this.vbytes);
                this.vbytes.writeUncompressedBytes(this.buffer);
                this.value.set(this.buffer.getData(), 0, this.buffer.getLength());
                this.buffer.reset();
            }
            this.done = eof || pos >= this.end && this.in.syncSeen();
            return !this.done;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            if (this.end == this.start) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)((double)(this.in.getPosition() - this.start) / (double)(this.end - this.start)));
        }
    }
}

