/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;

public class JobControl
implements Runnable {
    private ThreadState runnerState;
    private Map<String, ControlledJob> waitingJobs = new Hashtable<String, ControlledJob>();
    private Map<String, ControlledJob> readyJobs = new Hashtable<String, ControlledJob>();
    private Map<String, ControlledJob> runningJobs = new Hashtable<String, ControlledJob>();
    private Map<String, ControlledJob> successfulJobs = new Hashtable<String, ControlledJob>();
    private Map<String, ControlledJob> failedJobs = new Hashtable<String, ControlledJob>();
    private long nextJobID = -1L;
    private String groupName;

    public JobControl(String groupName) {
        this.groupName = groupName;
        this.runnerState = ThreadState.READY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ControlledJob> toList(Map<String, ControlledJob> jobs) {
        ArrayList<ControlledJob> retv = new ArrayList<ControlledJob>();
        Map<String, ControlledJob> map = jobs;
        synchronized (map) {
            for (ControlledJob job : jobs.values()) {
                retv.add(job);
            }
        }
        return retv;
    }

    public List<ControlledJob> getWaitingJobList() {
        return JobControl.toList(this.waitingJobs);
    }

    public List<ControlledJob> getRunningJobList() {
        return JobControl.toList(this.runningJobs);
    }

    public List<ControlledJob> getReadyJobsList() {
        return JobControl.toList(this.readyJobs);
    }

    public List<ControlledJob> getSuccessfulJobList() {
        return JobControl.toList(this.successfulJobs);
    }

    public List<ControlledJob> getFailedJobList() {
        return JobControl.toList(this.failedJobs);
    }

    private String getNextJobID() {
        ++this.nextJobID;
        return this.groupName + this.nextJobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToQueue(ControlledJob aJob, Map<String, ControlledJob> queue) {
        Map<String, ControlledJob> map = queue;
        synchronized (map) {
            queue.put(aJob.getJobID(), aJob);
        }
    }

    private void addToQueue(ControlledJob aJob) {
        Map<String, ControlledJob> queue = this.getQueue(aJob.getJobState());
        JobControl.addToQueue(aJob, queue);
    }

    private Map<String, ControlledJob> getQueue(ControlledJob.State state) {
        Map<String, ControlledJob> retv = null;
        if (state == ControlledJob.State.WAITING) {
            retv = this.waitingJobs;
        } else if (state == ControlledJob.State.READY) {
            retv = this.readyJobs;
        } else if (state == ControlledJob.State.RUNNING) {
            retv = this.runningJobs;
        } else if (state == ControlledJob.State.SUCCESS) {
            retv = this.successfulJobs;
        } else if (state == ControlledJob.State.FAILED || state == ControlledJob.State.DEPENDENT_FAILED) {
            retv = this.failedJobs;
        }
        return retv;
    }

    public synchronized String addJob(ControlledJob aJob) {
        String id = this.getNextJobID();
        aJob.setJobID(id);
        aJob.setJobState(ControlledJob.State.WAITING);
        this.addToQueue(aJob);
        return id;
    }

    public void addJobCollection(Collection<ControlledJob> jobs) {
        for (ControlledJob job : jobs) {
            this.addJob(job);
        }
    }

    public ThreadState getThreadState() {
        return this.runnerState;
    }

    public void stop() {
        this.runnerState = ThreadState.STOPPING;
    }

    public void suspend() {
        if (this.runnerState == ThreadState.RUNNING) {
            this.runnerState = ThreadState.SUSPENDED;
        }
    }

    public void resume() {
        if (this.runnerState == ThreadState.SUSPENDED) {
            this.runnerState = ThreadState.RUNNING;
        }
    }

    private synchronized void checkRunningJobs() throws IOException, InterruptedException {
        Map<String, ControlledJob> oldJobs = null;
        oldJobs = this.runningJobs;
        this.runningJobs = new Hashtable<String, ControlledJob>();
        for (ControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void checkWaitingJobs() throws IOException, InterruptedException {
        Map<String, ControlledJob> oldJobs = null;
        oldJobs = this.waitingJobs;
        this.waitingJobs = new Hashtable<String, ControlledJob>();
        for (ControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void startReadyJobs() {
        Map<String, ControlledJob> oldJobs = null;
        oldJobs = this.readyJobs;
        this.readyJobs = new Hashtable<String, ControlledJob>();
        for (ControlledJob nextJob : oldJobs.values()) {
            nextJob.submit();
            this.addToQueue(nextJob);
        }
    }

    public synchronized boolean allFinished() {
        return this.waitingJobs.size() == 0 && this.readyJobs.size() == 0 && this.runningJobs.size() == 0;
    }

    @Override
    public void run() {
        this.runnerState = ThreadState.RUNNING;
        while (true) {
            if (this.runnerState == ThreadState.SUSPENDED) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                this.checkRunningJobs();
                this.checkWaitingJobs();
                this.startReadyJobs();
            }
            catch (Exception e) {
                this.runnerState = ThreadState.STOPPED;
            }
            if (this.runnerState != ThreadState.RUNNING && this.runnerState != ThreadState.SUSPENDED) break;
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.runnerState != ThreadState.RUNNING && this.runnerState != ThreadState.SUSPENDED) break;
        }
        this.runnerState = ThreadState.STOPPED;
    }

    public static enum ThreadState {
        RUNNING,
        SUSPENDED,
        STOPPED,
        STOPPING,
        READY;

    }
}

