/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class MapFileOutputFormat
extends FileOutputFormat<WritableComparable<?>, Writable> {
    @Override
    public RecordWriter<WritableComparable<?>, Writable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (MapFileOutputFormat.getCompressOutput(context)) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType(context);
            Class<CompressionCodec> codecClass = MapFileOutputFormat.getOutputCompressorClass(context, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, conf);
        }
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        final MapFile.Writer out = new MapFile.Writer(conf, fs, file.toString(), context.getOutputKeyClass().asSubclass(WritableComparable.class), context.getOutputValueClass().asSubclass(Writable.class), compressionType, codec, (Progressable)context);
        return new RecordWriter<WritableComparable<?>, Writable>(){

            @Override
            public void write(WritableComparable<?> key, Writable value) throws IOException {
                out.append(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    public static MapFile.Reader[] getReaders(Path dir, Configuration conf) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        Object[] names = FileUtil.stat2Paths(fs.listStatus(dir));
        Arrays.sort(names);
        MapFile.Reader[] parts = new MapFile.Reader[names.length];
        for (int i = 0; i < names.length; ++i) {
            parts[i] = new MapFile.Reader(fs, ((Path)names[i]).toString(), conf);
        }
        return parts;
    }

    public static <K extends WritableComparable<?>, V extends Writable> Writable getEntry(MapFile.Reader[] readers, Partitioner<K, V> partitioner, K key, V value) throws IOException {
        int part = partitioner.getPartition(key, value, readers.length);
        return readers[part].get(key, value);
    }
}

