/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class InputSampler<K, V>
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(InputSampler.class);

    static int printUsage() {
        System.out.println("sampler -r <reduces>\n      [-inFormat <input format class>]\n      [-keyClass <map input & output key class>]\n      [-splitRandom <double pcnt> <numSamples> <maxsplits> |              // Sample from random splits at random (general)\n       -splitSample <numSamples> <maxsplits> |              // Sample from first records in splits (random data)\n       -splitInterval <double pcnt> <maxsplits>]             // Sample from splits at intervals (sorted data)");
        System.out.println("Default sampler: -splitRandom 0.1 10000 10");
        ToolRunner.printGenericCommandUsage(System.out);
        return -1;
    }

    public InputSampler(Configuration conf) {
        this.setConf(conf);
    }

    public static <K, V> void writePartitionFile(Job job, Sampler<K, V> sampler) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = job.getConfiguration();
        InputFormat<?, ?> inf = ReflectionUtils.newInstance(job.getInputFormatClass(), conf);
        int numPartitions = job.getNumReduceTasks();
        K[] samples = sampler.getSample(inf, job);
        LOG.info((Object)("Using " + samples.length + " samples"));
        RawComparator<?> comparator = job.getSortComparator();
        Arrays.sort(samples, comparator);
        Path dst = new Path(TotalOrderPartitioner.getPartitionFile(conf));
        FileSystem fs = dst.getFileSystem(conf);
        if (fs.exists(dst)) {
            fs.delete(dst, false);
        }
        SequenceFile.Writer writer = SequenceFile.createWriter(fs, conf, dst, job.getMapOutputKeyClass(), NullWritable.class);
        NullWritable nullValue = NullWritable.get();
        float stepSize = (float)samples.length / (float)numPartitions;
        int last = -1;
        for (int i = 1; i < numPartitions; ++i) {
            int k;
            for (k = Math.round(stepSize * (float)i); last >= k && comparator.compare(samples[last], samples[k]) == 0; ++k) {
            }
            writer.append(samples[k], (Object)nullValue);
            last = k;
        }
        writer.close();
    }

    @Override
    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf());
        ArrayList<String> otherArgs = new ArrayList<String>();
        Sampler sampler = null;
        for (int i = 0; i < args.length; ++i) {
            try {
                if ("-r".equals(args[i])) {
                    job.setNumReduceTasks(Integer.parseInt(args[++i]));
                    continue;
                }
                if ("-inFormat".equals(args[i])) {
                    job.setInputFormatClass(Class.forName(args[++i]).asSubclass(InputFormat.class));
                    continue;
                }
                if ("-keyClass".equals(args[i])) {
                    job.setMapOutputKeyClass(Class.forName(args[++i]).asSubclass(WritableComparable.class));
                    continue;
                }
                if ("-splitSample".equals(args[i])) {
                    int maxSplits;
                    int numSamples = Integer.parseInt(args[++i]);
                    if (0 >= (maxSplits = Integer.parseInt(args[++i]))) {
                        maxSplits = Integer.MAX_VALUE;
                    }
                    sampler = new SplitSampler(numSamples, maxSplits);
                    continue;
                }
                if ("-splitRandom".equals(args[i])) {
                    int maxSplits;
                    double pcnt = Double.parseDouble(args[++i]);
                    int numSamples = Integer.parseInt(args[++i]);
                    if (0 >= (maxSplits = Integer.parseInt(args[++i]))) {
                        maxSplits = Integer.MAX_VALUE;
                    }
                    sampler = new RandomSampler(pcnt, numSamples, maxSplits);
                    continue;
                }
                if ("-splitInterval".equals(args[i])) {
                    int maxSplits;
                    double pcnt = Double.parseDouble(args[++i]);
                    if (0 >= (maxSplits = Integer.parseInt(args[++i]))) {
                        maxSplits = Integer.MAX_VALUE;
                    }
                    sampler = new IntervalSampler(pcnt, maxSplits);
                    continue;
                }
                otherArgs.add(args[i]);
                continue;
            }
            catch (NumberFormatException except) {
                System.out.println("ERROR: Integer expected instead of " + args[i]);
                return InputSampler.printUsage();
            }
            catch (ArrayIndexOutOfBoundsException except) {
                System.out.println("ERROR: Required parameter missing from " + args[i - 1]);
                return InputSampler.printUsage();
            }
        }
        if (job.getNumReduceTasks() <= 1) {
            System.err.println("Sampler requires more than one reducer");
            return InputSampler.printUsage();
        }
        if (otherArgs.size() < 2) {
            System.out.println("ERROR: Wrong number of parameters: ");
            return InputSampler.printUsage();
        }
        if (null == sampler) {
            sampler = new RandomSampler(0.1, 10000, 10);
        }
        Path outf = new Path((String)otherArgs.remove(otherArgs.size() - 1));
        TotalOrderPartitioner.setPartitionFile(this.getConf(), outf);
        for (String s : otherArgs) {
            FileInputFormat.addInputPath(job, new Path(s));
        }
        InputSampler.writePartitionFile(job, sampler);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        InputSampler sampler = new InputSampler(new Configuration());
        int res = ToolRunner.run(sampler, args);
        System.exit(res);
    }

    public static class IntervalSampler<K, V>
    implements Sampler<K, V> {
        private final double freq;
        private final int maxSplitsSampled;

        public IntervalSampler(double freq) {
            this(freq, Integer.MAX_VALUE);
        }

        public IntervalSampler(double freq, int maxSplitsSampled) {
            this.freq = freq;
            this.maxSplitsSampled = maxSplitsSampled;
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, Job job) throws IOException, InterruptedException {
            List<InputSplit> splits = inf.getSplits(job);
            ArrayList samples = new ArrayList();
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.size());
            long records = 0L;
            long kept = 0L;
            for (int i = 0; i < splitsToSample; ++i) {
                TaskAttemptContext samplingContext = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
                RecordReader<K, V> reader = inf.createRecordReader(splits.get(i), samplingContext);
                reader.initialize(splits.get(i), samplingContext);
                while (reader.nextKeyValue()) {
                    if (!((double)kept / (double)(++records) < this.freq)) continue;
                    samples.add(ReflectionUtils.copy(job.getConfiguration(), reader.getCurrentKey(), null));
                    ++kept;
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static class RandomSampler<K, V>
    implements Sampler<K, V> {
        private double freq;
        private final int numSamples;
        private final int maxSplitsSampled;

        public RandomSampler(double freq, int numSamples) {
            this(freq, numSamples, Integer.MAX_VALUE);
        }

        public RandomSampler(double freq, int numSamples, int maxSplitsSampled) {
            this.freq = freq;
            this.numSamples = numSamples;
            this.maxSplitsSampled = maxSplitsSampled;
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, Job job) throws IOException, InterruptedException {
            int i;
            List<InputSplit> splits = inf.getSplits(job);
            ArrayList samples = new ArrayList(this.numSamples);
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.size());
            Random r = new Random();
            long seed = r.nextLong();
            r.setSeed(seed);
            LOG.debug((Object)("seed: " + seed));
            for (i = 0; i < splits.size(); ++i) {
                InputSplit tmp = splits.get(i);
                int j = r.nextInt(splits.size());
                splits.set(i, splits.get(j));
                splits.set(j, tmp);
            }
            for (i = 0; i < splitsToSample || i < splits.size() && samples.size() < this.numSamples; ++i) {
                TaskAttemptContext samplingContext = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
                RecordReader<K, V> reader = inf.createRecordReader(splits.get(i), samplingContext);
                reader.initialize(splits.get(i), samplingContext);
                while (reader.nextKeyValue()) {
                    if (!(r.nextDouble() <= this.freq)) continue;
                    if (samples.size() < this.numSamples) {
                        samples.add(ReflectionUtils.copy(job.getConfiguration(), reader.getCurrentKey(), null));
                        continue;
                    }
                    int ind = r.nextInt(this.numSamples);
                    if (ind != this.numSamples) {
                        samples.set(ind, ReflectionUtils.copy(job.getConfiguration(), reader.getCurrentKey(), null));
                    }
                    this.freq *= (double)(this.numSamples - 1) / (double)this.numSamples;
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static class SplitSampler<K, V>
    implements Sampler<K, V> {
        private final int numSamples;
        private final int maxSplitsSampled;

        public SplitSampler(int numSamples) {
            this(numSamples, Integer.MAX_VALUE);
        }

        public SplitSampler(int numSamples, int maxSplitsSampled) {
            this.numSamples = numSamples;
            this.maxSplitsSampled = maxSplitsSampled;
        }

        @Override
        public K[] getSample(InputFormat<K, V> inf, Job job) throws IOException, InterruptedException {
            List<InputSplit> splits = inf.getSplits(job);
            ArrayList samples = new ArrayList(this.numSamples);
            int splitsToSample = Math.min(this.maxSplitsSampled, splits.size());
            int samplesPerSplit = this.numSamples / splitsToSample;
            long records = 0L;
            for (int i = 0; i < splitsToSample; ++i) {
                TaskAttemptContext samplingContext = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
                RecordReader<K, V> reader = inf.createRecordReader(splits.get(i), samplingContext);
                reader.initialize(splits.get(i), samplingContext);
                while (reader.nextKeyValue()) {
                    samples.add(ReflectionUtils.copy(job.getConfiguration(), reader.getCurrentKey(), null));
                    if ((long)((i + 1) * samplesPerSplit) > ++records) continue;
                }
                reader.close();
            }
            return samples.toArray();
        }
    }

    public static interface Sampler<K, V> {
        public K[] getSample(InputFormat<K, V> var1, Job var2) throws IOException, InterruptedException;
    }
}

