/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.thirdparty.guava.common.base.Preconditions;

public class SocketInputWrapper
extends FilterInputStream {
    private final Socket socket;
    private final boolean hasChannel;

    SocketInputWrapper(Socket s, InputStream is) {
        super(is);
        this.socket = s;
        boolean bl = this.hasChannel = s.getChannel() != null;
        if (this.hasChannel) {
            Preconditions.checkArgument((boolean)(is instanceof SocketInputStream), (String)"Expected a SocketInputStream when there is a channel. Got: %s", (Object[])new Object[]{is});
        }
    }

    public void setTimeout(long timeoutMs) throws SocketException {
        if (this.hasChannel) {
            ((SocketInputStream)this.in).setTimeout(timeoutMs);
        } else {
            this.socket.setSoTimeout((int)timeoutMs);
        }
    }

    public ReadableByteChannel getReadableByteChannel() {
        Preconditions.checkState((boolean)this.hasChannel, (String)"Socket %s does not have a channel", (Object[])new Object[]{this.socket});
        return (SocketInputStream)this.in;
    }
}

