/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;

public class TableMapping
extends CachedDNSToSwitchMapping {
    public static final String MAPPING_FILE = "net.topology.table.file.name";
    private static final Log LOG = LogFactory.getLog(TableMapping.class);

    public TableMapping() {
        super(new RawTableMapping());
    }

    private RawTableMapping getRawMapping() {
        return (RawTableMapping)this.rawMapping;
    }

    public Configuration getConf() {
        return this.getRawMapping().getConf();
    }

    public void setConf(Configuration conf) {
        this.getRawMapping().setConf(conf);
    }

    private static final class RawTableMapping
    extends Configured
    implements DNSToSwitchMapping {
        private final Map<String, String> map = new HashMap<String, String>();
        private boolean initialized = false;

        private RawTableMapping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void load() {
            this.map.clear();
            String filename = this.getConf().get(TableMapping.MAPPING_FILE, null);
            if (StringUtils.isBlank((String)filename)) {
                LOG.warn((Object)"net.topology.table.file.name not configured. /default-rack will be returned.");
                return;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(filename));
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                        String[] columns = line.split("\\s+");
                        if (columns.length == 2) {
                            this.map.put(columns[0], columns[1]);
                        } else {
                            LOG.warn((Object)("Line does not have two columns. Ignoring. " + line));
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)(filename + " cannot be read. " + "/default-rack" + " will be returned."), (Throwable)e);
                this.map.clear();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)(filename + " cannot be read. " + "/default-rack" + " will be returned."), (Throwable)e);
                        this.map.clear();
                    }
                }
            }
        }

        @Override
        public synchronized List<String> resolve(List<String> names) {
            if (!this.initialized) {
                this.initialized = true;
                this.load();
            }
            ArrayList<String> results = new ArrayList<String>(names.size());
            for (String name : names) {
                String result = this.map.get(name);
                if (result != null) {
                    results.add(result);
                    continue;
                }
                results.add("/default-rack");
            }
            return results;
        }
    }
}

