/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.sun.security.auth.NTUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Shell;

public class UserGroupInformation {
    private static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    static UgiMetrics metrics = new UgiMetrics();
    private static boolean isInitialized = false;
    private static boolean useKerberos;
    private static Groups groups;
    private static Configuration conf;
    private static final long MIN_TIME_BEFORE_RELOGIN = 600000L;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    private static UserGroupInformation loginUser;
    private static String keytabPrincipal;
    private static String keytabFile;
    private final Subject subject;
    private final User user;
    private final boolean isKeytab;
    private final boolean isKrbTkt;
    private static final String OS_LOGIN_MODULE_NAME;
    private static final Class<? extends Principal> OS_PRINCIPAL_CLASS;
    private static final boolean windows;

    private static synchronized void ensureInitialized() {
        if (!isInitialized) {
            UserGroupInformation.initialize(new Configuration(), KerberosName.hasRulesBeenSet());
        }
    }

    private static synchronized void initialize(Configuration conf, boolean skipRulesSetting) {
        String value = conf.get("hadoop.security.authentication");
        if (value == null || "simple".equals(value)) {
            useKerberos = false;
        } else if ("kerberos".equals(value)) {
            useKerberos = true;
        } else {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + value);
        }
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        javax.security.auth.login.Configuration existingConfig = null;
        try {
            existingConfig = javax.security.auth.login.Configuration.getConfiguration();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (existingConfig instanceof HadoopConfiguration) {
            LOG.info((Object)"JAAS Configuration already set up for Hadoop, not re-installing.");
        } else {
            javax.security.auth.login.Configuration.setConfiguration(new HadoopConfiguration(existingConfig));
        }
        isInitialized = true;
        UserGroupInformation.conf = conf;
        try {
            if (!skipRulesSetting) {
                KerberosName.setConfiguration(conf);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem with Kerberos auth_to_local name configuration", ioe);
        }
    }

    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf, false);
    }

    public static boolean isSecurityEnabled() {
        UserGroupInformation.ensureInitialized();
        return useKerberos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoginContext newLoginContext(String appName, Subject subject) throws LoginException {
        Thread t = Thread.currentThread();
        ClassLoader oldCCL = t.getContextClassLoader();
        t.setContextClassLoader(HadoopLoginModule.class.getClassLoader());
        try {
            LoginContext loginContext = new LoginContext(appName, subject, null, new HadoopConfiguration(null));
            return loginContext;
        }
        finally {
            t.setContextClassLoader(oldCCL);
        }
    }

    private LoginContext getLogin() {
        return this.user.getLogin();
    }

    private void setLogin(LoginContext login) {
        this.user.setLogin(login);
    }

    UserGroupInformation(Subject subject) {
        this.subject = subject;
        this.user = subject.getPrincipals(User.class).iterator().next();
        this.isKeytab = !subject.getPrivateCredentials(KerberosKey.class).isEmpty();
        this.isKrbTkt = !subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
    }

    public boolean hasKerberosCredentials() {
        return this.isKeytab || this.isKrbTkt;
    }

    public static UserGroupInformation getCurrentUser() throws IOException {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(User.class).isEmpty()) {
            return UserGroupInformation.getLoginUser();
        }
        return new UserGroupInformation(subject);
    }

    public static synchronized UserGroupInformation getLoginUser() throws IOException {
        if (loginUser == null) {
            try {
                Subject subject = new Subject();
                LoginContext login = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.newLoginContext("hadoop-user-kerberos", subject) : UserGroupInformation.newLoginContext("hadoop-simple", subject);
                login.login();
                loginUser = new UserGroupInformation(subject);
                loginUser.setLogin(login);
                loginUser.setAuthenticationMethod(UserGroupInformation.isSecurityEnabled() ? AuthenticationMethod.KERBEROS : AuthenticationMethod.SIMPLE);
                loginUser = new UserGroupInformation(login.getSubject());
                String fileLocation = System.getenv(HADOOP_TOKEN_FILE_LOCATION);
                if (fileLocation != null && UserGroupInformation.isSecurityEnabled()) {
                    Credentials cred = Credentials.readTokenStorageFile(new Path("file:///" + fileLocation), conf);
                    for (Token<? extends TokenIdentifier> token : cred.getAllTokens()) {
                        loginUser.addToken(token);
                    }
                }
                loginUser.spawnAutoRenewalThreadForUserCreds();
            }
            catch (LoginException le) {
                throw new IOException("failure to login", le);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("UGI loginUser:" + loginUser));
            }
        }
        return loginUser;
    }

    public boolean isFromKeytab() {
        return this.isKeytab;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found tgt " + ticket));
            }
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    private void spawnAutoRenewalThreadForUserCreds() {
        if (UserGroupInformation.isSecurityEnabled() && this.user.getAuthenticationMethod() == AuthenticationMethod.KERBEROS && !this.isKeytab) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    String cmd = conf.get("hadoop.kerberos.kinit.command", "kinit");
                    KerberosTicket tgt = UserGroupInformation.this.getTGT();
                    if (tgt == null) {
                        return;
                    }
                    long nextRefresh = UserGroupInformation.this.getRefreshTime(tgt);
                    try {
                        while (true) {
                            long now = System.currentTimeMillis();
                            LOG.debug((Object)("Current time is " + now));
                            LOG.debug((Object)("Next refresh is " + nextRefresh));
                            if (now < nextRefresh) {
                                Thread.sleep(nextRefresh - now);
                            }
                            Shell.execCommand(cmd, "-R");
                            LOG.debug((Object)"renewed ticket");
                            UserGroupInformation.this.reloginFromTicketCache();
                            tgt = UserGroupInformation.this.getTGT();
                            if (tgt == null) {
                                LOG.warn((Object)("No TGT after renewal. Aborting renew thread for " + UserGroupInformation.this.getUserName()));
                            }
                            nextRefresh = Math.max(UserGroupInformation.this.getRefreshTime(tgt), now + 600000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)"Terminating renewal thread");
                        return;
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)"Exception encountered while running the renewal command. Aborting renew thread", (Throwable)ie);
                        return;
                    }
                }
            });
            t.setDaemon(true);
            t.setName("TGT Renewer for " + this.getUserName());
            t.start();
        }
    }

    public static synchronized void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        keytabFile = path;
        keytabPrincipal = user;
        Subject subject = new Subject();
        long start = 0L;
        try {
            LoginContext login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", subject);
            start = System.currentTimeMillis();
            login.login();
            UserGroupInformation.metrics.loginSuccess.inc(System.currentTimeMillis() - start);
            loginUser = new UserGroupInformation(subject);
            loginUser.setLogin(login);
            loginUser.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.inc(System.currentTimeMillis() - start);
            }
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
        LOG.info((Object)("Login successful for user " + keytabPrincipal + " using keytab file " + keytabFile));
    }

    public synchronized void reloginFromTicketCache() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKrbTkt) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new IOException("login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        try {
            LOG.info((Object)("Initiating logout for " + this.getUserName()));
            login.logout();
            login = UserGroupInformation.newLoginContext("hadoop-user-kerberos", this.getSubject());
            LOG.info((Object)("Initiating re-login for " + this.getUserName()));
            login.login();
            this.setLogin(login);
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + this.getUserName(), le);
        }
    }

    public static synchronized UserGroupInformation loginUserFromKeytabAndReturnUGI(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        String oldKeytabFile = null;
        String oldKeytabPrincipal = null;
        long start = 0L;
        try {
            oldKeytabFile = keytabFile;
            oldKeytabPrincipal = keytabPrincipal;
            keytabFile = path;
            keytabPrincipal = user;
            Subject subject = new Subject();
            LoginContext login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", subject);
            start = System.currentTimeMillis();
            login.login();
            UserGroupInformation.metrics.loginSuccess.inc(System.currentTimeMillis() - start);
            UserGroupInformation newLoginUser = new UserGroupInformation(subject);
            newLoginUser.setLogin(login);
            newLoginUser.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            UserGroupInformation userGroupInformation = newLoginUser;
            return userGroupInformation;
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.inc(System.currentTimeMillis() - start);
            }
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
        finally {
            if (oldKeytabFile != null) {
                keytabFile = oldKeytabFile;
            }
            if (oldKeytabPrincipal != null) {
                keytabPrincipal = oldKeytabPrincipal;
            }
        }
    }

    public synchronized void checkTGTAndReloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null && System.currentTimeMillis() < this.getRefreshTime(tgt)) {
            return;
        }
        this.reloginFromKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null || keytabFile == null) {
            throw new IOException("loginUserFromKeyTab must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        long start = 0L;
        try {
            LOG.info((Object)("Initiating logout for " + this.getUserName()));
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            synchronized (UserGroupInformation.class) {
                login.logout();
                login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", this.getSubject());
                LOG.info((Object)("Initiating re-login for " + keytabPrincipal));
                start = System.currentTimeMillis();
                login.login();
                UserGroupInformation.metrics.loginSuccess.inc(System.currentTimeMillis() - start);
                this.setLogin(login);
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.inc(System.currentTimeMillis() - start);
            }
            throw new IOException("Login failure for " + keytabPrincipal + " from keytab " + keytabFile, le);
        }
        {
            return;
        }
    }

    private boolean hasSufficientTimeElapsed() {
        long now = System.currentTimeMillis();
        if (now - this.user.getLastLogin() < 600000L) {
            LOG.warn((Object)"Not attempting to re-login since the last re-login was attempted less than 600 seconds before.");
            return false;
        }
        this.user.setLastLogin(now);
        return true;
    }

    public static synchronized boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.getLoginUser().isKeytab;
    }

    public static UserGroupInformation createRemoteUser(String user) {
        if (user == null || "".equals(user)) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(AuthenticationMethod.SIMPLE);
        return result;
    }

    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || "".equals(user)) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new User(user));
        principals.add(new RealUser(realUser));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(AuthenticationMethod.PROXY);
        return result;
    }

    public UserGroupInformation getRealUser() {
        Iterator<RealUser> i$ = this.subject.getPrincipals(RealUser.class).iterator();
        if (i$.hasNext()) {
            RealUser p = i$.next();
            return p.getRealUser();
        }
        return null;
    }

    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups();
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups();
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        Iterator<User> i$ = this.subject.getPrincipals(User.class).iterator();
        if (i$.hasNext()) {
            User p = i$.next();
            return p.getShortName();
        }
        return null;
    }

    public String getUserName() {
        return this.user.getName();
    }

    public synchronized boolean addTokenIdentifier(TokenIdentifier tokenId) {
        return this.subject.getPublicCredentials().add(tokenId);
    }

    public synchronized Set<TokenIdentifier> getTokenIdentifiers() {
        return this.subject.getPublicCredentials(TokenIdentifier.class);
    }

    public synchronized boolean addToken(Token<? extends TokenIdentifier> token) {
        return this.subject.getPrivateCredentials().add(token);
    }

    public synchronized Collection<Token<? extends TokenIdentifier>> getTokens() {
        Set<Object> creds = this.subject.getPrivateCredentials();
        ArrayList<Token> result = new ArrayList<Token>(creds.size());
        for (Object o : creds) {
            if (!(o instanceof Token)) continue;
            result.add((Token)o);
        }
        return Collections.unmodifiableList(result);
    }

    public synchronized String[] getGroupNames() {
        UserGroupInformation.ensureInitialized();
        try {
            List<String> result = groups.getGroups(this.getShortUserName());
            return result.toArray(new String[result.size()]);
        }
        catch (IOException ie) {
            LOG.warn((Object)("No groups available for user " + this.getShortUserName()));
            return new String[0];
        }
    }

    public String toString() {
        String me = this.getRealUser() != null ? this.getUserName() + " via " + this.getRealUser().toString() : this.getUserName();
        return me + " (auth:" + (Object)((Object)this.getAuthenticationMethod()) + ")";
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        this.user.setAuthenticationMethod(authMethod);
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        return this.user.getAuthenticationMethod();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject == ((UserGroupInformation)o).subject;
    }

    public int hashCode() {
        return System.identityHashCode(this.subject);
    }

    protected Subject getSubject() {
        return this.subject;
    }

    public <T> T doAs(PrivilegedAction<T> action) {
        this.logPriviledgedAction(this.subject, action);
        return Subject.doAs(this.subject, action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            this.logPriviledgedAction(this.subject, action);
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            LOG.error((Object)("PriviledgedActionException as:" + this + " cause:" + cause));
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(pae, "Unknown exception in doAs");
        }
    }

    private void logPriviledgedAction(Subject subject, Object action) {
        if (LOG.isDebugEnabled()) {
            String where = new Throwable().getStackTrace()[2].toString();
            LOG.debug((Object)("PriviledgedAction as:" + this + " from:" + where));
        }
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("Auth method " + (Object)((Object)ugi.user.getAuthenticationMethod()));
        System.out.println("Keytab " + ugi.isKeytab);
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
            System.out.println("Auth method " + (Object)((Object)UserGroupInformation.loginUser.user.getAuthenticationMethod()));
            System.out.println("Keytab " + UserGroupInformation.loginUser.isKeytab);
        }
    }

    static {
        loginUser = null;
        keytabPrincipal = null;
        keytabFile = null;
        windows = System.getProperty("os.name").startsWith("Windows");
        if (windows) {
            OS_LOGIN_MODULE_NAME = "com.sun.security.auth.module.NTLoginModule";
            OS_PRINCIPAL_CLASS = NTUserPrincipal.class;
        } else {
            OS_LOGIN_MODULE_NAME = "com.sun.security.auth.module.UnixLoginModule";
            OS_PRINCIPAL_CLASS = UnixPrincipal.class;
        }
    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();

        private TestingGroups() {
            super(new Configuration());
        }

        @Override
        public List<String> getGroups(String user) {
            List<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = new ArrayList<String>();
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    public static enum AuthenticationMethod {
        SIMPLE,
        KERBEROS,
        TOKEN,
        CERTIFICATE,
        KERBEROS_SSL,
        PROXY;

    }

    private static class HadoopConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SIMPLE_CONFIG_NAME = "hadoop-simple";
        private static final String USER_KERBEROS_CONFIG_NAME = "hadoop-user-kerberos";
        private static final String KEYTAB_KERBEROS_CONFIG_NAME = "hadoop-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final AppConfigurationEntry OS_SPECIFIC_LOGIN;
        private static final AppConfigurationEntry HADOOP_LOGIN;
        private static final Map<String, String> USER_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] SIMPLE_CONF;
        private static final AppConfigurationEntry[] USER_KERBEROS_CONF;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private final javax.security.auth.login.Configuration parent;

        HadoopConfiguration(javax.security.auth.login.Configuration parent) {
            this.parent = parent;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (SIMPLE_CONFIG_NAME.equals(appName)) {
                return SIMPLE_CONF;
            }
            if (USER_KERBEROS_CONFIG_NAME.equals(appName)) {
                return USER_KERBEROS_CONF;
            }
            if (KEYTAB_KERBEROS_CONFIG_NAME.equals(appName)) {
                KEYTAB_KERBEROS_OPTIONS.put("keyTab", keytabFile);
                KEYTAB_KERBEROS_OPTIONS.put("principal", keytabPrincipal);
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.parent != null) {
                return this.parent.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HADOOP_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            OS_SPECIFIC_LOGIN = new AppConfigurationEntry(OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
            HADOOP_LOGIN = new AppConfigurationEntry(HadoopLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
            USER_KERBEROS_OPTIONS = new HashMap<String, String>();
            USER_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            USER_KERBEROS_OPTIONS.put("useTicketCache", "true");
            USER_KERBEROS_OPTIONS.put("renewTGT", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                USER_KERBEROS_OPTIONS.put("ticketCache", ticketCache);
            }
            USER_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            USER_KERBEROS_LOGIN = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, USER_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            SIMPLE_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, HADOOP_LOGIN};
            USER_KERBEROS_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, USER_KERBEROS_LOGIN, HADOOP_LOGIN};
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN, HADOOP_LOGIN};
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }

    public static class HadoopLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        private <T extends Principal> T getCanonicalUser(Class<T> cls) {
            Iterator<T> i$ = this.subject.getPrincipals(cls).iterator();
            if (i$.hasNext()) {
                Principal user = (Principal)i$.next();
                return (T)user;
            }
            return null;
        }

        @Override
        public boolean commit() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"hadoop login commit");
            }
            if (!this.subject.getPrincipals(User.class).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("using existing subject:" + this.subject.getPrincipals()));
                }
                return true;
            }
            Principal user = null;
            if (useKerberos) {
                user = this.getCanonicalUser(KerberosPrincipal.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("using kerberos user:" + user));
                }
            }
            if (!UserGroupInformation.isSecurityEnabled() && user == null) {
                String envUser = System.getenv(UserGroupInformation.HADOOP_USER_NAME);
                if (envUser == null) {
                    envUser = System.getProperty(UserGroupInformation.HADOOP_USER_NAME);
                }
                Principal principal = user = envUser == null ? null : new User(envUser);
            }
            if (user == null) {
                user = this.getCanonicalUser(OS_PRINCIPAL_CLASS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("using local user:" + user));
                }
            }
            if (user != null) {
                this.subject.getPrincipals().add(new User(user.getName()));
                return true;
            }
            LOG.error((Object)("Can't find user in " + this.subject));
            throw new LoginException("Can't find user name");
        }

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"hadoop login");
            }
            return true;
        }

        @Override
        public boolean logout() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"hadoop logout");
            }
            return true;
        }
    }

    static class UgiMetrics
    implements Updater {
        final MetricsTimeVaryingRate loginSuccess;
        final MetricsTimeVaryingRate loginFailure;
        private final MetricsRecord metricsRecord;
        private final MetricsRegistry registry = new MetricsRegistry();

        UgiMetrics() {
            this.loginSuccess = new MetricsTimeVaryingRate("loginSuccess", this.registry, "Rate of successful kerberos logins and time taken in milliseconds");
            this.loginFailure = new MetricsTimeVaryingRate("loginFailure", this.registry, "Rate of failed kerberos logins and time taken in milliseconds");
            MetricsContext metricsContext = MetricsUtil.getContext("ugi");
            this.metricsRecord = MetricsUtil.createRecord(metricsContext, "ugi");
            metricsContext.registerUpdater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doUpdates(MetricsContext context) {
            UgiMetrics ugiMetrics = this;
            synchronized (ugiMetrics) {
                for (MetricsBase m : this.registry.getMetricsList()) {
                    m.pushMetric(this.metricsRecord);
                }
            }
            this.metricsRecord.update();
        }
    }
}

