/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String CONFIG_PREFIX = "config.prefix";
    public static final String AUTH_TYPE = "type";
    public static final String SIGNATURE_SECRET = "signature.secret";
    public static final String AUTH_TOKEN_VALIDITY = "token.validity";
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_PATH = "cookie.path";
    private static final Random RAN = new Random();
    private Signer signer;
    private AuthenticationHandler authHandler;
    private boolean randomSecret;
    private long validity;
    private String cookieDomain;
    private String cookiePath;

    public void init(FilterConfig filterConfig) throws ServletException {
        String configPrefix = filterConfig.getInitParameter(CONFIG_PREFIX);
        configPrefix = configPrefix != null ? configPrefix + "." : "";
        Properties config = this.getConfiguration(configPrefix, filterConfig);
        String authHandlerName = config.getProperty(AUTH_TYPE, null);
        if (authHandlerName == null) {
            throw new ServletException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authHandlerClassName = authHandlerName.equals("simple") ? PseudoAuthenticationHandler.class.getName() : (authHandlerName.equals("kerberos") ? KerberosAuthenticationHandler.class.getName() : authHandlerName);
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(authHandlerClassName);
            this.authHandler = (AuthenticationHandler)klass.newInstance();
            this.authHandler.init(config);
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
        String signatureSecret = config.getProperty(configPrefix + SIGNATURE_SECRET);
        if (signatureSecret == null) {
            signatureSecret = Long.toString(RAN.nextLong());
            this.randomSecret = true;
            LOG.warn("'signature.secret' configuration not set, using a random value as secret");
        }
        this.signer = new Signer(signatureSecret.getBytes());
        this.validity = Long.parseLong(config.getProperty(AUTH_TOKEN_VALIDITY, "36000")) * 1000L;
        this.cookieDomain = config.getProperty(COOKIE_DOMAIN, null);
        this.cookiePath = config.getProperty(COOKIE_PATH, null);
    }

    protected AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    protected boolean isRandomSecret() {
        return this.randomSecret;
    }

    protected long getValidity() {
        return this.validity / 1000L;
    }

    protected String getCookieDomain() {
        return this.cookieDomain;
    }

    protected String getCookiePath() {
        return this.cookiePath;
    }

    public void destroy() {
        if (this.authHandler != null) {
            this.authHandler.destroy();
            this.authHandler = null;
        }
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    protected String getRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    protected AuthenticationToken getToken(HttpServletRequest request) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("hadoop.auth")) continue;
                tokenStr = cookie.getValue();
                try {
                    tokenStr = this.signer.verifyAndExtract(tokenStr);
                    break;
                }
                catch (SignerException ex) {
                    throw new AuthenticationException(ex);
                }
            }
        }
        if (tokenStr != null) {
            token = AuthenticationToken.parse(tokenStr);
            if (!token.getType().equals(this.authHandler.getType())) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
        }
        return token;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
            }
            catch (AuthenticationException ex) {
                LOG.warn("AuthenticationToken ignored: " + ex.getMessage());
                token = null;
            }
            if (token == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [{}] triggering authentication", (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                }
                if ((token = this.authHandler.authenticate((HttpServletRequest)httpRequest, httpResponse)) != null && token != AuthenticationToken.ANONYMOUS) {
                    token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                }
                newToken = true;
            }
            if (token != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                }
                final AuthenticationToken authToken = token;
                httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                    public String getAuthType() {
                        return authToken.getType();
                    }

                    public String getRemoteUser() {
                        return authToken.getUserName();
                    }

                    public Principal getUserPrincipal() {
                        return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                    }
                };
                if (newToken && token != AuthenticationToken.ANONYMOUS) {
                    String signedToken = this.signer.sign(token.toString());
                    Cookie cookie = this.createCookie(signedToken);
                    httpResponse.addCookie(cookie);
                }
            } else {
                throw new AuthenticationException("Missing AuthenticationToken");
            }
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (AuthenticationException ex) {
            if (!httpResponse.isCommitted()) {
                Cookie cookie = this.createCookie("");
                cookie.setMaxAge(0);
                httpResponse.addCookie(cookie);
                httpResponse.sendError(401, ex.getMessage());
            }
            LOG.warn("Authentication exception: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected Cookie createCookie(String token) {
        Cookie cookie = new Cookie("hadoop.auth", token);
        if (this.getCookieDomain() != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        if (this.getCookiePath() != null) {
            cookie.setPath(this.getCookiePath());
        }
        return cookie;
    }
}

