/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.lang.reflect.Method;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;

public abstract class SampledEhcacheMBeans {
    public static final String SAMPLED_CACHE_MANAGER_TYPE = "SampledCacheManager";
    public static final String SAMPLED_CACHE_TYPE = "SampledCache";
    public static final String GROUP_ID = "net.sf.ehcache";

    public static ObjectName getCacheManagerObjectName(ClusteredInstanceFactory clusteredInstanceFactory, String cacheManagerName) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("net.sf.ehcache:type=SampledCacheManager,name=" + cacheManagerName + SampledEhcacheMBeans.getBeanNameSuffix(clusteredInstanceFactory));
        return objectName;
    }

    private static String getBeanNameSuffix(ClusteredInstanceFactory clusteredInstanceFactory) {
        String uuid;
        String suffix = "";
        if (clusteredInstanceFactory != null && (uuid = SampledEhcacheMBeans.getClientUUID(clusteredInstanceFactory)) != null) {
            suffix = ",node=" + uuid;
        }
        return suffix;
    }

    private static String getClientUUID(ClusteredInstanceFactory clusteredInstanceFactory) {
        try {
            Class<?> c = clusteredInstanceFactory.getClass();
            Method m = c.getMethod("getUUID", new Class[0]);
            if (m == null) {
                return null;
            }
            return (String)m.invoke((Object)clusteredInstanceFactory, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ObjectName getCacheObjectName(ClusteredInstanceFactory clusteredInstanceFactory, String cacheManagerName, String cacheName) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("net.sf.ehcache:type=SampledCache,SampledCacheManager=" + cacheManagerName + ",name=" + cacheName + SampledEhcacheMBeans.getBeanNameSuffix(clusteredInstanceFactory));
        return objectName;
    }

    public static ObjectName getQueryCacheManagerObjectName(ClusteredInstanceFactory clusteredInstanceFactory, String cacheManagerName) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("net.sf.ehcache:*,SampledCacheManager=" + cacheManagerName + SampledEhcacheMBeans.getBeanNameSuffix(clusteredInstanceFactory));
        return objectName;
    }

    public static ObjectName getQueryCacheManagersObjectName(ClusteredInstanceFactory clusteredInstanceFactory) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName("net.sf.ehcache:type=SampledCacheManager,*" + SampledEhcacheMBeans.getBeanNameSuffix(clusteredInstanceFactory));
        return objectName;
    }
}

