/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.client;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.beans.Connection;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionServiceClient
implements IConnectionService,
ObjectSupplier {
    protected static final Log logger = LogFactory.getLog(ConnectionServiceClient.class);
    private String serviceUrl;
    private String userId;
    private String password;
    private HttpClient httpClientInstance = null;

    private HttpClient getClient() {
        if (this.httpClientInstance == null) {
            this.httpClientInstance = new HttpClient();
            if (this.userId != null && this.userId.length() > 0 && this.password != null && this.password.length() > 0) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.userId, this.password);
                this.httpClientInstance.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
                this.httpClientInstance.getParams().setAuthenticationPreemptive(true);
            }
        }
        return this.httpClientInstance;
    }

    @Override
    public boolean addConnection(IConnection connection) throws ConnectionServiceException {
        String xml = this.getConnectionXml(connection);
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/addConnection");
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        Node node = this.getResultNode((HttpMethod)callMethod);
        return node != null && Boolean.parseBoolean(this.getNodeText(node));
    }

    public DatabaseConnection convertFromConnection(IConnection connection) throws ConnectionServiceException {
        String xml = this.getConnectionXml(connection);
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/convertFromConnection");
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        Document doc = this.getResultDocument((HttpMethod)callMethod);
        try {
            return this.getResponseDatabaseConnection(doc.getRootElement());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
    }

    public Document serializeDatabaseConnection(DatabaseConnection databaseConnection) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("databaseConnection", DatabaseConnection.class);
        xstream.alias("accessType", DatabaseAccessType.class);
        String xml = xstream.toXML((Object)databaseConnection);
        System.out.println(xml);
        return null;
    }

    protected Connection getResponseConnection(Element rootNode) throws XMLStreamException, AxisFault {
        return (Connection)this.getResponseObject(Connection.class, rootNode);
    }

    protected DatabaseConnection getResponseDatabaseConnection(Element rootNode) throws XMLStreamException, AxisFault {
        DatabaseConnection result = (DatabaseConnection)this.getResponseObject(DatabaseConnection.class, rootNode);
        String accessTypeValue = result.getAccessTypeValue();
        DatabaseAccessType accessType = result.getAccessType();
        if (accessType == null || !accessType.getValue().equals(accessTypeValue)) {
            result.setAccessType(DatabaseAccessType.valueOf((String)accessTypeValue));
        }
        return result;
    }

    protected Object getResponseObject(Class clazz, Element rootNode) throws XMLStreamException, AxisFault {
        Object[] results = this.getResponseObjects(new Object[]{clazz}, rootNode);
        if (results == null || results.length == 0) {
            return null;
        }
        return results[0];
    }

    protected Object[] getResponseArray(Class clazz, Element rootNode) throws XMLStreamException, AxisFault {
        List nodes = rootNode.selectNodes("*/*/*");
        int count = nodes.size();
        Object[] types = new Object[count];
        for (int idx = 0; idx < count; ++idx) {
            types[idx] = clazz;
        }
        return this.getResponseObjects(types, rootNode);
    }

    protected Object[] getResponseObjects(Object[] types, Element rootNode) throws XMLStreamException, AxisFault {
        ByteArrayInputStream in = new ByteArrayInputStream(rootNode.asXML().getBytes());
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement omElement = builder.getDocumentElement();
        OMElement bodyElement = omElement.getFirstElement();
        OMElement responseElement = bodyElement.getFirstElement();
        return BeanUtil.deserialize((OMElement)responseElement, (Object[])types, (ObjectSupplier)this);
    }

    public DatabaseConnection deserializeDatabaseConnection(Element rootNode) throws XMLStreamException, AxisFault {
        System.out.println(rootNode.asXML());
        ByteArrayInputStream in = new ByteArrayInputStream(rootNode.asXML().getBytes());
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement omElement = builder.getDocumentElement();
        OMElement bodyElement = omElement.getFirstElement();
        OMElement responseElement = bodyElement.getFirstElement();
        Object[] types = new Object[]{DatabaseConnection.class};
        Object[] results = BeanUtil.deserialize((OMElement)responseElement, (Object[])types, (ObjectSupplier)this);
        if (results == null || results.length == 0) {
            return null;
        }
        return (DatabaseConnection)results[0];
    }

    @Override
    public IConnection convertToConnection(IDatabaseConnection arg0) throws ConnectionServiceException {
        return null;
    }

    @Override
    public boolean deleteConnection(IConnection connection) throws ConnectionServiceException {
        return this.deleteConnection(connection.getName());
    }

    @Override
    public boolean deleteConnection(String connectionName) throws ConnectionServiceException {
        GetMethod callMethod = new GetMethod(this.serviceUrl + "/deleteConnectionByName");
        callMethod.setQueryString("name=" + connectionName);
        Node node = this.getResultNode((HttpMethod)callMethod);
        return node != null && Boolean.parseBoolean(this.getNodeText(node));
    }

    @Override
    public IConnection getConnectionByName(String connectionName) throws ConnectionServiceException {
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/getConnectionByName");
        String xml = this.getRequestXml(new Parameter("name", connectionName));
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        Document resultDoc = this.getResultDocument((HttpMethod)callMethod);
        try {
            return this.getResponseConnection(resultDoc.getRootElement());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
    }

    protected String getRequestXml(Parameter ... params) {
        Document doc = DocumentHelper.createDocument();
        Element envelopeNode = DocumentHelper.createElement((String)"soapenv:Envelope");
        envelopeNode.addAttribute("xmlns:soapenv", "http://www.w3.org/2003/05/soap-envelope");
        envelopeNode.addAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");
        envelopeNode.addAttribute("xmlns:pho", "http://impl.service.wizard.datasource.dataaccess.platform.pentaho.org");
        doc.add(envelopeNode);
        Element bodyNode = DocumentHelper.createElement((String)"soapenv:Body");
        envelopeNode.add(bodyNode);
        if (params == null || params.length == 0) {
            return doc.asXML();
        }
        Element parametersNode = DocumentHelper.createElement((String)"pho:parameters");
        bodyNode.add(parametersNode);
        for (Parameter param : params) {
            Element nameNode = DocumentHelper.createElement((String)("pho:" + param.getName()));
            parametersNode.add(nameNode);
            nameNode.setText(param.getValue().toString());
            nameNode.addAttribute("type", param.getValue().getClass().getCanonicalName());
        }
        return doc.asXML();
    }

    @Override
    public List<IConnection> getConnections() throws ConnectionServiceException {
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/getConnections");
        String xml = this.getRequestXml(new Parameter[0]);
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        Document resultDoc = this.getResultDocument((HttpMethod)callMethod);
        try {
            Object[] connectionArray;
            for (Object connection : connectionArray = this.getResponseArray(Connection.class, resultDoc.getRootElement())) {
                connections.add((Connection)connection);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConnectionServiceException(e);
        }
        return connections;
    }

    protected String getNodeText(Node node) {
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    protected String getConnectionXml(IConnection connection) {
        Document doc = DocumentHelper.createDocument();
        Element envelopeNode = DocumentHelper.createElement((String)"soapenv:Envelope");
        envelopeNode.addAttribute("xmlns:soapenv", "http://www.w3.org/2003/05/soap-envelope");
        envelopeNode.addAttribute("xmlns:wsa", "http://www.w3.org/2005/08/addressing");
        envelopeNode.addAttribute("xmlns:pho", "http://impl.service.wizard.datasource.dataaccess.platform.pentaho.org");
        doc.add(envelopeNode);
        Element bodyNode = DocumentHelper.createElement((String)"soapenv:Body");
        envelopeNode.add(bodyNode);
        Element parameterNode = DocumentHelper.createElement((String)"pho:connection");
        bodyNode.add(parameterNode);
        Element connectionNode = DocumentHelper.createElement((String)"pho:Connection");
        connectionNode.addAttribute("type", "org.pentaho.platform.dataaccess.datasource.beans.Connection");
        parameterNode.add(connectionNode);
        Element node = DocumentHelper.createElement((String)"driverClass");
        node.setText(connection.getDriverClass());
        connectionNode.add(node);
        node = DocumentHelper.createElement((String)"name");
        node.setText(connection.getName());
        connectionNode.add(node);
        node = DocumentHelper.createElement((String)"password");
        node.setText(connection.getPassword());
        connectionNode.add(node);
        node = DocumentHelper.createElement((String)"url");
        node.setText(connection.getUrl());
        connectionNode.add(node);
        node = DocumentHelper.createElement((String)"username");
        node.setText(connection.getUsername());
        connectionNode.add(node);
        return doc.asXML();
    }

    @Override
    public boolean testConnection(IConnection connection) throws ConnectionServiceException {
        String xml = this.getConnectionXml(connection);
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/testConnection");
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        Node node = this.getResultNode((HttpMethod)callMethod);
        return node != null && Boolean.parseBoolean(this.getNodeText(node));
    }

    @Override
    public boolean updateConnection(IConnection connection) throws ConnectionServiceException {
        String xml = this.getConnectionXml(connection);
        PostMethod callMethod = new PostMethod(this.serviceUrl + "/updateConnection");
        StringRequestEntity requestEntity = new StringRequestEntity(xml);
        callMethod.setRequestEntity((RequestEntity)requestEntity);
        Node node = this.getResultNode((HttpMethod)callMethod);
        return node != null && Boolean.parseBoolean(this.getNodeText(node));
    }

    public void setHost(String host) {
        this.serviceUrl = host + "/content/ws-run/soapConnectionService";
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected List getResultNodes(HttpMethod callMethod) throws ConnectionServiceException {
        Document doc = this.getResultDocument(callMethod);
        return doc.selectNodes("//return");
    }

    protected Node getResultNode(HttpMethod callMethod) throws ConnectionServiceException {
        Document doc = this.getResultDocument(callMethod);
        return doc.selectSingleNode("//return");
    }

    protected Document getResultDocument(HttpMethod callMethod) throws ConnectionServiceException {
        try {
            HttpClient client = this.getClient();
            int status = client.executeMethod(callMethod);
            if (status != 200) {
                throw new ConnectionServiceException("Web service call failed with code " + status);
            }
            InputStream in = callMethod.getResponseBodyAsStream();
            byte[] buffer = new byte[2048];
            int n = in.read(buffer);
            StringBuilder sb = new StringBuilder();
            while (n != -1) {
                sb.append(new String(buffer, 0, n));
                n = in.read(buffer);
            }
            String result = sb.toString();
            return DocumentHelper.parseText((String)result);
        }
        catch (IOException e) {
            throw new ConnectionServiceException(e);
        }
        catch (DocumentException e) {
            throw new ConnectionServiceException(e);
        }
    }

    public Object getObject(Class clazz) throws AxisFault {
        try {
            System.out.println(clazz.getCanonicalName());
            Constructor<?>[] cons = clazz.getConstructors();
            if (cons.length > 0) {
                return clazz.newInstance();
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new AxisFault(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AxisFault(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private class Parameter {
        public String name;
        public Object value;

        public Parameter(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

