/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.selectdialog;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.Collections;
import java.util.List;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.modeler.ModelerDialog;
import org.pentaho.platform.dataaccess.datasource.ui.selectdialog.DatasourceSelectionDialogModel;
import org.pentaho.platform.dataaccess.datasource.wizard.EmbeddedWizard;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceService;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceSelectionDialogController
extends AbstractXulDialogController<LogicalModelSummary> {
    private BindingFactory bf;
    private IXulAsyncDatasourceService datasourceService;
    private DatasourceSelectionDialogModel datasourceSelectionDialogModel = new DatasourceSelectionDialogModel();
    private XulDialog datasourceSelectionDialog;
    private XulDialog removeDatasourceConfirmationDialog;
    private boolean administrator;
    private EmbeddedWizard datasourceEditor;
    private XulButton addDatasourceButton;
    private XulButton editDatasourceButton;
    private XulButton removeDatasourceButton;
    private XulListbox datasourceListbox;
    private Binding editDatasourceButtonBinding;
    private Binding removeDatasourceButtonBinding;
    private ModelerDialog modeler;
    private String context;

    public DatasourceSelectionDialogController(String context) {
        this.context = context;
    }

    @Bindable
    public void init() {
        this.internalInit();
        this.datasourceService.hasPermission(new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                DatasourceSelectionDialogController.this.showMessagebox("Error", error.getLocalizedMessage());
            }

            public void success(Boolean administrator) {
                DatasourceSelectionDialogController.this.administrator = administrator;
                DatasourceSelectionDialogController.this.addDatasourceButton.setVisible(administrator.booleanValue());
                DatasourceSelectionDialogController.this.editDatasourceButton.setVisible(administrator.booleanValue());
                DatasourceSelectionDialogController.this.removeDatasourceButton.setVisible(administrator.booleanValue());
                try {
                    DatasourceSelectionDialogController.this.removeDatasourceButtonBinding.fireSourceChanged();
                    DatasourceSelectionDialogController.this.editDatasourceButtonBinding.fireSourceChanged();
                }
                catch (Exception e) {
                    DatasourceSelectionDialogController.this.showMessagebox("Error", e.getLocalizedMessage());
                }
            }
        });
    }

    public void reset() {
        if (this.datasourceListbox != null && this.datasourceListbox.getChildNodes().size() > 0) {
            this.datasourceListbox.setSelectedIndex(0);
        }
    }

    private void internalInit() {
        try {
            this.datasourceListbox = (XulListbox)this.safeGetElementById(this.document, "datasourceListbox");
            this.datasourceSelectionDialog = (XulDialog)this.safeGetElementById(this.document, "datasourceSelectionDialog");
            this.removeDatasourceConfirmationDialog = (XulDialog)this.safeGetElementById(this.document, "removeDatasourceConfirmationDialog");
            XulButton acceptButton = null;
            try {
                acceptButton = (XulButton)this.safeGetElementById(this.document, "datasourceSelectionDialog_accept");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.addDatasourceButton = (XulButton)this.safeGetElementById(this.document, "addDatasource");
            this.editDatasourceButton = (XulButton)this.safeGetElementById(this.document, "editDatasource");
            this.removeDatasourceButton = (XulButton)this.safeGetElementById(this.document, "removeDatasource");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "logicalModelSummaries", (Object)this.datasourceListbox, "elements", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.datasourceListbox, "selectedIndex", (Object)this.datasourceSelectionDialogModel, "selectedIndex", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            if (acceptButton != null) {
                BindingConvertor<Integer, Boolean> acceptButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                    public Boolean sourceToTarget(Integer value) {
                        return value > -1;
                    }

                    public Integer targetToSource(Boolean value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)acceptButton, "!disabled", new BindingConvertor[]{acceptButtonConvertor});
            }
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            BindingConvertor<Integer, Boolean> removeDatasourceButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                public Boolean sourceToTarget(Integer value) {
                    return value > -1 && DatasourceSelectionDialogController.this.administrator;
                }

                public Integer targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            this.removeDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)this.removeDatasourceButton, "!disabled", new BindingConvertor[]{removeDatasourceButtonConvertor});
            BindingConvertor<Integer, Boolean> editDatasourceButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                public Boolean sourceToTarget(Integer value) {
                    return value > -1 && DatasourceSelectionDialogController.this.administrator && DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.getLogicalModelSummaries().get(value).getModelId().equals("MODEL_1");
                }

                public Integer targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            this.editDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)this.editDatasourceButton, "!disabled", new BindingConvertor[]{editDatasourceButtonConvertor});
            this.datasourceListbox.setSelectedIndex(-1);
            this.datasourceSelectionDialogModel.setSelectedIndex(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessagebox("Error", e.getLocalizedMessage());
        }
    }

    private void showMessagebox(String title, String message) {
        XulMessageBox messagebox = null;
        try {
            messagebox = (XulMessageBox)this.document.createElement("messagebox");
        }
        catch (XulException e) {
            e.printStackTrace();
            return;
        }
        messagebox.setTitle(title);
        messagebox.setMessage(message);
        messagebox.open();
    }

    private XulComponent safeGetElementById(Document doc, String id) {
        XulComponent elem = doc.getElementById(id);
        if (elem != null) {
            return elem;
        }
        throw new NullPointerException("element with id \"" + id + "\" is null");
    }

    private void refreshDatasources(final String domainId, final String modelId) {
        this.datasourceService.getLogicalModels(this.context, new XulServiceCallback<List<LogicalModelSummary>>(){

            public void error(String message, Throwable error) {
                System.out.println(message);
            }

            public void success(List<LogicalModelSummary> logicalModelSummaries) {
                Collections.sort(logicalModelSummaries);
                DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedIndex(-1);
                DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setLogicalModelSummaries(logicalModelSummaries);
                if (domainId != null && modelId != null) {
                    DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedLogicalModel(domainId, modelId);
                    DatasourceSelectionDialogController.this.datasourceListbox.setSelectedIndex(DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.getSelectedIndex());
                } else {
                    DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedIndex(0);
                }
            }
        });
    }

    public String getName() {
        return "datasourceSelectionDialogController";
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setDatasourceService(IXulAsyncDatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    protected LogicalModelSummary getDialogResult() {
        int selectedIndex = this.datasourceSelectionDialogModel.getSelectedIndex();
        if (selectedIndex > -1) {
            return this.datasourceSelectionDialogModel.getLogicalModelSummaries().get(selectedIndex);
        }
        return null;
    }

    protected XulDialog getDialog() {
        return this.datasourceSelectionDialog;
    }

    public void setDatasourceDialogController(EmbeddedWizard gwtDatasourceEditor) {
        this.datasourceEditor = gwtDatasourceEditor;
    }

    private void enableWaitCursor(boolean enable) {
        if (enable) {
            DOM.setStyleAttribute((Element)RootPanel.get().getElement(), (String)"cursor", (String)"wait");
        } else {
            DOM.setStyleAttribute((Element)RootPanel.get().getElement(), (String)"cursor", (String)"default");
        }
    }

    @Bindable
    public void addDatasource() {
        this.enableWaitCursor(true);
        if (this.datasourceEditor.isInitialized()) {
            this.datasourceEditor.showDialog();
        } else {
            this.datasourceEditor.init(new AsyncConstructorListener<EmbeddedWizard>(){

                public void asyncConstructorDone(EmbeddedWizard dialog) {
                    DatasourceSelectionDialogController.this.enableWaitCursor(true);
                    DatasourceSelectionDialogController.this.datasourceEditor.addDialogListener(new DialogController.DialogListener<Domain>(){

                        public void onDialogAccept(Domain domain) {
                            DatasourceSelectionDialogController.this.refreshDatasources(domain.getId(), ((LogicalModel)domain.getLogicalModels().get(0)).getId());
                        }

                        public void onDialogCancel() {
                        }

                        public void onDialogReady() {
                            DatasourceSelectionDialogController.this.enableWaitCursor(false);
                        }
                    });
                    DatasourceSelectionDialogController.this.datasourceEditor.showDialog();
                }
            });
        }
    }

    @Bindable
    public void editDatasource() {
        if (this.datasourceEditor.isInitialized()) {
            this.showModeler();
        } else {
            this.datasourceEditor.init(new AsyncConstructorListener<EmbeddedWizard>(){

                public void asyncConstructorDone(EmbeddedWizard dialog) {
                    DatasourceSelectionDialogController.this.showModeler();
                }
            });
        }
    }

    private void showModeler() {
        this.modeler = ModelerDialog.getInstance(this.datasourceEditor, new AsyncConstructorListener<ModelerDialog>(){

            public void asyncConstructorDone(ModelerDialog dialog) {
                DialogController.DialogListener<Domain> listener = new DialogController.DialogListener<Domain>(){

                    public void onDialogCancel() {
                    }

                    public void onDialogAccept(Domain domain) {
                        DatasourceSelectionDialogController.this.refreshDatasources(domain.getId(), ((LogicalModel)domain.getLogicalModels().get(0)).getId());
                    }

                    public void onDialogReady() {
                        DatasourceSelectionDialogController.this.enableWaitCursor(false);
                    }
                };
                LogicalModelSummary logicalModelSummary = DatasourceSelectionDialogController.this.getDialogResult();
                dialog.addDialogListener(listener);
                dialog.showDialog(logicalModelSummary.getDomainId(), logicalModelSummary.getModelId());
            }
        });
    }

    @Bindable
    public void removeDatasourceConfirm() {
        this.removeDatasourceConfirmationDialog.show();
    }

    @Bindable
    public void removeDatasourceCancel() {
        this.removeDatasourceConfirmationDialog.hide();
    }

    @Bindable
    public void removeDatasourceAccept() {
        if (this.removeDatasourceButton.isDisabled()) {
            return;
        }
        this.removeDatasourceButton.setDisabled(true);
        LogicalModelSummary logicalModelSummary = this.getDialogResult();
        this.datasourceService.deleteLogicalModel(logicalModelSummary.getDomainId(), logicalModelSummary.getModelId(), new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                DatasourceSelectionDialogController.this.showMessagebox("Error", error.getLocalizedMessage());
                DatasourceSelectionDialogController.this.removeDatasourceButton.setDisabled(false);
            }

            public void success(Boolean retVal) {
                DatasourceSelectionDialogController.this.refreshDatasources(null, null);
                DatasourceSelectionDialogController.this.removeDatasourceConfirmationDialog.hide();
                DatasourceSelectionDialogController.this.removeDatasourceButton.setDisabled(false);
            }
        });
    }

    public void showDialog() {
        super.showDialog();
        this.refreshDatasources(null, null);
    }

    public void setContext(String context) {
        this.context = context;
    }
}

