/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.ConnectionDialogListener;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncConnectionService;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseConnectionService;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseDialectService;
import org.pentaho.ui.database.services.IXulAsyncDatabaseConnectionService;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ConnectionController
extends AbstractXulEventHandler
implements DatabaseDialogListener {
    private IXulAsyncConnectionService service;
    private List<ConnectionDialogListener> listeners = new ArrayList<ConnectionDialogListener>();
    private DatasourceModel datasourceModel;
    private XulDialog removeConfirmationDialog;
    private XulDialog saveConnectionConfirmationDialog;
    private XulDialog errorDialog;
    private XulDialog successDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    GwtXulAsyncDatabaseConnectionService connService = new GwtXulAsyncDatabaseConnectionService();
    GwtXulAsyncDatabaseDialectService dialectService = new GwtXulAsyncDatabaseDialectService();
    GwtDatabaseDialog databaseDialog;
    DatabaseTypeHelper databaseTypeHelper;
    IConnection currentConnection;

    @Bindable
    public void init() {
        XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List<IDatabaseType> retVal) {
                ConnectionController.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
            }
        };
        this.dialectService.getDatabaseTypes((XulServiceCallback)callback);
        this.saveConnectionConfirmationDialog = (XulDialog)this.document.getElementById("saveConnectionConfirmationDialog");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.removeConfirmationDialog = (XulDialog)this.document.getElementById("removeConfirmationDialog");
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    public void setDatasourceModel(DatasourceModel model) {
        this.datasourceModel = model;
    }

    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public String getName() {
        return "connectionController";
    }

    @Bindable
    public void closeDialog() {
        for (ConnectionDialogListener listener : this.listeners) {
            listener.onDialogCancel();
        }
    }

    @Bindable
    public void closeSaveConnectionConfirmationDialog() {
        this.saveConnectionConfirmationDialog.hide();
    }

    @Bindable
    public void addConnection() {
        try {
            this.service.testConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    ConnectionController.this.saveConnectionConfirmationDialog.show();
                }

                public void success(Boolean value) {
                    if (value.booleanValue()) {
                        ConnectionController.this.saveConnection();
                    } else {
                        ConnectionController.this.saveConnectionConfirmationDialog.show();
                    }
                }
            });
        }
        catch (Exception e) {
            this.saveConnectionConfirmationDialog.show();
        }
    }

    @Bindable
    public void testConnection() {
        try {
            this.service.testConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    ConnectionController.this.displayErrorMessage(error);
                }

                public void success(Boolean value) {
                    try {
                        if (value.booleanValue()) {
                            ConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_TEST_SUCCESS"));
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0003_CONNECTION_TEST_FAILED"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void deleteConnection() {
        this.removeConfirmationDialog.hide();
        this.service.deleteConnection(this.datasourceModel.getSelectedRelationalConnection().getName(), new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                ConnectionController.this.displayErrorMessage(error);
            }

            public void success(Boolean value) {
                try {
                    if (value.booleanValue()) {
                        ConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_DELETED"));
                        ConnectionController.this.datasourceModel.getGuiStateModel().deleteConnection(ConnectionController.this.datasourceModel.getSelectedRelationalConnection().getName());
                        List<IConnection> connections = ConnectionController.this.datasourceModel.getGuiStateModel().getConnections();
                        if (connections != null && connections.size() > 0) {
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(connections.get(connections.size() - 1));
                        } else {
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(null);
                        }
                    } else {
                        ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                    }
                }
                catch (Exception e) {
                    ConnectionController.this.displayErrorMessage(e);
                }
            }
        });
    }

    @Bindable
    public void saveConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.saveConnectionConfirmationDialog.hide();
        }
        if (!this.datasourceModel.isEditing()) {
            this.service.addConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    ConnectionController.this.displayErrorMessage(error);
                }

                public void success(Boolean value) {
                    try {
                        if (value.booleanValue()) {
                            ConnectionController.this.datasourceModel.getGuiStateModel().addConnection(ConnectionController.this.currentConnection);
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(ConnectionController.this.currentConnection);
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0001_UNABLE_TO_ADD_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        } else {
            this.service.updateConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    ConnectionController.this.displayErrorMessage(error);
                }

                public void success(Boolean value) {
                    try {
                        if (value.booleanValue()) {
                            ConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_UPDATED"));
                            ConnectionController.this.datasourceModel.getGuiStateModel().updateConnection(ConnectionController.this.currentConnection);
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(ConnectionController.this.currentConnection);
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0004_UNABLE_TO_UPDATE_CONNECTION"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public IXulAsyncConnectionService getService() {
        return this.service;
    }

    public void setService(IXulAsyncConnectionService service) {
        this.service = service;
    }

    public void addConnectionDialogListener(ConnectionDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConnectionDialogListener(ConnectionDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    @Bindable
    public void onDialogAccept(IDatabaseConnection arg0) {
        this.service.convertToConnection(arg0, new XulServiceCallback<IConnection>(){

            public void error(String message, Throwable error) {
                ConnectionController.this.displayErrorMessage(error);
            }

            public void success(IConnection retVal) {
                ConnectionController.this.currentConnection = retVal;
                ConnectionController.this.addConnection();
            }
        });
    }

    @Bindable
    public void onDialogCancel() {
    }

    @Bindable
    public void onDialogReady() {
        if (!this.datasourceModel.isEditing()) {
            this.showAddConnectionDialog();
        } else {
            this.showEditConnectionDialog();
        }
    }

    @Bindable
    public void showAddConnectionDialog() {
        this.datasourceModel.setEditing(false);
        if (this.databaseDialog != null) {
            this.databaseDialog.setDatabaseConnection(null);
            this.databaseDialog.show();
        } else {
            this.databaseDialog = new GwtDatabaseDialog((IXulAsyncDatabaseConnectionService)this.connService, this.databaseTypeHelper, "dataaccess-databasedialog.xul", (DatabaseDialogListener)this);
        }
    }

    @Bindable
    public void showEditConnectionDialog() {
        this.datasourceModel.setEditing(true);
        if (this.databaseDialog != null) {
            IConnection connection = this.datasourceModel.getSelectedRelationalConnection();
            this.service.convertFromConnection(connection, new XulServiceCallback<IDatabaseConnection>(){

                public void error(String message, Throwable error) {
                    ConnectionController.this.displayErrorMessage(error);
                }

                public void success(IDatabaseConnection conn) {
                    ConnectionController.this.databaseDialog.setDatabaseConnection(conn);
                    ConnectionController.this.databaseDialog.show();
                }
            });
        } else {
            this.databaseDialog = new GwtDatabaseDialog((IXulAsyncDatabaseConnectionService)this.connService, this.databaseTypeHelper, "dataaccess-databasedialog.xul", (DatabaseDialogListener)this);
        }
    }

    @Bindable
    public void showRemoveConnectionDialog() {
        this.removeConfirmationDialog.show();
    }

    @Bindable
    public void closeRemoveConfirmationDialog() {
        this.removeConfirmationDialog.hide();
    }

    public void reloadConnections() {
        if (this.service != null) {
            this.service.getConnections(new XulServiceCallback<List<IConnection>>(){

                public void error(String message, Throwable error) {
                    MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", error.getLocalizedMessage()));
                }

                public void success(List<IConnection> connections) {
                    ConnectionController.this.datasourceModel.getGuiStateModel().setConnections(connections);
                }
            });
        } else {
            MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), "DatasourceEditor.ERROR_0004_CONNECTION_SERVICE_NULL");
        }
    }
}

