/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.beans.BusinessData;
import org.pentaho.platform.dataaccess.datasource.beans.SerializedResultSet;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceService;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.components.XulTreeCol;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeChildren;
import org.pentaho.ui.xul.containers.XulTreeCols;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardRelationalDatasourceController
extends AbstractXulEventHandler {
    public static final int MAX_SAMPLE_DATA_ROWS = 5;
    public static final int MAX_COL_SIZE = 13;
    public static final String EMPTY_STRING = "";
    public static final String COMMA = ",";
    private XulDialog connectionDialog;
    private XulDialog waitingDialog = null;
    private XulDialog applyQueryConfirmationDialog = null;
    private XulLabel waitingDialogLabel = null;
    private XulDialog previewResultsDialog = null;
    private IXulAsyncDatasourceService service;
    private DatasourceModel datasourceModel;
    BindingFactory bf;
    XulTree previewResultsTable = null;
    XulTextbox datasourceName = null;
    XulListbox connections = null;
    XulTextbox query = null;
    XulTreeCols previewResultsTreeCols = null;
    XulTextbox previewLimit = null;
    XulButton editConnectionButton = null;
    XulButton removeConnectionButton = null;
    XulButton editQueryButton = null;
    XulButton previewButton = null;
    private XulDialog errorDialog;
    private XulDialog successDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    private XulTreeCol columnNameTreeCol = null;
    private XulTreeCol columnTypeTreeCol = null;
    XulTree sampleDataTree = null;
    XulDialog aggregationEditorDialog = null;
    XulDialog sampleDataDialog = null;

    @Bindable
    public void init(final DatasourceModel datasourceModel) {
        this.datasourceModel = datasourceModel;
        this.bf = new GwtBindingFactory(this.document);
        this.sampleDataTree = (XulTree)this.document.getElementById("relationalSampleDataTable");
        this.aggregationEditorDialog = (XulDialog)this.document.getElementById("relationalAggregationEditorDialog");
        this.sampleDataDialog = (XulDialog)this.document.getElementById("relationalSampleDataDialog");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.applyQueryConfirmationDialog = (XulDialog)this.document.getElementById("applyQueryConfirmationDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.waitingDialog = (XulDialog)this.document.getElementById("waitingDialog");
        this.waitingDialogLabel = (XulLabel)this.document.getElementById("waitingDialogLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.datasourceName = (XulTextbox)this.document.getElementById("datasourceName");
        this.connections = (XulListbox)this.document.getElementById("connectionList");
        this.query = (XulTextbox)this.document.getElementById("query");
        this.connectionDialog = (XulDialog)this.document.getElementById("connectionDialog");
        this.previewResultsDialog = (XulDialog)this.document.getElementById("previewResultsDialog");
        this.previewResultsTable = (XulTree)this.document.getElementById("previewResultsTable");
        this.previewResultsTreeCols = (XulTreeCols)this.document.getElementById("previewResultsTreeCols");
        this.previewLimit = (XulTextbox)this.document.getElementById("previewLimit");
        this.editConnectionButton = (XulButton)this.document.getElementById("editConnection");
        this.removeConnectionButton = (XulButton)this.document.getElementById("removeConnection");
        this.editQueryButton = (XulButton)this.document.getElementById("editQuery");
        this.previewButton = (XulButton)this.document.getElementById("preview");
        this.columnNameTreeCol = (XulTreeCol)this.document.getElementById("relationalColumnNameTreeCol");
        this.columnTypeTreeCol = (XulTreeCol)this.document.getElementById("relationalColumnTypeTreeCol");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)datasourceModel.getGuiStateModel(), "relationalPreviewValidated", (Object)this.previewButton, "!disabled", new BindingConvertor[0]);
        BindingConvertor<String, Boolean> widgetBindingConvertor = new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String value) {
                return value != null && value.length() > 0;
            }

            public String targetToSource(Boolean value) {
                return null;
            }
        };
        ArrayList bindingsThatNeedInitialized = new ArrayList();
        BindingConvertor<IConnection, Boolean> buttonConvertor = new BindingConvertor<IConnection, Boolean>(){

            public Boolean sourceToTarget(IConnection value) {
                return value != null;
            }

            public IConnection targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        Binding domainBinding = this.bf.createBinding((Object)datasourceModel.getGuiStateModel(), "connections", (Object)this.connections, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)datasourceModel, "selectedRelationalConnection", (Object)this.editConnectionButton, "!disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.createBinding((Object)datasourceModel, "selectedRelationalConnection", (Object)this.removeConnectionButton, "!disabled", new BindingConvertor[]{buttonConvertor});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)datasourceModel, "selectedRelationalConnection", (Object)this.connections, "selectedIndex", new BindingConvertor[]{new BindingConvertor<IConnection, Integer>(){

            public Integer sourceToTarget(IConnection connection) {
                if (connection != null) {
                    return datasourceModel.getGuiStateModel().getConnectionIndex(connection);
                }
                return -1;
            }

            public IConnection targetToSource(Integer value) {
                if (value >= 0) {
                    return datasourceModel.getGuiStateModel().getConnections().get(value);
                }
                return null;
            }
        }});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)datasourceModel.getGuiStateModel(), "previewLimit", (Object)this.previewLimit, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)datasourceModel, "query", (Object)this.query, "value", new BindingConvertor[0]);
        try {
            domainBinding.fireSourceChanged();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        for (Binding b : bindingsThatNeedInitialized) {
            try {
                b.fireSourceChanged();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return "relationalDatasourceController";
    }

    @Bindable
    public void closeConnectionDialog() {
        this.connectionDialog.hide();
    }

    @Bindable
    public void closeApplyQueryConfirmationDialog() {
        this.applyQueryConfirmationDialog.hide();
    }

    @Bindable
    public void displayPreview() {
        this.showWaitingDialog(MessageHandler.getString("DatasourceController.GENERATE_PREVIEW_DATA"), MessageHandler.getString("DatasourceController.WAIT"));
        this.service.doPreview(this.datasourceModel.getSelectedRelationalConnection().getName(), this.datasourceModel.getQuery(), this.datasourceModel.getGuiStateModel().getPreviewLimit(), new XulServiceCallback<SerializedResultSet>(){

            public void error(String message, Throwable error) {
                WizardRelationalDatasourceController.this.hideWaitingDialog();
                WizardRelationalDatasourceController.this.displayErrorMessage(error);
            }

            public void success(SerializedResultSet rs) {
                try {
                    int i;
                    List<List<String>> data = rs.getData();
                    String[] columns = rs.getColumns();
                    int columnCount = columns.length;
                    List previewResultsList = WizardRelationalDatasourceController.this.previewResultsTable.getChildNodes();
                    WizardRelationalDatasourceController.this.previewResultsDialog.show();
                    WizardRelationalDatasourceController.this.previewResultsTable.suppressLayout(true);
                    XulTreeChildren treeChildren = WizardRelationalDatasourceController.this.previewResultsTable.getRootChildren();
                    if (treeChildren != null) {
                        treeChildren.removeAll();
                    }
                    WizardRelationalDatasourceController.this.previewResultsTable.getColumns().getChildNodes().clear();
                    XulTreeCols treeCols = WizardRelationalDatasourceController.this.previewResultsTable.getColumns();
                    for (i = 0; i < columnCount; ++i) {
                        try {
                            XulTreeCol treeCol = (XulTreeCol)WizardRelationalDatasourceController.this.document.createElement("treecol");
                            treeCol.setLabel(columns[i]);
                            treeCol.setWidth(100);
                            treeCols.addColumn(treeCol);
                            continue;
                        }
                        catch (XulException e) {
                            // empty catch block
                        }
                    }
                    try {
                        for (i = 0; i < data.size(); ++i) {
                            XulTreeRow row = (XulTreeRow)WizardRelationalDatasourceController.this.document.createElement("treerow");
                            for (int j = 0; j < columnCount; ++j) {
                                XulTreeCell cell = (XulTreeCell)WizardRelationalDatasourceController.this.document.createElement("treecell");
                                cell.setLabel(WizardRelationalDatasourceController.this.getCellData(data, i, j));
                                row.addCell(cell);
                            }
                            WizardRelationalDatasourceController.this.previewResultsTable.addTreeRow(row);
                        }
                        WizardRelationalDatasourceController.this.previewResultsTable.suppressLayout(false);
                        WizardRelationalDatasourceController.this.previewResultsTable.update();
                        WizardRelationalDatasourceController.this.hideWaitingDialog();
                    }
                    catch (XulException e) {
                        WizardRelationalDatasourceController.this.hideWaitingDialog();
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    WizardRelationalDatasourceController.this.hideWaitingDialog();
                    WizardRelationalDatasourceController.this.displayErrorMessage(e);
                }
            }
        });
    }

    @Bindable
    public void closePreviewResultsDialog() {
        this.previewResultsDialog.hide();
    }

    public IXulAsyncDatasourceService getService() {
        return this.service;
    }

    public void setService(IXulAsyncDatasourceService service) {
        this.service = service;
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    @Bindable
    public void showWaitingDialog(String title, String message) {
        this.waitingDialog.setTitle(title);
        this.waitingDialogLabel.setValue(message);
        this.waitingDialog.show();
    }

    @Bindable
    public void hideWaitingDialog() {
        this.waitingDialog.hide();
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    public boolean supportsBusinessData(BusinessData businessData) {
        return businessData.getDomain().getPhysicalModels().get(0) instanceof SqlPhysicalModel;
    }

    private String getCellData(List<List<String>> data, int rowNumber, int columnNumber) {
        String returnValue = null;
        int rowCount = 0;
        for (List<String> row : data) {
            if (rowCount == rowNumber) {
                returnValue = row.get(columnNumber);
            }
            ++rowCount;
        }
        return returnValue;
    }

    public boolean finishing() {
        return true;
    }
}

