/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfoCollection;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DataRow;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IModelInfoValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfoValidationListenerCollection;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelInfo
extends XulEventSourceAdapter
implements Serializable {
    public static final String CSV_FILE_INFO_ATTRIBUTE = "fileInfo";
    public static final String CSV_COLUMN_INFO_ATTRIBUTE = "columns";
    public static final String STAGE_TABLE_NAME_ATTRIBUTE = "stageTableName";
    private static final long serialVersionUID = 2498165533158485182L;
    private CsvFileInfo fileInfo;
    private String stageTableName;
    private ColumnInfo[] columns;
    private transient ColumnInfoCollection columnCollection = new ColumnInfoCollection();
    private transient ModelInfoValidationListenerCollection listeners = new ModelInfoValidationListenerCollection();
    private boolean validated;
    private ArrayList<String> csvInputErrors = new ArrayList();
    private ArrayList<String> tableOutputErrors = new ArrayList();
    private transient FileTransformStats transformStats = new FileTransformStats();
    private String datasourceName;

    public ModelInfo() {
        this.columnCollection.addPropertyChangeListener("selectedCount", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ModelInfo.this.validate();
            }
        });
    }

    @Bindable
    public CsvFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Bindable
    public void setFileInfo(CsvFileInfo fileInfo) {
        CsvFileInfo previousVal = this.fileInfo;
        this.fileInfo = fileInfo;
        this.firePropertyChange(CSV_FILE_INFO_ATTRIBUTE, previousVal, fileInfo);
        this.validate();
    }

    @Bindable
    public ColumnInfo[] getColumns() {
        return this.columns;
    }

    @Bindable
    public void setColumns(ColumnInfo[] columns) {
        ColumnInfo[] previousVal = this.columns;
        this.columns = columns;
        this.firePropertyChange(CSV_COLUMN_INFO_ATTRIBUTE, previousVal, columns);
        this.setColumnCollection(columns);
        this.validate();
    }

    private void setColumnCollection(ColumnInfo[] columns) {
        this.columnCollection.clear();
        if (columns != null) {
            for (ColumnInfo column : columns) {
                this.columnCollection.add(column);
            }
        }
    }

    @Bindable
    public DataRow[] getData() {
        return this.transformStats.getDataRows();
    }

    @Bindable
    public void setData(DataRow[] data) {
        this.transformStats.setDataRows(data);
    }

    @Bindable
    public String getStageTableName() {
        return this.stageTableName;
    }

    @Bindable
    public void setStageTableName(String tableName) {
        String previousVal = this.stageTableName;
        this.stageTableName = tableName;
        this.firePropertyChange(STAGE_TABLE_NAME_ATTRIBUTE, previousVal, tableName);
        this.validate();
    }

    @Bindable
    public ArrayList<String> getCsvInputErrors() {
        return this.csvInputErrors;
    }

    @Bindable
    public void setCsvInputErrors(ArrayList<String> csvInputErrors) {
        this.csvInputErrors = csvInputErrors;
    }

    @Bindable
    public ArrayList<String> getTableOutputErrors() {
        return this.tableOutputErrors;
    }

    @Bindable
    public void setTableOutputErrors(ArrayList<String> tableOutputErrors) {
        this.tableOutputErrors = tableOutputErrors;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columns);
        result = 31 * result + (this.fileInfo == null ? 0 : this.fileInfo.hashCode());
        result = 31 * result + (this.stageTableName == null ? 0 : this.stageTableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelInfo other = (ModelInfo)obj;
        if (!Arrays.equals(this.columns, other.columns)) {
            return false;
        }
        if (this.fileInfo == null ? other.fileInfo != null : !this.fileInfo.equals(other.fileInfo)) {
            return false;
        }
        return !(this.stageTableName == null ? other.stageTableName != null : !this.stageTableName.equals(other.stageTableName));
    }

    public void validate() {
        if (this.stageTableName != null && this.stageTableName.trim().length() > 0 && this.fileInfo != null && this.fileInfo.getTmpFilename() != null && this.fileInfo.getTmpFilename().length() > 0 && this.fileInfo.getDelimiter() != null && this.fileInfo.getDelimiter().length() > 0) {
            this.listeners.fireCsvInfoValid();
            if (this.columnsAreValid()) {
                this.setValidated(true);
                this.listeners.fireModelInfoValid();
            } else {
                this.setValidated(false);
                this.listeners.fireModelInfoInvalid();
            }
        } else {
            this.setValidated(false);
            this.listeners.fireCsvInfoInvalid();
            this.listeners.fireModelInfoInvalid();
        }
    }

    private boolean columnsAreValid() {
        if (this.columns != null) {
            for (ColumnInfo col : this.columns) {
                if (col == null) {
                    return false;
                }
                if (col.getDataType() == null) {
                    return false;
                }
                if (col.getTitle() == null) {
                    return false;
                }
                if (col.getId() == null) {
                    return false;
                }
                if (col.getDataType() == null) {
                    return false;
                }
                if (col.getTitle().trim().length() == 0) {
                    return false;
                }
                if (col.getId().trim().length() != 0) continue;
                return false;
            }
            return this.columnCollection.getSelectedCount() != 0;
        }
        return false;
    }

    @Bindable
    public boolean isValidated() {
        return this.validated;
    }

    @Bindable
    private void setValidated(boolean value) {
        if (value != this.validated) {
            this.validated = value;
            this.firePropertyChange("validated", !value, value);
        }
    }

    public void clearModel() {
        this.setStageTableName(null);
        this.getFileInfo().clear();
        this.setColumns(null);
        this.setData(null);
        this.validate();
    }

    public void addModelInfoValidationListener(IModelInfoValidationListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.add(listener);
        }
    }

    public FileTransformStats getTransformStats() {
        return this.transformStats;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }
}

