/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.dummy.DummyDatasource;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardModel
extends XulEventSourceAdapter
implements IWizardModel {
    private LinkedHashSet<IWizardDatasource> datasources = new LinkedHashSet();
    private String datasourceName;
    private boolean editing;
    private List<Class<? extends IWizardDatasource>> ignoredDatasources = new ArrayList<Class<? extends IWizardDatasource>>();
    private IWizardDatasource selectedDatasource;
    private boolean reportingOnlyValid = true;

    public WizardModel() {
        this.addDatasource(new DummyDatasource());
    }

    @Override
    @Bindable
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Override
    @Bindable
    public void setDatasourceName(String datasourceName) {
        String prevVal = this.datasourceName;
        this.datasourceName = datasourceName;
        this.firePropertyChange("datasourceName", prevVal, datasourceName);
    }

    @Bindable
    public Set getDatasources() {
        return this.datasources;
    }

    @Override
    public void addDatasource(IWizardDatasource datasource) {
        if (this.ignoredDatasources.contains(datasource.getClass())) {
            return;
        }
        boolean reallyAdded = this.datasources.add(datasource);
        if (reallyAdded) {
            this.firePropertyChange("datasources", null, this.datasources);
        }
        if (this.selectedDatasource == null) {
            this.setSelectedDatasource((IWizardDatasource)this.datasources.iterator().next());
        }
    }

    @Override
    @Bindable
    public void setSelectedDatasource(IWizardDatasource datasource) {
        IWizardDatasource prevSelection = this.selectedDatasource;
        this.selectedDatasource = datasource;
        this.firePropertyChange("selectedDatasource", prevSelection, this.selectedDatasource);
    }

    @Override
    @Bindable
    public IWizardDatasource getSelectedDatasource() {
        return this.selectedDatasource;
    }

    @Override
    public void removeDatasourceByType(Class<? extends IWizardDatasource> datasource) {
        this.ignoredDatasources.add(datasource);
        IWizardDatasource matchedSource = null;
        for (IWizardDatasource source : this.datasources) {
            if (!source.getClass().equals(datasource)) continue;
            matchedSource = source;
            break;
        }
        if (matchedSource != null) {
            this.datasources.remove(matchedSource);
        }
    }

    @Override
    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public void setEditing(boolean editing) {
        this.editing = editing;
        this.firePropertyChange("editing", !this.editing, this.editing);
    }

    @Override
    @Bindable
    public boolean isReportingOnlyValid() {
        return this.reportingOnlyValid;
    }

    @Override
    @Bindable
    public void setReportingOnlyValid(boolean reportingOnlyValid) {
        this.reportingOnlyValid = reportingOnlyValid;
        this.firePropertyChange("reportingOnlyValid", !this.reportingOnlyValid, this.reportingOnlyValid);
    }

    @Override
    public void reset() {
        this.setDatasourceName("");
        this.setSelectedDatasource((IWizardDatasource)this.datasources.iterator().next());
        this.setReportingOnlyValid(true);
        for (IWizardDatasource source : this.datasources) {
            source.reset();
        }
    }
}

