/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseConnectionService;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.beans.Connection;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.ConnectionServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.repository.hibernate.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionServiceImpl
extends PentahoBase
implements IConnectionService {
    private IDataAccessPermissionHandler dataAccessPermHandler;
    private IDatasourceMgmtService datasourceMgmtSvc;
    private static final Log logger = LogFactory.getLog(ConnectionServiceImpl.class);

    public Log getLogger() {
        return logger;
    }

    public ConnectionServiceImpl() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        this.datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)session);
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String dataAccessClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-permission-handler", SimpleDataAccessPermissionHandler.class.getName());
            Class<?> clazz = Class.forName(dataAccessClassName, true, this.getClass().getClassLoader());
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessPermHandler = (IDataAccessPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0007_DATAACCESS_PERMISSIONS_INIT_ERROR", e.getLocalizedMessage()), (Throwable)e);
            this.dataAccessPermHandler = new SimpleDataAccessPermissionHandler();
        }
    }

    protected boolean hasDataAccessPermission() {
        return this.dataAccessPermHandler != null && this.dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession());
    }

    @Override
    public List<IConnection> getConnections() throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        ArrayList<IConnection> connectionList = new ArrayList<IConnection>();
        try {
            for (IDatasource datasource : this.datasourceMgmtSvc.getDatasources()) {
                connectionList.add(this.convertTo(datasource));
            }
        }
        catch (DatasourceMgmtServiceException dme) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0002_UNABLE_TO_GET_CONNECTION_LIST", dme.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0002_UNABLE_TO_GET_CONNECTION_LIST", dme.getLocalizedMessage()), dme);
        }
        return connectionList;
    }

    @Override
    public IConnection getConnectionByName(String name) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            IConnection connection = this.convertTo(this.datasourceMgmtSvc.getDatasource(name));
            if (connection != null) {
                return connection;
            }
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", name));
        }
        catch (DatasourceMgmtServiceException dme) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, dme.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, dme.getLocalizedMessage()), dme);
        }
    }

    @Override
    public boolean addConnection(IConnection connection) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            HibernateUtil.beginTransaction();
            this.datasourceMgmtSvc.createDatasource(this.convertFrom(connection));
            HibernateUtil.commitTransaction();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), e.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), e.getLocalizedMessage()), e);
        }
    }

    @Override
    public boolean updateConnection(IConnection connection) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            HibernateUtil.beginTransaction();
            connection.setPassword(ConnectionServiceHelper.getConnectionPassword(connection.getName(), connection.getPassword()));
            this.datasourceMgmtSvc.updateDatasource(this.convertFrom(connection));
            HibernateUtil.commitTransaction();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), e.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), e.getLocalizedMessage()), e);
        }
    }

    @Override
    public boolean deleteConnection(IConnection connection) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            HibernateUtil.beginTransaction();
            this.datasourceMgmtSvc.deleteDatasource(this.convertFrom(connection));
            HibernateUtil.commitTransaction();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), e.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), e.getLocalizedMessage()), e);
        }
    }

    @Override
    public boolean deleteConnection(String name) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            HibernateUtil.beginTransaction();
            this.datasourceMgmtSvc.deleteDatasource(name);
            HibernateUtil.commitTransaction();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, e.getLocalizedMessage()));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public boolean testConnection(IConnection connection) throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        if (connection != null) {
            IPentahoConnection pentahoConnection;
            if (connection.getPassword() == null) {
                connection.setPassword("");
            }
            if ((pentahoConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)connection.getDriverClass(), (String)connection.getUrl(), (String)connection.getUsername(), (String)ConnectionServiceHelper.getConnectionPassword(connection.getName(), connection.getPassword()), null, (ILogger)this)) != null) {
                boolean testedOk = ((SQLConnection)pentahoConnection).getNativeConnection() != null;
                pentahoConnection.close();
                return testedOk;
            }
            return false;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0008_UNABLE_TO_TEST_NULL_CONNECTION"));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0008_UNABLE_TO_TEST_NULL_CONNECTION"));
    }

    private IConnection convertTo(IDatasource datasource) {
        if (datasource == null) {
            return null;
        }
        Connection returnDatasource = new Connection();
        returnDatasource.setDriverClass(datasource.getDriverClass());
        returnDatasource.setName(datasource.getName());
        returnDatasource.setPassword(ConnectionServiceHelper.encodePassword(datasource.getPassword()));
        returnDatasource.setUsername(datasource.getUserName());
        returnDatasource.setUrl(datasource.getUrl());
        return returnDatasource;
    }

    private IDatasource convertFrom(IConnection connection) {
        if (connection == null) {
            return null;
        }
        IDatasource returnDatasource = (IDatasource)PentahoSystem.get(IDatasource.class, null);
        returnDatasource.setDriverClass(connection.getDriverClass());
        returnDatasource.setName(connection.getName());
        returnDatasource.setPassword(connection.getPassword());
        returnDatasource.setUserName(connection.getUsername());
        returnDatasource.setUrl(connection.getUrl());
        return returnDatasource;
    }

    @Override
    public IDatabaseConnection convertFromConnection(IConnection connection) throws ConnectionServiceException {
        if (connection == null) {
            return null;
        }
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            IServiceManager manager = (IServiceManager)PentahoSystem.get(IServiceManager.class);
            DatabaseConnectionService service = (DatabaseConnectionService)manager.getServiceBean("gwt", "databaseConnectionService");
            IDatabaseConnection conn = service.createDatabaseConnection(connection.getDriverClass(), connection.getUrl());
            conn.setName(connection.getName());
            conn.setUsername(connection.getUsername());
            conn.setPassword(ConnectionServiceHelper.encodePassword(connection.getPassword()));
            return conn;
        }
        catch (ServiceException e) {
            throw new ConnectionServiceException(e);
        }
        catch (Throwable e) {
            throw new ConnectionServiceException(e);
        }
    }

    @Override
    public IConnection convertToConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        if (connection == null) {
            return null;
        }
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            IServiceManager manager = (IServiceManager)PentahoSystem.get(IServiceManager.class);
            DatabaseDialectService service = (DatabaseDialectService)manager.getServiceBean("gwt", "databaseDialectService");
            IDatabaseDialect dialect = service.getDialect(connection);
            Connection conn = new Connection();
            conn.setName(connection.getName());
            conn.setUsername(connection.getUsername());
            conn.setPassword(connection.getPassword());
            String url = dialect.getURLWithExtraOptions(connection);
            conn.setUrl(url);
            if (connection.getDatabaseType().getShortName().equals("GENERIC")) {
                conn.setDriverClass((String)connection.getAttributes().get("CUSTOM_DRIVER_CLASS"));
            } else {
                conn.setDriverClass(dialect.getNativeDriver());
            }
            return conn;
        }
        catch (DatabaseDialectException e) {
            throw new ConnectionServiceException(e);
        }
        catch (ServiceException e) {
            throw new ConnectionServiceException(e);
        }
    }
}

