/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessViewPermissionHandler;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataAccessViewPermissionHandler
implements IDataAccessViewPermissionHandler {
    private Log logger = LogFactory.getLog(SimpleDataAccessViewPermissionHandler.class);

    @Override
    public List<String> getPermittedRoleList(IPentahoSession session) {
        ArrayList<String> roleList = new ArrayList<String>();
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)session, (boolean)true);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String roles = null;
        try {
            roles = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-roles");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (roles != null) {
            String[] roleArr;
            for (String role : roleArr = roles.split(",")) {
                for (GrantedAuthority userRole : auth.getAuthorities()) {
                    if (role == null || !role.trim().equals(userRole.getAuthority())) continue;
                    roleList.add(role);
                }
            }
        }
        return roleList;
    }

    @Override
    public List<String> getPermittedUserList(IPentahoSession session) {
        ArrayList<String> userList = new ArrayList<String>();
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String users = null;
        try {
            users = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-users");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (users != null) {
            String[] userArr;
            for (String user : userArr = users.split(",")) {
                if (user == null || user.trim().length() <= 0) continue;
                userList.add(user);
            }
        }
        return userList;
    }

    @Override
    public int getDefaultAcls(IPentahoSession session) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String defaultAclsAsString = null;
        int defaultAcls = -1;
        try {
            defaultAclsAsString = resLoader.getPluginSetting(this.getClass(), "settings/data-access-default-view-acls");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting plugin setting", (Throwable)e);
        }
        if (defaultAclsAsString != null && defaultAclsAsString.length() > 0) {
            defaultAcls = Integer.parseInt(defaultAclsAsString);
        }
        return defaultAcls;
    }

    @Override
    public boolean hasDataAccessViewPermission(IPentahoSession session) {
        return this.getPermittedUserList(session).size() > 0 || this.getPermittedRoleList(session).size() > 0;
    }
}

