/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.csv;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.pentaho.platform.dataaccess.datasource.Delimiter;
import org.pentaho.platform.dataaccess.datasource.Enclosure;
import org.pentaho.platform.dataaccess.datasource.wizard.AbstractWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IModelInfoValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.CsvDatasource;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulRow;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.stereotype.Bindable;

public class CsvPhysicalStep
extends AbstractWizardStep {
    public static final int DEFAULT_CSV_TABLE_ROW_COUNT = 7;
    private XulMenuList<String> encodingTypeMenuList = null;
    private static final List<String> ENCODINGS = Arrays.asList("", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE", "Shift_JIS", "ISO-2022-JP", "ISO-2022-CN", "ISO-2022-KR", "GB18030", "Big5", "EUC-JP", "EUC-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "windows-1251", "windows-1256", "KOI8-R", "ISO-8859-9");
    private XulTextbox uploadedFileTextBox;
    private XulTree csvDataTable;
    private XulLabel csvTextPreview;
    private DatasourceModel datasourceModel;
    private ICsvDatasourceServiceAsync csvDatasourceService;

    public CsvPhysicalStep(DatasourceModel datasourceModel, CsvDatasource parentDatasource, ICsvDatasourceServiceAsync csvDatasourceService) {
        super(parentDatasource);
        this.datasourceModel = datasourceModel;
        this.csvDatasourceService = csvDatasourceService;
    }

    public void activating() {
        this.parentDatasource.setFinishable(false);
        this.stepRow = (XulRow)this.document.getElementById("step_rows").getFirstChild();
        this.stepImage = (XulImage)this.stepRow.getFirstChild();
        this.stepLabel = (XulLabel)this.stepRow.getChildNodes().get(1);
    }

    public void deactivate() {
    }

    public XulComponent getUIComponent() {
        return this.document.getElementById("csvDeckPanel");
    }

    public String getStepName() {
        return "CSV Physical";
    }

    public void setBindings() {
        this.csvDataTable = (XulTree)this.document.getElementById("csvDataTable");
        this.uploadedFileTextBox = (XulTextbox)this.document.getElementById("uploadedFile");
        this.csvTextPreview = (XulLabel)this.document.getElementById("csvTextPreview");
        this.encodingTypeMenuList = (XulMenuList)this.document.getElementById("encodingTypeMenuList");
        this.encodingTypeMenuList.setElements(ENCODINGS);
        BindingConvertor isFirstRowHeaderConverter = BindingConvertor.integer2Boolean();
        this.bf.createBinding((Object)this.datasourceModel.getModelInfo().getFileInfo(), "headerRows", "isHeaderCheckBox", "checked", new BindingConvertor[]{isFirstRowHeaderConverter});
        BindingConvertor<String, String> delimiterBindingConvertor = new BindingConvertor<String, String>(){

            public String sourceToTarget(String source) {
                Delimiter delimiter = Delimiter.lookupValue(source);
                if (delimiter != null) {
                    return Delimiter.lookupValue(source).getName();
                }
                return source;
            }

            public String targetToSource(String target) {
                Delimiter delimiter = Delimiter.lookupName(target);
                if (delimiter != null) {
                    return delimiter.getValue();
                }
                return target;
            }
        };
        this.bf.createBinding((Object)this.datasourceModel.getModelInfo().getFileInfo(), "delimiter", "delimiterRadioGroup", "value", new BindingConvertor[]{delimiterBindingConvertor});
        BindingConvertor<String, String> enclosureBindingConvertor = new BindingConvertor<String, String>(){

            public String sourceToTarget(String source) {
                Enclosure e = Enclosure.lookupValue(source);
                if (e == null) {
                    e = Enclosure.NONE;
                }
                return e.getName();
            }

            public String targetToSource(String target) {
                Enclosure e = Enclosure.lookupName(target);
                if (e == Enclosure.NONE) {
                    return null;
                }
                return e.getValue();
            }
        };
        this.bf.createBinding((Object)this.datasourceModel.getModelInfo().getFileInfo(), "enclosure", "enclosureRadioGroup", "value", new BindingConvertor[]{enclosureBindingConvertor});
        this.datasourceModel.getModelInfo().getFileInfo().addPropertyChangeListener("delimiter", new RefreshPreviewPropertyChangeListener());
        this.datasourceModel.getModelInfo().getFileInfo().addPropertyChangeListener("enclosure", new RefreshPreviewPropertyChangeListener());
        this.datasourceModel.getModelInfo().getFileInfo().addPropertyChangeListener("headerRows", new RefreshPreviewPropertyChangeListener());
        this.uploadedFileTextBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value")) {
                    String enclosure;
                    String delimiter = CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getDelimiter();
                    if (delimiter == null || delimiter.equals("")) {
                        CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setDelimiter(",");
                        CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setHeaderRows(1);
                    }
                    if ((enclosure = CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getEnclosure()) == null || enclosure.equals("")) {
                        CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setEnclosure("\"");
                    }
                    CsvPhysicalStep.this.syncModelInfo();
                    CsvPhysicalStep.this.datasourceModel.getGuiStateModel().setDirty(true);
                    CsvPhysicalStep.this.datasourceModel.getModelInfo().validate();
                }
            }
        });
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.uploadedFileTextBox, "value", "isHeaderCheckBox", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()});
        this.bf.createBinding((Object)this.uploadedFileTextBox, "value", "delimiterRadioGroup", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()});
        this.bf.createBinding((Object)this.uploadedFileTextBox, "value", "enclosureRadioGroup", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()});
        this.bf.createBinding((Object)this.datasourceModel.getModelInfo().getFileInfo(), "friendlyFilename", (Object)this.uploadedFileTextBox, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.uploadedFileTextBox, "value", "encodingTypeMenuList", "!disabled", new BindingConvertor[]{BindingConvertor.object2Boolean()});
        BindingConvertor<String, String> encodingBindingConvertor = new BindingConvertor<String, String>(){

            public String sourceToTarget(String source) {
                return source;
            }

            public String targetToSource(String target) {
                Collection encodings = CsvPhysicalStep.this.encodingTypeMenuList.getElements();
                if (target != null && !encodings.contains(target)) {
                    encodings.add(target);
                    CsvPhysicalStep.this.encodingTypeMenuList.setElements(encodings);
                }
                return target;
            }
        };
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding(this.encodingTypeMenuList, "value", (Object)this.datasourceModel.getModelInfo().getFileInfo(), "encoding", new BindingConvertor[]{encodingBindingConvertor});
        RefreshPreviewPropertyChangeListener previewChangeListener = new RefreshPreviewPropertyChangeListener();
        this.datasourceModel.getModelInfo().getFileInfo().addPropertyChangeListener("encoding", previewChangeListener);
        this.datasourceModel.getModelInfo().getFileInfo().addPropertyChangeListener("tmpFilename", previewChangeListener);
    }

    public void stepActivatingReverse() {
        super.stepActivatingReverse();
        this.parentDatasource.setFinishable(false);
    }

    private boolean isValidated() {
        return this.datasourceModel.getModelInfo().getStageTableName() != null && this.datasourceModel.getModelInfo().getStageTableName().trim().length() > 0 && this.datasourceModel.getModelInfo().getFileInfo() != null && this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename() != null && this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename().length() > 0 && this.datasourceModel.getModelInfo().getFileInfo().getDelimiter() != null && this.datasourceModel.getModelInfo().getFileInfo().getDelimiter().length() > 0;
    }

    public void syncModelInfo() {
        String filename = this.datasourceModel.getModelInfo().getFileInfo().getFilename();
        String tmpFilename = this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename();
        if (filename == null || tmpFilename != null && !tmpFilename.startsWith(filename)) {
            filename = tmpFilename;
        } else if (tmpFilename == null || tmpFilename.startsWith(filename)) {
            this.datasourceModel.getModelInfo().getFileInfo().setTmpFilename(filename);
        }
        if (filename != null) {
            this.csvDatasourceService.getEncoding(filename, new AsyncCallback<String>(){

                public void onSuccess(String encoding) {
                    CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setEncodingFromServer(encoding);
                    try {
                        CsvPhysicalStep.this.csvDatasourceService.getPreviewRows(CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename(), CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getHeaderRows() > 0, 10, encoding, new AsyncCallback<List<String>>(){

                            public void onSuccess(List<String> lines) {
                                try {
                                    CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setContents(lines);
                                    CsvPhysicalStep.this.refreshPreview();
                                }
                                catch (Exception e) {
                                    GWT.log((String)"Had an issue refreshing the data preview", (Throwable)e);
                                }
                            }

                            public void onFailure(Throwable th) {
                                MessageHandler.getInstance().showErrorDialog(th.getMessage());
                            }
                        });
                    }
                    catch (Exception e) {
                        MessageHandler.getInstance().showErrorDialog(e.getMessage());
                    }
                }

                public void onFailure(Throwable th) {
                    GWT.log((String)"Had an issue getting the encoding type", (Throwable)th);
                }
            });
        } else {
            try {
                this.refreshPreview();
            }
            catch (Exception e) {
                GWT.log((String)"Had an issue refreshing the data preview", (Throwable)e);
            }
        }
    }

    @Bindable
    public void refreshPreview() throws Exception {
        this.csvTextPreview.setValue("");
        CsvFileInfo fileInfo = this.datasourceModel.getModelInfo().getFileInfo();
        this.csvTextPreview.setValue(fileInfo.formatSampleContents());
    }

    public void refresh() {
    }

    private class RefreshPreviewPropertyChangeListener
    implements PropertyChangeListener {
        private RefreshPreviewPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CsvPhysicalStep.this.datasourceModel.getGuiStateModel().setDirty(true);
            try {
                String propName = evt.getPropertyName();
                if (propName.equals("encoding") || propName.equals("tmpFilename")) {
                    CsvPhysicalStep.this.csvDatasourceService.getPreviewRows(CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename(), CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getHeaderRows() > 0, 10, CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().getEncoding(), new AsyncCallback<List<String>>(){

                        public void onSuccess(List<String> lines) {
                            try {
                                CsvPhysicalStep.this.datasourceModel.getModelInfo().getFileInfo().setContents(lines);
                                CsvPhysicalStep.this.refreshPreview();
                            }
                            catch (Exception e) {
                                GWT.log((String)"Had an issue refreshing the data preview", (Throwable)e);
                            }
                        }

                        public void onFailure(Throwable th) {
                            GWT.log((String)th.toString());
                        }
                    });
                }
                CsvPhysicalStep.this.refreshPreview();
            }
            catch (Exception e) {
                GWT.log((String)e.toString());
            }
            CsvPhysicalStep.this.datasourceModel.getModelInfo().validate();
            CsvPhysicalStep.this.datasourceModel.getModelInfo().addModelInfoValidationListener(new IModelInfoValidationListener(){

                public void onCsvInValid() {
                    CsvPhysicalStep.this.setValid(CsvPhysicalStep.this.isValidated());
                }

                public void onCsvValid() {
                    CsvPhysicalStep.this.setValid(CsvPhysicalStep.this.isValidated());
                }

                public void onModelInfoValid() {
                    CsvPhysicalStep.this.setValid(CsvPhysicalStep.this.isValidated());
                }

                public void onModelInfoInvalid() {
                    CsvPhysicalStep.this.setValid(CsvPhysicalStep.this.isValidated());
                }
            });
        }
    }
}

