/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.JoinSelectionServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.MultiTableDatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.JoinDefinitionsStep;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.JoinError;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.JoinValidator;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultitableGuiModel;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.TablesSelectionStep;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryPhysicalStep;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTableDatasource
extends AbstractXulEventHandler
implements IWizardDatasource {
    private boolean finishable;
    private MultitableGuiModel joinGuiModel = new MultitableGuiModel();
    private JoinSelectionServiceGwtImpl joinSelectionServiceGwtImpl = new JoinSelectionServiceGwtImpl();
    private QueryPhysicalStep connectionSelectionStep;
    private TablesSelectionStep tablesSelectionStep;
    private JoinDefinitionsStep joinDefinitionsStep;
    private IConnection connection;
    private BindingFactory bf;
    private IWizardModel wizardModel;
    private JoinValidator validator = new JoinValidator(this.joinGuiModel, this.wizardModel);
    private XulDialog errorDialog;
    private XulLabel errorLabel;

    public MultiTableDatasource(DatasourceModel datasourceModel) {
        this.joinSelectionServiceGwtImpl.gwtWorkaround(new BogoPojo(), new XulServiceCallback<BogoPojo>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(BogoPojo bogoPojo) {
                bogoPojo.getJoinDTO();
            }
        });
        this.connectionSelectionStep = new QueryPhysicalStep(datasourceModel, this, false);
        this.tablesSelectionStep = new TablesSelectionStep(this.joinGuiModel, this.joinSelectionServiceGwtImpl, this);
        this.joinDefinitionsStep = new JoinDefinitionsStep(this.joinGuiModel, this.joinSelectionServiceGwtImpl, this);
    }

    @Override
    public void activating() throws XulException {
        this.connectionSelectionStep.activating();
        this.tablesSelectionStep.activating();
        this.joinDefinitionsStep.activating();
        XulVbox queryVbox = (XulVbox)this.document.getElementById("queryBox");
        queryVbox.setVisible(false);
        XulVbox metadataVbox = (XulVbox)this.document.getElementById("metadata");
        metadataVbox.setVisible(true);
        XulVbox connectionsVbox = (XulVbox)this.document.getElementById("connectionsLbl");
        connectionsVbox.setVisible(true);
        XulListbox connections = (XulListbox)this.document.getElementById("connectionList");
        connections.setWidth(568);
        connections.setHeight(275);
        this.joinGuiModel.setDoOlap(!this.wizardModel.isReportingOnlyValid());
        try {
            this.bf.createBinding((Object)this.wizardModel, "reportingOnlyValid", "metadata", "visible", new BindingConvertor[0]).fireSourceChanged();
            this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
            XulRadio olapRadio = (XulRadio)this.document.getElementById("reporting_analysis");
            this.bf.createBinding((Object)olapRadio, "checked", (Object)this.joinGuiModel, "doOlap", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            XulRadio reportingRadio = (XulRadio)this.document.getElementById("reporting");
            this.bf.createBinding((Object)this.wizardModel, "reportingOnlyValid", (Object)reportingRadio, "checked", new BindingConvertor[0]).fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.connectionSelectionStep.setValid(true);
        this.setConnection(this.connectionSelectionStep.getConnection());
    }

    @Override
    public void deactivating() {
        this.connectionSelectionStep.deactivate();
        this.tablesSelectionStep.deactivate();
        this.joinDefinitionsStep.deactivate();
    }

    @Override
    public void init(XulDomContainer container, IWizardModel wizardModel) throws XulException {
        this.wizardModel = wizardModel;
        this.document = container.getDocumentRoot();
        this.bf = new GwtBindingFactory(this.document);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        container.addEventHandler((XulEventHandler)this.connectionSelectionStep);
        container.addEventHandler((XulEventHandler)this.tablesSelectionStep);
        container.addEventHandler((XulEventHandler)this.joinDefinitionsStep);
        this.connectionSelectionStep.init(wizardModel);
        this.tablesSelectionStep.init(wizardModel);
        this.joinDefinitionsStep.init(wizardModel);
        this.bf.createBinding((Object)this.connectionSelectionStep, "connection", (Object)this, "connection", new BindingConvertor[0]);
    }

    @Override
    @Bindable
    public String getName() {
        return MessageHandler.getString("multitable.DATABASE_TABLES");
    }

    @Override
    public List<IWizardStep> getSteps() {
        ArrayList<IWizardStep> steps = new ArrayList<IWizardStep>();
        steps.add(this.connectionSelectionStep);
        steps.add(this.tablesSelectionStep);
        steps.add(this.joinDefinitionsStep);
        return steps;
    }

    protected void displayErrors(JoinError error) {
        this.errorDialog.setTitle(error.getTitle());
        this.errorLabel.setValue(error.getError());
        this.errorDialog.show();
    }

    @Override
    public void onFinish(final XulServiceCallback<IDatasourceSummary> callback) {
        if (this.validator.allTablesJoined()) {
            String dsName = this.wizardModel.getDatasourceName();
            MultiTableDatasourceDTO dto = this.joinGuiModel.createMultiTableDatasourceDTO(dsName);
            dto.setSelectedConnection(this.connection);
            this.joinSelectionServiceGwtImpl.serializeJoins(dto, this.connection, new XulServiceCallback<IDatasourceSummary>(){

                public void error(String message, Throwable error) {
                    error.printStackTrace();
                }

                public void success(IDatasourceSummary value) {
                    callback.success((Object)value);
                }
            });
        } else {
            MessageHandler.getInstance().closeWaitingDialog();
            XulDialog wizardDialog = (XulDialog)this.document.getElementById("main_wizard_window");
            wizardDialog.show();
            this.displayErrors(this.validator.getError());
        }
    }

    @Override
    public String getId() {
        return "MULTI-TABLE-DS";
    }

    @Override
    public boolean isFinishable() {
        return this.finishable;
    }

    @Override
    @Bindable
    public void setFinishable(boolean finishable) {
        this.finishable = finishable;
        this.firePropertyChange("finishable", !finishable, finishable);
    }

    @Override
    public void restoreSavedDatasource(final Domain previousDomain, final XulServiceCallback<Void> callback) {
        String serializedDatasource = (String)((LogicalModel)previousDomain.getLogicalModels().get(0)).getProperty("datasourceModel");
        this.joinSelectionServiceGwtImpl.deSerializeModelState(serializedDatasource, new XulServiceCallback<MultiTableDatasourceDTO>(){

            public void success(final MultiTableDatasourceDTO datasourceDTO) {
                MultiTableDatasource.this.wizardModel.setDatasourceName(datasourceDTO.getDatasourceName());
                MultiTableDatasource.this.connectionSelectionStep.selectConnectionByName(datasourceDTO.getSelectedConnection().getName());
                MultiTableDatasource.this.joinSelectionServiceGwtImpl.getDatabaseTables(MultiTableDatasource.this.connection, null, new XulServiceCallback<List>(){

                    public void error(String message, Throwable error) {
                        error.printStackTrace();
                    }

                    public void success(List tables) {
                        MultiTableDatasource.this.joinGuiModel.populateJoinGuiModel(previousDomain, datasourceDTO, tables);
                        MultiTableDatasource.this.tablesSelectionStep.setValid(true);
                        if (MultiTableDatasource.this.joinGuiModel.isDoOlap()) {
                            MultiTableDatasource.this.tablesSelectionStep.setFactTable(MultiTableDatasource.this.joinGuiModel.getFactTable());
                        }
                        callback.success(null);
                    }
                });
            }

            public void error(String s, Throwable throwable) {
                MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", throwable.getLocalizedMessage()));
                callback.error(s, throwable);
            }
        });
    }

    @Override
    public void reset() {
        this.joinGuiModel.reset();
    }

    @Bindable
    public IConnection getConnection() {
        return this.connection;
    }

    @Bindable
    public void setConnection(IConnection connection) {
        this.connection = connection;
        this.joinGuiModel.reset();
        this.joinDefinitionsStep.resetComponents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NotDisabledBindingConvertor
    extends BindingConvertor<Boolean, Boolean> {
        NotDisabledBindingConvertor() {
        }

        public Boolean sourceToTarget(Boolean value) {
            return value == false;
        }

        public Boolean targetToSource(Boolean value) {
            return value == false;
        }
    }
}

