/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formatting;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.pentaho.reporting.libraries.formatting.FastFormat;

public class FastDateFormat
implements FastFormat {
    private Locale locale;
    private SimpleDateFormat dateFormat;
    private String pattern;

    public FastDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public FastDateFormat(String pattern, Locale locale) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.locale = locale;
        this.dateFormat = new SimpleDateFormat(pattern, new DateFormatSymbols(locale));
    }

    public FastDateFormat(int dateStyle, int timeStyle, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            this.dateFormat = (SimpleDateFormat)dateFormat;
            this.pattern = this.dateFormat.toPattern();
        } else {
            String timeText;
            String dateText;
            ResourceBundle datePatterns = ResourceBundle.getBundle("org.pentaho.reporting.libraries.formatting.format-patterns");
            switch (dateStyle) {
                case 3: {
                    dateText = datePatterns.getString("format.date.short");
                    break;
                }
                case 2: {
                    dateText = datePatterns.getString("format.date.medium");
                    break;
                }
                case 1: {
                    dateText = datePatterns.getString("format.date.long");
                    break;
                }
                case 0: {
                    dateText = datePatterns.getString("format.date.full");
                    break;
                }
                default: {
                    dateText = null;
                }
            }
            switch (timeStyle) {
                case 3: {
                    timeText = datePatterns.getString("format.time.short");
                    break;
                }
                case 2: {
                    timeText = datePatterns.getString("format.time.medium");
                    break;
                }
                case 1: {
                    timeText = datePatterns.getString("format.time.long");
                    break;
                }
                case 0: {
                    timeText = datePatterns.getString("format.time.full");
                    break;
                }
                default: {
                    timeText = null;
                }
            }
            if (dateText == null && timeText == null) {
                throw new IllegalArgumentException();
            }
            if (dateText == null) {
                this.pattern = timeText;
            } else if (timeText == null) {
                this.pattern = dateText;
            } else {
                String messagePattern = datePatterns.getString("format.datetime");
                this.pattern = MessageFormat.format(messagePattern, dateText, timeText);
            }
            this.dateFormat = new SimpleDateFormat(this.pattern, new DateFormatSymbols(locale));
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.locale.equals(locale)) {
            return;
        }
        this.locale = locale;
        this.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
        this.dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String format(Object parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        return this.dateFormat.format(parameters);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

