/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formatting;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.pentaho.reporting.libraries.formatting.FastFormat;

public class FastDecimalFormat
implements FastFormat {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_CURRENCY = 2;
    public static final int TYPE_PERCENT = 3;
    private Locale locale;
    private DecimalFormat decimalFormat;
    private String pattern;

    public FastDecimalFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public FastDecimalFormat(String pattern, Locale locale) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.locale = locale;
        this.decimalFormat = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    private NumberFormat createFormat(int type, Locale locale) {
        switch (type) {
            case 1: {
                return NumberFormat.getIntegerInstance(locale);
            }
            case 3: {
                return NumberFormat.getPercentInstance(locale);
            }
            case 2: {
                return NumberFormat.getCurrencyInstance(locale);
            }
        }
        return NumberFormat.getInstance(locale);
    }

    public FastDecimalFormat(int type, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        NumberFormat rawFormat = this.createFormat(type, locale);
        if (rawFormat instanceof DecimalFormat) {
            this.decimalFormat = (DecimalFormat)rawFormat;
            this.pattern = this.decimalFormat.toPattern();
            this.locale = locale;
        } else {
            ResourceBundle patterns = ResourceBundle.getBundle("org.pentaho.reporting.libraries.formatting.format-patterns");
            switch (type) {
                case 1: {
                    this.pattern = patterns.getString("format.integer");
                    break;
                }
                case 3: {
                    this.pattern = patterns.getString("format.percentage");
                    break;
                }
                case 2: {
                    this.pattern = patterns.getString("format.currency");
                    break;
                }
                default: {
                    this.pattern = patterns.getString("format.number");
                }
            }
            this.locale = locale;
            this.decimalFormat = new DecimalFormat(this.pattern, new DecimalFormatSymbols(locale));
        }
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.locale.equals(locale)) {
            return;
        }
        this.locale = locale;
        this.decimalFormat = (DecimalFormat)this.decimalFormat.clone();
        this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String format(Object parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (!(parameters instanceof Number)) {
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        return this.decimalFormat.format(parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastDecimalFormat that = (FastDecimalFormat)o;
        if (!this.locale.equals(that.locale)) {
            return false;
        }
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        int result = this.locale.hashCode();
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void applyPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.decimalFormat = (DecimalFormat)this.decimalFormat.clone();
        this.decimalFormat.applyPattern(pattern);
    }
}

