/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.io.WritableComparable;

public class HServerInfo
implements WritableComparable<HServerInfo> {
    private static final String SERVERNAME_SEPARATOR = ",";
    private HServerAddress serverAddress;
    private long startCode;
    private HServerLoad load;
    private int infoPort;
    private String serverName = null;
    private String hostname;
    private String cachedHostnamePort = null;

    public HServerInfo() {
        this(new HServerAddress(), 0L, 60030, "default name");
    }

    public HServerInfo(HServerAddress serverAddress, int infoPort, String hostname) {
        this(serverAddress, System.currentTimeMillis(), infoPort, hostname);
    }

    public HServerInfo(HServerAddress serverAddress, long startCode, int infoPort, String hostname) {
        this.serverAddress = serverAddress;
        this.startCode = startCode;
        this.load = new HServerLoad();
        this.infoPort = infoPort;
        this.hostname = hostname;
    }

    public HServerInfo(HServerInfo other) {
        this.serverAddress = new HServerAddress(other.getServerAddress());
        this.startCode = other.getStartCode();
        this.load = other.getLoad();
        this.infoPort = other.getInfoPort();
        this.hostname = other.hostname;
    }

    public HServerLoad getLoad() {
        return this.load;
    }

    public void setLoad(HServerLoad load) {
        this.load = load;
    }

    public synchronized HServerAddress getServerAddress() {
        return new HServerAddress(this.serverAddress);
    }

    public synchronized void setServerAddress(HServerAddress serverAddress) {
        this.serverAddress = serverAddress;
        this.hostname = serverAddress.getHostname();
        this.serverName = null;
    }

    public synchronized long getStartCode() {
        return this.startCode;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public String getHostname() {
        return this.hostname;
    }

    public synchronized String getHostnamePort() {
        if (this.cachedHostnamePort == null) {
            this.cachedHostnamePort = HServerInfo.getHostnamePort(this.hostname, this.serverAddress.getPort());
        }
        return this.cachedHostnamePort;
    }

    public static String getHostnamePort(String hostname, int port) {
        return hostname + ":" + port;
    }

    public synchronized String getServerName() {
        if (this.serverName == null) {
            this.serverName = HServerInfo.getServerName(this.hostname, this.serverAddress.getPort(), this.startCode);
        }
        return this.serverName;
    }

    public static synchronized String getServerName(String hostAndPort, long startcode) {
        int index = hostAndPort.indexOf(":");
        if (index <= 0) {
            throw new IllegalArgumentException("Expected <hostname> ':' <port>");
        }
        return HServerInfo.getServerName(hostAndPort.substring(0, index), Integer.parseInt(hostAndPort.substring(index + 1)), startcode);
    }

    public static String getServerName(HServerAddress address, long startCode) {
        return HServerInfo.getServerName(address.getHostname(), address.getPort(), startCode);
    }

    public static String getServerName(String hostName, int port, long startCode) {
        StringBuilder name = new StringBuilder(hostName);
        name.append(SERVERNAME_SEPARATOR);
        name.append(port);
        name.append(SERVERNAME_SEPARATOR);
        name.append(startCode);
        return name.toString();
    }

    public String toString() {
        return "serverName=" + this.getServerName() + ", load=(" + this.load.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HServerInfo)obj) == 0;
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        this.serverAddress.readFields(in);
        this.startCode = in.readLong();
        this.load.readFields(in);
        this.infoPort = in.readInt();
        this.hostname = in.readUTF();
    }

    public void write(DataOutput out) throws IOException {
        this.serverAddress.write(out);
        out.writeLong(this.startCode);
        this.load.write(out);
        out.writeInt(this.infoPort);
        out.writeUTF(this.hostname);
    }

    public int compareTo(HServerInfo o) {
        return this.getServerName().compareTo(o.getServerName());
    }

    public static boolean isServer(Set<String> servers, String serverName, boolean hostAndPortOnly) {
        if (!hostAndPortOnly) {
            return servers.contains(serverName);
        }
        String serverNameColonReplaced = serverName.replaceFirst(":", SERVERNAME_SEPARATOR);
        for (String hostPortStartCode : servers) {
            int index;
            String hostPortStrippedOfStartCode = hostPortStartCode.substring(0, index = hostPortStartCode.lastIndexOf(SERVERNAME_SEPARATOR));
            if (!hostPortStrippedOfStartCode.equals(serverNameColonReplaced)) continue;
            return true;
        }
        return false;
    }

    public static String getServerNameLessStartCode(String inServerName) {
        int index;
        if (inServerName != null && inServerName.length() > 0 && (index = inServerName.lastIndexOf(SERVERNAME_SEPARATOR)) > 0) {
            return inServerName.substring(0, index);
        }
        return inServerName;
    }

    public static class LoadComparator
    implements Comparator<HServerInfo> {
        @Override
        public int compare(HServerInfo left, HServerInfo right) {
            int loadCompare = left.getLoad().compareTo(right.getLoad());
            return loadCompare != 0 ? loadCompare : left.compareTo(right);
        }
    }
}

