/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationZookeeper {
    private static final Log LOG = LogFactory.getLog(ReplicationZookeeper.class);
    private static final String RS_LOCK_ZNODE = "lock";
    private final ZooKeeperWatcher zookeeper;
    private Map<String, ReplicationPeer> peerClusters;
    private String replicationZNode;
    private String peersZNode;
    private String rsZNode;
    private String rsServerNameZnode;
    private String replicationStateNodeName;
    private final Configuration conf;
    private AtomicBoolean replicating;
    private String clusterId;
    private String ourClusterKey;
    private Abortable abortable;
    private ReplicationStatusTracker statusTracker;

    public ReplicationZookeeper(Abortable abortable, Configuration conf, ZooKeeperWatcher zk) throws KeeperException {
        this.conf = conf;
        this.zookeeper = zk;
        this.replicating = new AtomicBoolean();
        this.setZNodes(abortable);
    }

    public ReplicationZookeeper(Server server, AtomicBoolean replicating) throws IOException, KeeperException {
        this.abortable = server;
        this.zookeeper = server.getZooKeeper();
        this.conf = server.getConfiguration();
        this.replicating = replicating;
        this.setZNodes(server);
        this.peerClusters = new HashMap<String, ReplicationPeer>();
        ZKUtil.createWithParents(this.zookeeper, ZKUtil.joinZNode(this.replicationZNode, this.replicationStateNodeName));
        this.rsServerNameZnode = ZKUtil.joinZNode(this.rsZNode, server.getServerName());
        ZKUtil.createWithParents(this.zookeeper, this.rsServerNameZnode);
        this.connectExistingPeers();
    }

    private void setZNodes(Abortable abortable) throws KeeperException {
        String replicationZNodeName = this.conf.get("zookeeper.znode.replication", "replication");
        String peersZNodeName = this.conf.get("zookeeper.znode.replication.peers", "peers");
        String repMasterZNodeName = this.conf.get("zookeeper.znode.replication.master", "master");
        this.replicationStateNodeName = this.conf.get("zookeeper.znode.replication.state", "state");
        String clusterIdZNodeName = this.conf.get("zookeeper.znode.replication.clusterId", "clusterId");
        String rsZNodeName = this.conf.get("zookeeper.znode.replication.rs", "rs");
        this.ourClusterKey = ZKUtil.getZooKeeperClusterKey(this.conf);
        this.replicationZNode = ZKUtil.joinZNode(this.zookeeper.baseZNode, replicationZNodeName);
        this.peersZNode = ZKUtil.joinZNode(this.replicationZNode, peersZNodeName);
        ZKUtil.createWithParents(this.zookeeper, this.peersZNode);
        this.rsZNode = ZKUtil.joinZNode(this.replicationZNode, rsZNodeName);
        ZKUtil.createWithParents(this.zookeeper, this.rsZNode);
        String znode = ZKUtil.joinZNode(this.replicationZNode, clusterIdZNodeName);
        byte[] data = ZKUtil.getData(this.zookeeper, znode);
        String idResult = Bytes.toString(data);
        this.clusterId = idResult == null ? Byte.toString((byte)0) : idResult;
        this.statusTracker = new ReplicationStatusTracker(this.zookeeper, abortable);
        this.statusTracker.start();
        this.readReplicationStateZnode();
    }

    private void connectExistingPeers() throws IOException, KeeperException {
        List<String> znodes = ZKUtil.listChildrenNoWatch(this.zookeeper, this.peersZNode);
        if (znodes != null) {
            for (String z : znodes) {
                this.connectToPeer(z);
            }
        }
    }

    public List<String> listPeersIdsAndWatch() {
        List<String> ids = null;
        try {
            ids = ZKUtil.listChildrenAndWatchThem(this.zookeeper, this.peersZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Cannot get the list of peers ", e);
        }
        return ids;
    }

    public List<HServerAddress> getSlavesAddresses(String peerClusterId) throws KeeperException {
        if (this.peerClusters.size() == 0) {
            return new ArrayList<HServerAddress>(0);
        }
        ReplicationPeer peer = this.peerClusters.get(peerClusterId);
        if (peer == null) {
            return new ArrayList<HServerAddress>(0);
        }
        peer.setRegionServers(this.fetchSlavesAddresses(peer.getZkw()));
        return peer.getRegionServers();
    }

    private List<HServerAddress> fetchSlavesAddresses(ZooKeeperWatcher zkw) {
        List<HServerAddress> rss = null;
        try {
            rss = ZKUtil.listChildrenAndGetAsAddresses(zkw, zkw.rsZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Cannot get peer's region server addresses", (Throwable)e);
        }
        return rss;
    }

    public boolean connectToPeer(String peerId) throws IOException, KeeperException {
        if (this.peerClusters == null) {
            return false;
        }
        if (this.peerClusters.containsKey(peerId)) {
            return false;
        }
        if (this.peerClusters.size() > 0) {
            LOG.warn((Object)"Multiple slaves feature not supported");
            return false;
        }
        ReplicationPeer peer = this.getPeer(peerId);
        if (peer == null) {
            return false;
        }
        this.peerClusters.put(peerId, peer);
        ZKUtil.createWithParents(this.zookeeper, ZKUtil.joinZNode(this.rsServerNameZnode, peerId));
        LOG.info((Object)("Added new peer cluster " + peer.getClusterKey()));
        return true;
    }

    public ReplicationPeer getPeer(String peerId) throws IOException, KeeperException {
        String znode = ZKUtil.joinZNode(this.peersZNode, peerId);
        byte[] data = ZKUtil.getData(this.zookeeper, znode);
        String otherClusterKey = Bytes.toString(data);
        if (this.ourClusterKey.equals(otherClusterKey)) {
            LOG.debug((Object)("Not connecting to " + peerId + " because it's us"));
            return null;
        }
        Configuration otherConf = new Configuration(this.conf);
        try {
            ZKUtil.applyClusterKeyToConf(otherConf, otherClusterKey);
        }
        catch (IOException e) {
            LOG.error((Object)"Can't get peer because:", (Throwable)e);
            return null;
        }
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(otherConf, "connection to cluster: " + peerId, this.abortable);
        return new ReplicationPeer(otherConf, peerId, otherClusterKey, zkw);
    }

    public void setReplicating(boolean newState) throws KeeperException {
        ZKUtil.createWithParents(this.zookeeper, ZKUtil.joinZNode(this.replicationZNode, this.replicationStateNodeName));
        ZKUtil.setData(this.zookeeper, ZKUtil.joinZNode(this.replicationZNode, this.replicationStateNodeName), Bytes.toBytes(Boolean.toString(newState)));
    }

    public void removePeer(String id) throws IOException {
        try {
            if (!this.peerExists(id)) {
                throw new IllegalArgumentException("Cannot remove inexisting peer");
            }
            ZKUtil.deleteNode(this.zookeeper, ZKUtil.joinZNode(this.peersZNode, id));
        }
        catch (KeeperException e) {
            throw new IOException("Unable to remove a peer", e);
        }
    }

    public void addPeer(String id, String clusterKey) throws IOException {
        try {
            if (this.peerExists(id)) {
                throw new IllegalArgumentException("Cannot add existing peer");
            }
            if (this.countPeers() > 0) {
                throw new IllegalStateException("Multi-slave isn't supported yet");
            }
            ZKUtil.createWithParents(this.zookeeper, this.peersZNode);
            ZKUtil.createAndWatch(this.zookeeper, ZKUtil.joinZNode(this.peersZNode, id), Bytes.toBytes(clusterKey));
        }
        catch (KeeperException e) {
            throw new IOException("Unable to add peer", e);
        }
    }

    private boolean peerExists(String id) throws KeeperException {
        return ZKUtil.checkExists(this.zookeeper, ZKUtil.joinZNode(this.peersZNode, id)) >= 0;
    }

    private int countPeers() throws KeeperException {
        List<String> peers = ZKUtil.listChildrenNoWatch(this.zookeeper, this.peersZNode);
        return peers == null ? 0 : peers.size();
    }

    private void readReplicationStateZnode() {
        try {
            this.replicating.set(this.getReplication());
            LOG.info((Object)("Replication is now " + (this.replicating.get() ? "started" : "stopped")));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed getting data on from " + this.getRepStateNode(), e);
        }
    }

    public boolean getReplication() throws KeeperException {
        byte[] data = this.statusTracker.getData();
        if (data == null || data.length == 0) {
            this.setReplicating(true);
            return true;
        }
        return Boolean.parseBoolean(Bytes.toString(data));
    }

    private String getRepStateNode() {
        return ZKUtil.joinZNode(this.replicationZNode, this.replicationStateNodeName);
    }

    public void addLogToList(String filename, String clusterId) {
        try {
            String znode = ZKUtil.joinZNode(this.rsServerNameZnode, clusterId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.createWithParents(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed add log to list", e);
        }
    }

    public void removeLogFromList(String filename, String clusterId) {
        try {
            String znode = ZKUtil.joinZNode(this.rsServerNameZnode, clusterId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.deleteNode(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed remove from list", e);
        }
    }

    public void writeReplicationStatus(String filename, String clusterId, long position) {
        try {
            String znode = ZKUtil.joinZNode(this.rsServerNameZnode, clusterId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.setData(this.zookeeper, znode, Bytes.toBytes(Long.toString(position)));
        }
        catch (KeeperException e) {
            this.abortable.abort("Writing replication status", e);
        }
    }

    public List<String> getRegisteredRegionServers() {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenAndWatchThem(this.zookeeper, this.zookeeper.rsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of registered region servers", e);
        }
        return result;
    }

    public List<String> getListOfReplicators() {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, this.rsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of replicators", e);
        }
        return result;
    }

    public List<String> getListPeersForRS(String rs) {
        String znode = ZKUtil.joinZNode(this.rsZNode, rs);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of peers for rs", e);
        }
        return result;
    }

    public List<String> getListHLogsForPeerForRS(String rs, String id) {
        String znode = ZKUtil.joinZNode(this.rsZNode, rs);
        znode = ZKUtil.joinZNode(znode, id);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of hlogs for peer", e);
        }
        return result;
    }

    public boolean lockOtherRS(String znode) {
        try {
            String parent = ZKUtil.joinZNode(this.rsZNode, znode);
            if (parent.equals(this.rsServerNameZnode)) {
                LOG.warn((Object)"Won't lock because this is us, we're dead!");
                return false;
            }
            String p = ZKUtil.joinZNode(parent, RS_LOCK_ZNODE);
            ZKUtil.createAndWatch(this.zookeeper, p, Bytes.toBytes(this.rsServerNameZnode));
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NodeExistsException) {
                LOG.info((Object)("Won't transfer the queue, another RS took care of it because of: " + e.getMessage()));
            } else {
                LOG.info((Object)"Failed lock other rs", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public SortedMap<String, SortedSet<String>> copyQueuesFromRS(String znode) {
        TreeMap<String, SortedSet<String>> queues = new TreeMap<String, SortedSet<String>>();
        try {
            String nodePath = ZKUtil.joinZNode(this.rsZNode, znode);
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, nodePath);
            if (clusters == null || clusters.size() <= 1) {
                return queues;
            }
            clusters.remove(RS_LOCK_ZNODE);
            for (String cluster : clusters) {
                String newCluster = cluster + "-" + znode;
                String newClusterZnode = ZKUtil.joinZNode(this.rsServerNameZnode, newCluster);
                ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, newClusterZnode, HConstants.EMPTY_BYTE_ARRAY);
                String clusterPath = ZKUtil.joinZNode(nodePath, cluster);
                List<String> hlogs = ZKUtil.listChildrenNoWatch(this.zookeeper, clusterPath);
                if (hlogs == null || hlogs.size() == 0) continue;
                TreeSet<String> logQueue = new TreeSet<String>();
                queues.put(newCluster, logQueue);
                for (String hlog : hlogs) {
                    String z = ZKUtil.joinZNode(clusterPath, hlog);
                    byte[] position = ZKUtil.getData(this.zookeeper, z);
                    LOG.debug((Object)("Creating " + hlog + " with data " + Bytes.toString(position)));
                    String child = ZKUtil.joinZNode(newClusterZnode, hlog);
                    ZKUtil.createAndWatch(this.zookeeper, child, position);
                    logQueue.add(hlog);
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Copy queues from rs", e);
        }
        return queues;
    }

    public void deleteSource(String peerZnode, boolean closeConnection) {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, ZKUtil.joinZNode(this.rsServerNameZnode, peerZnode));
            if (closeConnection) {
                this.peerClusters.get(peerZnode).getZkw().close();
                this.peerClusters.remove(peerZnode);
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed delete of " + peerZnode, e);
        }
    }

    public void deleteRsQueues(String znode) {
        String fullpath = ZKUtil.joinZNode(this.rsZNode, znode);
        try {
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, fullpath);
            for (String cluster : clusters) {
                if (cluster.equals(RS_LOCK_ZNODE)) continue;
                String fullClusterPath = ZKUtil.joinZNode(fullpath, cluster);
                ZKUtil.deleteNodeRecursively(this.zookeeper, fullClusterPath);
            }
            ZKUtil.deleteNodeRecursively(this.zookeeper, fullpath);
        }
        catch (KeeperException e) {
            if ((e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NotEmptyException) && e.getPath().equals(fullpath)) {
                return;
            }
            this.abortable.abort("Failed delete of " + znode, e);
        }
    }

    public void deleteOwnRSZNode() {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.rsServerNameZnode);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.SessionExpiredException) {
                return;
            }
            this.abortable.abort("Failed delete of " + this.rsServerNameZnode, e);
        }
    }

    public long getHLogRepPosition(String peerId, String hlog) throws KeeperException {
        String clusterZnode = ZKUtil.joinZNode(this.rsServerNameZnode, peerId);
        String znode = ZKUtil.joinZNode(clusterZnode, hlog);
        String data = Bytes.toString(ZKUtil.getData(this.zookeeper, znode));
        return data == null || data.length() == 0 ? 0L : Long.parseLong(data);
    }

    public void registerRegionServerListener(ZooKeeperListener listener) {
        this.zookeeper.registerListener(listener);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Map<String, ReplicationPeer> getPeerClusters() {
        return this.peerClusters;
    }

    public static String getZNodeName(String fullPath) {
        String[] parts = fullPath.split("/");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    public ZooKeeperWatcher getZookeeperWatcher() {
        return this.zookeeper;
    }

    public String getPeersZNode() {
        return this.peersZNode;
    }

    public class ReplicationStatusTracker
    extends ZooKeeperNodeTracker {
        public ReplicationStatusTracker(ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, ReplicationZookeeper.this.getRepStateNode(), abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                ReplicationZookeeper.this.readReplicationStateZnode();
            }
        }
    }
}

