/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

public class ReplicationSource
extends Thread
implements ReplicationSourceInterface {
    private static final Log LOG = LogFactory.getLog(ReplicationSource.class);
    private PriorityBlockingQueue<Path> queue;
    private HLog.Entry[] entriesArray;
    private HConnection conn;
    private ReplicationZookeeper zkHelper;
    private Configuration conf;
    private float ratio;
    private Random random;
    private AtomicBoolean replicating;
    private String peerClusterId;
    private ReplicationSourceManager manager;
    private Stoppable stopper;
    private List<HServerAddress> currentPeers;
    private long sleepForRetries;
    private long replicationQueueSizeCapacity;
    private int replicationQueueNbCapacity;
    private HLog.Reader reader;
    private long position = 0L;
    private volatile Path currentPath;
    private FileSystem fs;
    private byte clusterId;
    private long totalReplicatedEdits = 0L;
    private String peerClusterZnode;
    private boolean queueRecovered;
    private String[] deadRegionServers;
    private long maxRetriesMultiplier;
    private int currentNbEntries = 0;
    private int currentNbOperations = 0;
    private volatile boolean running = true;
    private ReplicationSourceMetrics metrics;
    private AtomicBoolean sourceEnabled = new AtomicBoolean();

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, Stoppable stopper, AtomicBoolean replicating, String peerClusterZnode) throws IOException {
        this.stopper = stopper;
        this.conf = conf;
        this.replicationQueueSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationQueueNbCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        this.entriesArray = new HLog.Entry[this.replicationQueueNbCapacity];
        for (int i = 0; i < this.replicationQueueNbCapacity; ++i) {
            this.entriesArray[i] = new HLog.Entry();
        }
        this.maxRetriesMultiplier = this.conf.getLong("replication.source.maxretriesmultiplier", 10L);
        this.queue = new PriorityBlockingQueue<Path>(conf.getInt("hbase.regionserver.maxlogs", 32), new LogsComparator());
        this.conn = HConnectionManager.getConnection(conf);
        this.zkHelper = manager.getRepZkWrapper();
        this.ratio = this.conf.getFloat("replication.source.ratio", 0.1f);
        this.currentPeers = new ArrayList<HServerAddress>();
        this.random = new Random();
        this.replicating = replicating;
        this.manager = manager;
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.fs = fs;
        this.clusterId = Byte.valueOf(this.zkHelper.getClusterId());
        this.metrics = new ReplicationSourceMetrics(peerClusterZnode);
        this.checkIfQueueRecovered(peerClusterZnode);
    }

    private void checkIfQueueRecovered(String peerClusterZnode) {
        String[] parts = peerClusterZnode.split("-");
        this.queueRecovered = parts.length != 1;
        this.peerClusterId = this.queueRecovered ? parts[0] : peerClusterZnode;
        this.peerClusterZnode = peerClusterZnode;
        this.deadRegionServers = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            this.deadRegionServers[i - 1] = parts[i];
        }
    }

    private void chooseSinks() throws KeeperException {
        this.currentPeers.clear();
        List<HServerAddress> addresses = this.zkHelper.getSlavesAddresses(this.peerClusterId);
        HashSet<HServerAddress> setOfAddr = new HashSet<HServerAddress>();
        int nbPeers = (int)Math.ceil((float)addresses.size() * this.ratio);
        LOG.info((Object)("Getting " + nbPeers + " rs from peer cluster # " + this.peerClusterId));
        for (int i = 0; i < nbPeers; ++i) {
            HServerAddress address;
            while (setOfAddr.contains(address = addresses.get(this.random.nextInt(addresses.size())))) {
            }
            LOG.info((Object)("Choosing peer " + address));
            setOfAddr.add(address);
        }
        this.currentPeers.addAll(setOfAddr);
    }

    @Override
    public void enqueueLog(Path log) {
        this.queue.put(log);
        this.metrics.sizeOfLogQueue.set(this.queue.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.connectToPeers();
        if (this.stopper.isStopped()) {
            return;
        }
        if (this.queueRecovered) {
            try {
                this.position = this.zkHelper.getHLogRepPosition(this.peerClusterZnode, this.queue.peek().getName());
            }
            catch (KeeperException e) {
                this.terminate("Couldn't get the position of this recovered queue " + this.peerClusterZnode, (Exception)((Object)e));
            }
        }
        int sleepMultiplier = 1;
        while (!this.stopper.isStopped() && this.running) {
            boolean gotIOE;
            block34: {
                if (!this.replicating.get() || !this.sourceEnabled.get()) {
                    if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                if (!this.getNextPath()) {
                    if (!this.sleepForRetries("No log to process", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                if (!this.openReader(sleepMultiplier)) {
                    sleepMultiplier = 1;
                    continue;
                }
                if (this.reader == null) {
                    if (!this.sleepForRetries("Unable to open a reader", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                gotIOE = false;
                this.currentNbEntries = 0;
                try {
                    if (this.readAllEntriesToReplicateOrNextFile()) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                    gotIOE = true;
                    if (!(ioe.getCause() instanceof EOFException)) break block34;
                    boolean considerDumping = false;
                    if (this.queueRecovered) {
                        try {
                            FileStatus stat = this.fs.getFileStatus(this.currentPath);
                            if (stat.getLen() == 0L) {
                                LOG.warn((Object)(this.peerClusterZnode + " Got EOF and the file was empty"));
                            }
                            considerDumping = true;
                        }
                        catch (IOException e) {
                            LOG.warn((Object)(this.peerClusterZnode + " Got while getting file size: "), (Throwable)e);
                        }
                    } else if (this.currentNbEntries != 0) {
                        LOG.warn((Object)(this.peerClusterZnode + " Got EOF while reading, " + "looks like this file is broken? " + this.currentPath));
                        considerDumping = true;
                        this.currentNbEntries = 0;
                    }
                    if (considerDumping && (long)sleepMultiplier == this.maxRetriesMultiplier && this.processEndOfFile()) {
                        continue;
                    }
                }
                finally {
                    try {
                        if (this.currentPath != null && !gotIOE) {
                            this.position = this.reader.getPosition();
                        }
                        if (this.reader == null) continue;
                        this.reader.close();
                    }
                    catch (IOException e) {
                        gotIOE = true;
                        LOG.warn((Object)"Unable to finalize the tailing of a file", (Throwable)e);
                    }
                    continue;
                }
            }
            if (!this.stopper.isStopped() && (gotIOE || this.currentNbEntries == 0)) {
                this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.position, this.queueRecovered);
                if (!this.sleepForRetries("Nothing to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            sleepMultiplier = 1;
            this.shipEdits();
        }
        LOG.debug((Object)("Source exiting " + this.peerClusterId));
    }

    protected boolean readAllEntriesToReplicateOrNextFile() throws IOException {
        long seenEntries = 0L;
        if (this.position != 0L) {
            this.reader.seek(this.position);
        }
        HLog.Entry entry = this.reader.next(this.entriesArray[this.currentNbEntries]);
        while (entry != null) {
            WALEdit edit = entry.getEdit();
            this.metrics.logEditsReadRate.inc(1);
            ++seenEntries;
            this.removeNonReplicableEdits(edit);
            HLogKey logKey = entry.getKey();
            if (!Bytes.equals(logKey.getTablename(), HConstants.ROOT_TABLE_NAME) && !Bytes.equals(logKey.getTablename(), HConstants.META_TABLE_NAME) && edit.size() != 0 && this.replicating.get()) {
                logKey.setClusterId(this.clusterId);
                this.currentNbOperations += this.countDistinctRowKeys(edit);
                ++this.currentNbEntries;
            } else {
                this.metrics.logEditsFilteredRate.inc(1);
            }
            if (this.reader.getPosition() - this.position >= this.replicationQueueSizeCapacity || this.currentNbEntries >= this.replicationQueueNbCapacity) break;
            entry = this.reader.next(this.entriesArray[this.currentNbEntries]);
        }
        LOG.debug((Object)("currentNbOperations:" + this.currentNbOperations + " and seenEntries:" + seenEntries + " and size: " + (this.reader.getPosition() - this.position)));
        return seenEntries == 0L && this.processEndOfFile();
    }

    private void connectToPeers() {
        while (!this.stopper.isStopped() && this.currentPeers.size() == 0) {
            try {
                this.chooseSinks();
                Thread.sleep(this.sleepForRetries);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted while trying to connect to sinks", (Throwable)e);
            }
            catch (KeeperException e) {
                LOG.error((Object)"Error talking to zookeeper, retrying", (Throwable)e);
            }
        }
    }

    protected boolean getNextPath() {
        try {
            if (this.currentPath == null) {
                this.currentPath = this.queue.poll(this.sleepForRetries, TimeUnit.MILLISECONDS);
                this.metrics.sizeOfLogQueue.set(this.queue.size());
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while reading edits", (Throwable)e);
        }
        return this.currentPath != null;
    }

    protected boolean openReader(int sleepMultiplier) {
        block7: {
            try {
                LOG.debug((Object)("Opening log for replication " + this.currentPath.getName() + " at " + this.position));
                try {
                    this.reader = null;
                    this.reader = HLog.getReader(this.fs, this.currentPath, this.conf);
                }
                catch (FileNotFoundException fnfe) {
                    if (this.queueRecovered) {
                        LOG.info((Object)("NB dead servers : " + this.deadRegionServers.length));
                        for (int i = this.deadRegionServers.length - 1; i >= 0; --i) {
                            Path deadRsDirectory = new Path(this.manager.getLogDir().getParent(), this.deadRegionServers[i]);
                            Path possibleLogLocation = new Path(deadRsDirectory, this.currentPath.getName());
                            LOG.info((Object)("Possible location " + possibleLogLocation.toUri().toString()));
                            if (!this.manager.getFs().exists(possibleLogLocation)) continue;
                            LOG.info((Object)("Log " + this.currentPath + " still exists at " + possibleLogLocation));
                            return true;
                        }
                        throw new IOException("File from recovered queue is nowhere to be found", fnfe);
                    }
                    Path archivedLogLocation = new Path(this.manager.getOldLogDir(), this.currentPath.getName());
                    if (this.manager.getFs().exists(archivedLogLocation)) {
                        this.currentPath = archivedLogLocation;
                        LOG.info((Object)("Log " + this.currentPath + " was moved to " + archivedLogLocation));
                        this.openReader(sleepMultiplier);
                    }
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                if ((long)sleepMultiplier != this.maxRetriesMultiplier) break block7;
                LOG.warn((Object)"Waited too long for this file, considering dumping");
                return !this.processEndOfFile();
            }
        }
        return true;
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            LOG.debug((Object)(msg + ", sleeping " + this.sleepForRetries + " times " + sleepMultiplier));
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping between retries");
        }
        return (long)sleepMultiplier < this.maxRetriesMultiplier;
    }

    protected void removeNonReplicableEdits(WALEdit edit) {
        NavigableMap<byte[], Integer> scopes = edit.getScopes();
        List<KeyValue> kvs = edit.getKeyValues();
        for (int i = 0; i < edit.size(); ++i) {
            KeyValue kv = kvs.get(i);
            if (scopes != null && scopes.containsKey(kv.getFamily())) continue;
            kvs.remove(i);
            --i;
        }
    }

    private int countDistinctRowKeys(WALEdit edit) {
        List<KeyValue> kvs = edit.getKeyValues();
        int distinctRowKeys = 1;
        KeyValue lastKV = kvs.get(0);
        for (int i = 0; i < edit.size(); ++i) {
            if (kvs.get(i).matchingRow(lastKV)) continue;
            ++distinctRowKeys;
        }
        return distinctRowKeys;
    }

    protected void shipEdits() {
        int sleepMultiplier = 1;
        if (this.currentNbEntries == 0) {
            LOG.warn((Object)"Was given 0 edits to ship");
            return;
        }
        block5: while (!this.stopper.isStopped()) {
            try {
                HRegionInterface rrs = this.getRS();
                LOG.debug((Object)("Replicating " + this.currentNbEntries));
                rrs.replicateLogEntries(Arrays.copyOf(this.entriesArray, this.currentNbEntries));
                this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.position, this.queueRecovered);
                this.totalReplicatedEdits += (long)this.currentNbEntries;
                this.metrics.shippedBatchesRate.inc(1);
                this.metrics.shippedOpsRate.inc(this.currentNbOperations);
                this.metrics.setAgeOfLastShippedOp(this.entriesArray[this.entriesArray.length - 1].getKey().getWriteTime());
                LOG.debug((Object)("Replicated in total: " + this.totalReplicatedEdits));
                break;
            }
            catch (IOException ioe) {
                this.metrics.refreshAgeOfLastShippedOp();
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)((Object)ioe)).unwrapRemoteException();
                    LOG.warn((Object)"Can't replicate because of an error on the remote cluster: ", (Throwable)ioe);
                } else {
                    LOG.warn((Object)"Can't replicate because of a local or network error: ", (Throwable)ioe);
                }
                try {
                    boolean down;
                    do {
                        if (down = this.isSlaveDown()) {
                            if (this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) {
                                ++sleepMultiplier;
                            } else {
                                this.chooseSinks();
                            }
                        }
                        if (this.stopper.isStopped()) continue block5;
                    } while (down);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Interrupted while trying to contact the peer cluster");
                }
                catch (KeeperException e) {
                    LOG.error((Object)"Error talking to zookeeper, retrying", (Throwable)e);
                }
            }
        }
    }

    protected boolean processEndOfFile() {
        if (this.queue.size() != 0) {
            this.currentPath = null;
            this.position = 0L;
            return true;
        }
        if (this.queueRecovered) {
            this.manager.closeRecoveredQueue(this);
            LOG.info((Object)"Finished recovering the queue");
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public void startup() {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ReplicationSource.this.terminate("Uncaught exception during runtime", new Exception(e));
            }
        };
        Threads.setDaemonThreadRunning(this, n + ".replicationSource," + this.peerClusterZnode, handler);
    }

    @Override
    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    @Override
    public void terminate(String reason, Exception cause) {
        if (cause == null) {
            LOG.info((Object)("Closing source " + this.peerClusterZnode + " because: " + reason));
        } else {
            LOG.error((Object)("Closing source " + this.peerClusterZnode + " because an error occurred: " + reason), (Throwable)cause);
        }
        this.running = false;
        Threads.shutdown(this, this.sleepForRetries);
    }

    private HRegionInterface getRS() throws IOException {
        if (this.currentPeers.size() == 0) {
            throw new IOException(this.peerClusterZnode + " has 0 region servers");
        }
        HServerAddress address = this.currentPeers.get(this.random.nextInt(this.currentPeers.size()));
        return this.conn.getHRegionConnection(address);
    }

    public boolean isSlaveDown() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread pingThread = new Thread(){

            @Override
            public void run() {
                try {
                    HRegionInterface rrs = ReplicationSource.this.getRS();
                    rrs.getHServerInfo();
                    latch.countDown();
                }
                catch (IOException ex) {
                    if (ex instanceof RemoteException) {
                        ex = ((RemoteException)((Object)ex)).unwrapRemoteException();
                    }
                    LOG.info((Object)("Slave cluster looks down: " + ex.getMessage()));
                }
            }
        };
        pingThread.start();
        boolean down = !latch.await(this.sleepForRetries, TimeUnit.MILLISECONDS);
        pingThread.interrupt();
        return down;
    }

    @Override
    public String getPeerClusterZnode() {
        return this.peerClusterZnode;
    }

    @Override
    public String getPeerClusterId() {
        return this.peerClusterId;
    }

    @Override
    public Path getCurrentPath() {
        return this.currentPath;
    }

    @Override
    public void setSourceEnabled(boolean status) {
        this.sourceEnabled.set(status);
    }

    public static class LogsComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.valueOf(this.getTS(o1)).compareTo(this.getTS(o2));
        }

        @Override
        public boolean equals(Object o) {
            return true;
        }

        private long getTS(Path p) {
            String[] parts = p.getName().split("\\.");
            return Long.parseLong(parts[parts.length - 1]);
        }
    }
}

