/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.dialect.MSSQLServerDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class MSSQLServerNativeDatabaseDialect
extends MSSQLServerDatabaseDialect {
    public static final String ATTRIBUTE_USE_INTEGRATED_SECURITY = "MSSQLUseIntegratedSecurity";
    private static final IDatabaseType DBTYPE = new DatabaseType("MS SQL Server (Native)", "MSSQLNative", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.ODBC, DatabaseAccessType.JNDI), 1433, "http://msdn.microsoft.com/en-us/library/ms378428.aspx");

    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    public String getNativeDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getNativeJdbcPre() {
        return "jdbc:sqlserver://";
    }

    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        if (connection.getAccessType() == DatabaseAccessType.ODBC) {
            return "jdbc:odbc:" + connection.getDatabaseName();
        }
        String useIntegratedSecurity = "false";
        String value = connection.getAttributes().get(ATTRIBUTE_USE_INTEGRATED_SECURITY);
        if (value != null && value instanceof String) {
            useIntegratedSecurity = value;
            try {
                Boolean.parseBoolean(useIntegratedSecurity);
            }
            catch (IllegalArgumentException e) {
                useIntegratedSecurity = "false";
            }
        }
        return this.getNativeJdbcPre() + connection.getHostname() + ":" + connection.getDatabasePort() + ";databaseName=" + connection.getDatabaseName() + ";integratedSecurity=" + useIntegratedSecurity;
    }

    public IDatabaseConnection createNativeConnection(String jdbcUrl) {
        if (!jdbcUrl.startsWith(this.getNativeJdbcPre())) {
            throw new RuntimeException("JDBC URL " + jdbcUrl + " does not start with " + this.getNativeJdbcPre());
        }
        DatabaseConnection dbconn = new DatabaseConnection();
        dbconn.setDatabaseType(this.getDatabaseType());
        dbconn.setAccessType(DatabaseAccessType.NATIVE);
        String str = jdbcUrl.substring(this.getNativeJdbcPre().length());
        String hostname = null;
        String port = null;
        String databaseNameAndParams = null;
        if (str.indexOf(":") >= 0) {
            hostname = str.substring(0, str.indexOf(":"));
            if ((str = str.substring(str.indexOf(":") + 1)).indexOf(this.getExtraOptionIndicator()) >= 0) {
                port = str.substring(0, str.indexOf(";"));
                databaseNameAndParams = str.substring(str.indexOf(this.getExtraOptionIndicator()) + 1);
            } else {
                port = str;
            }
        } else if (str.indexOf(this.getExtraOptionIndicator()) >= 0) {
            hostname = str.substring(0, str.indexOf(this.getExtraOptionIndicator()));
            databaseNameAndParams = str.substring(str.indexOf(this.getExtraOptionIndicator()) + 1);
        } else {
            hostname = str;
        }
        if (hostname != null) {
            dbconn.setHostname(hostname);
        }
        if (port != null) {
            dbconn.setDatabasePort(port);
        }
        if (databaseNameAndParams != null) {
            this.setDatabaseNameAndParams(dbconn, databaseNameAndParams);
        }
        return dbconn;
    }

    protected void setDatabaseNameAndParams(DatabaseConnection dbconn, String databaseNameAndParams) {
        String[] paramData;
        for (String param : paramData = databaseNameAndParams.split(this.getExtraOptionSeparator())) {
            String[] nameAndValue = param.split(this.getExtraOptionValueSeparator());
            if (nameAndValue[0] == null || nameAndValue[0].trim().length() <= 0) continue;
            if (nameAndValue.length == 1) {
                if (nameAndValue[0].equals("databaseName")) {
                    dbconn.setDatabaseName("");
                    continue;
                }
                if (nameAndValue[0].equals("integratedSecurity")) {
                    dbconn.getAttributes().put(ATTRIBUTE_USE_INTEGRATED_SECURITY, "false");
                    continue;
                }
                dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], "");
                continue;
            }
            if (nameAndValue[0].equals("databaseName")) {
                dbconn.setDatabaseName(nameAndValue[1]);
                continue;
            }
            if (nameAndValue[0].equals("integratedSecurity")) {
                dbconn.getAttributes().put(ATTRIBUTE_USE_INTEGRATED_SECURITY, nameAndValue[1]);
                continue;
            }
            dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], nameAndValue[1]);
        }
    }

    public String[] getUsedLibraries() {
        return new String[]{"sqljdbc.jar"};
    }
}

