/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.tools.GetGroupsBase;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class GetGroups
extends GetGroupsBase {
    private static final Log LOG = LogFactory.getLog(GetGroups.class);

    public GetGroups(Configuration conf) {
        super(conf);
    }

    public GetGroups(Configuration conf, PrintStream out) {
        super(conf, out);
    }

    protected InetSocketAddress getProtocolAddress(Configuration conf) throws IOException {
        return NameNode.getAddress(conf);
    }

    public void setConf(Configuration conf) {
        conf = new HdfsConfiguration(conf);
        String nameNodePrincipal = conf.get("dfs.namenode.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using NN principal: " + nameNodePrincipal));
        }
        conf.set("hadoop.security.service.user.name.key", nameNodePrincipal);
        super.setConf(conf);
    }

    protected GetUserMappingsProtocol getUgmProtocol() throws IOException {
        return NameNodeProxies.createProxy(this.getConf(), FileSystem.getDefaultUri((Configuration)this.getConf()), GetUserMappingsProtocol.class).getProxy();
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new GetGroups(new HdfsConfiguration()), (String[])argv);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
    }
}

