/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;

public class AtomicFileOutputStream
extends FilterOutputStream {
    private static final String TMP_EXTENSION = ".tmp";
    private static final Log LOG = LogFactory.getLog(AtomicFileOutputStream.class);
    private final File origFile;
    private final File tmpFile;

    public AtomicFileOutputStream(File f) throws FileNotFoundException {
        super(new FileOutputStream(new File(f.getParentFile(), f.getName() + TMP_EXTENSION)));
        this.origFile = f.getAbsoluteFile();
        this.tmpFile = new File(f.getParentFile(), f.getName() + TMP_EXTENSION).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean triedToClose = false;
        boolean success = false;
        try {
            this.flush();
            ((FileOutputStream)this.out).getChannel().force(true);
            triedToClose = true;
            super.close();
            success = true;
        }
        finally {
            if (success) {
                boolean renamed = this.tmpFile.renameTo(this.origFile);
                if (!(renamed || this.origFile.delete() && this.tmpFile.renameTo(this.origFile))) {
                    throw new IOException("Could not rename temporary file " + this.tmpFile + " to " + this.origFile);
                }
            } else {
                if (!triedToClose) {
                    IOUtils.closeStream((Closeable)this.out);
                }
                if (!this.tmpFile.delete()) {
                    LOG.warn((Object)("Unable to delete tmp file " + this.tmpFile));
                }
            }
        }
    }
}

