/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.GUISizeInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.ObjectId;
import org.w3c.dom.Node;

public class NotePadMeta
implements Cloneable,
XMLInterface,
GUIPositionInterface,
GUISizeInterface {
    public static final String XML_TAG = "notepad";
    public static final int COLOR_RGB_BLACK_RED = 0;
    public static final int COLOR_RGB_BLACK_GREEN = 0;
    public static final int COLOR_RGB_BLACK_BLUE = 0;
    public static final int COLOR_RGB_DEFAULT_BG_RED = 255;
    public static final int COLOR_RGB_DEFAULT_BG_GREEN = 165;
    public static final int COLOR_RGB_DEFAULT_BG_BLUE = 0;
    public static final int COLOR_RGB_DEFAULT_BORDER_RED = 100;
    public static final int COLOR_RGB_DEFAULT_BORDER_GREEN = 100;
    public static final int COLOR_RGB_DEFAULT_BORDER_BLUE = 100;
    private String note;
    private String fontname;
    private int fontsize;
    private boolean fontbold;
    private boolean fontitalic;
    private int fontcolorred;
    private int fontcolorgreen;
    private int fontcolorblue;
    private int backgroundcolorred;
    private int backgroundcolorgreen;
    private int backgroundcolorblue;
    private int bordercolorred;
    private int bordercolorgreen;
    private int bordercolorblue;
    private boolean drawshadow;
    private Point location;
    public int width;
    public int height;
    private boolean selected;
    private boolean changed;
    private ObjectId id;

    public NotePadMeta() {
        this.note = null;
        this.location = new Point(-1, -1);
        this.width = -1;
        this.height = -1;
        this.selected = false;
        this.setDefaultFont();
        this.backgroundcolorred = 255;
        this.backgroundcolorgreen = 165;
        this.backgroundcolorblue = 0;
    }

    public NotePadMeta(String n, int xl, int yl, int w, int h) {
        this.note = n;
        this.location = new Point(xl, yl);
        this.width = w;
        this.height = h;
        this.selected = false;
        this.setDefaultFont();
    }

    public NotePadMeta(String n, int xl, int yl, int w, int h, String fontname, int fontsize, boolean fontbold, boolean fontitalic, int fontColorRed, int fontColorGreen, int fontColorBlue, int backGrounColorRed, int backGrounColorGreen, int backGrounColorBlue, int borderColorRed, int borderColorGreen, int borderColorBlue, boolean drawshadow) {
        this.note = n;
        this.location = new Point(xl, yl);
        this.width = w;
        this.height = h;
        this.selected = false;
        this.fontname = fontname;
        this.fontsize = fontsize;
        this.fontbold = fontbold;
        this.fontitalic = fontitalic;
        this.fontcolorred = fontColorRed;
        this.fontcolorgreen = fontColorGreen;
        this.fontcolorblue = fontColorBlue;
        this.backgroundcolorred = backGrounColorRed;
        this.backgroundcolorgreen = backGrounColorGreen;
        this.backgroundcolorblue = backGrounColorBlue;
        this.bordercolorred = borderColorRed;
        this.bordercolorgreen = borderColorGreen;
        this.bordercolorblue = borderColorBlue;
        this.drawshadow = drawshadow;
    }

    public NotePadMeta(Node notepadnode) throws KettleXMLException {
        try {
            this.note = XMLHandler.getTagValue((Node)notepadnode, (String)"note");
            String sxloc = XMLHandler.getTagValue((Node)notepadnode, (String)"xloc");
            String syloc = XMLHandler.getTagValue((Node)notepadnode, (String)"yloc");
            String swidth = XMLHandler.getTagValue((Node)notepadnode, (String)"width");
            String sheight = XMLHandler.getTagValue((Node)notepadnode, (String)"heigth");
            int x = Const.toInt((String)sxloc, (int)0);
            int y = Const.toInt((String)syloc, (int)0);
            this.location = new Point(x, y);
            this.width = Const.toInt((String)swidth, (int)0);
            this.height = Const.toInt((String)sheight, (int)0);
            this.selected = false;
            this.fontname = XMLHandler.getTagValue((Node)notepadnode, (String)"fontname");
            this.fontsize = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"fontsize"), (int)-1);
            this.fontbold = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)notepadnode, (String)"fontbold"));
            this.fontitalic = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)notepadnode, (String)"fontitalic"));
            this.fontcolorred = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"fontcolorred"), (int)0);
            this.fontcolorgreen = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"fontcolorgreen"), (int)0);
            this.fontcolorblue = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"fontcolorblue"), (int)0);
            this.backgroundcolorred = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorred"), (int)255);
            this.backgroundcolorgreen = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorgreen"), (int)165);
            this.backgroundcolorblue = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"backgroundcolorblue"), (int)0);
            this.bordercolorred = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"bordercolorred"), (int)100);
            this.bordercolorgreen = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"bordercolorgreen"), (int)100);
            this.bordercolorblue = Const.toInt((String)XMLHandler.getTagValue((Node)notepadnode, (String)"bordercolorblue"), (int)100);
            this.drawshadow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)notepadnode, (String)"drawshadow"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read Notepad info from XML", (Throwable)e);
        }
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public void setLocation(int x, int y) {
        if (x != this.location.x || y != this.location.y) {
            this.setChanged();
        }
        this.location.x = x;
        this.location.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return this.location;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setBorderColorRed(int red) {
        this.bordercolorred = red;
    }

    public void setBorderColorGreen(int green) {
        this.bordercolorgreen = green;
    }

    public void setBorderColorBlue(int blue) {
        this.bordercolorblue = blue;
    }

    public void setBackGroundColorRed(int red) {
        this.backgroundcolorred = red;
    }

    public void setBackGroundColorGreen(int green) {
        this.backgroundcolorgreen = green;
    }

    public void setBackGroundColorBlue(int blue) {
        this.backgroundcolorblue = blue;
    }

    public void setFontColorRed(int red) {
        this.fontcolorred = red;
    }

    public void setFontColorGreen(int green) {
        this.fontcolorgreen = green;
    }

    public void setFontColorBlue(int blue) {
        this.fontcolorblue = blue;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public void setDrawShadow(boolean drawshadow) {
        this.drawshadow = drawshadow;
    }

    public boolean isDrawShadow() {
        return this.drawshadow;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.note;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("    <notepad>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"note", (String)this.note));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xloc", (int)this.location.x));
        retval.append("      ").append(XMLHandler.addTagValue((String)"yloc", (int)this.location.y));
        retval.append("      ").append(XMLHandler.addTagValue((String)"width", (int)this.width));
        retval.append("      ").append(XMLHandler.addTagValue((String)"heigth", (int)this.height));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontname", (String)this.fontname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontsize", (int)this.fontsize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontbold", (boolean)this.fontbold));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontitalic", (boolean)this.fontitalic));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontcolorred", (int)this.fontcolorred));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontcolorgreen", (int)this.fontcolorgreen));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fontcolorblue", (int)this.fontcolorblue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"backgroundcolorred", (int)this.backgroundcolorred));
        retval.append("      ").append(XMLHandler.addTagValue((String)"backgroundcolorgreen", (int)this.backgroundcolorgreen));
        retval.append("      ").append(XMLHandler.addTagValue((String)"backgroundcolorblue", (int)this.backgroundcolorblue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bordercolorred", (int)this.bordercolorred));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bordercolorgreen", (int)this.bordercolorgreen));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bordercolorblue", (int)this.bordercolorblue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"drawshadow", (boolean)this.drawshadow));
        retval.append("    </notepad>").append(Const.CR);
        return retval.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getFontName() {
        return this.fontname;
    }

    public void setFontName(String fontname) {
        this.fontname = fontname;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontBold(boolean fontbold) {
        this.fontbold = fontbold;
    }

    public boolean isFontBold() {
        return this.fontbold;
    }

    public void setFontItalic(boolean fontitalic) {
        this.fontitalic = fontitalic;
    }

    public boolean isFontItalic() {
        return this.fontitalic;
    }

    public int getBorderColorRed() {
        return this.bordercolorred;
    }

    public int getBorderColorGreen() {
        return this.bordercolorgreen;
    }

    public int getBorderColorBlue() {
        return this.bordercolorblue;
    }

    public int getBackGroundColorRed() {
        return this.backgroundcolorred;
    }

    public int getBackGroundColorGreen() {
        return this.backgroundcolorgreen;
    }

    public int getBackGroundColorBlue() {
        return this.backgroundcolorblue;
    }

    public int getFontColorRed() {
        return this.fontcolorred;
    }

    public int getFontColorGreen() {
        return this.fontcolorgreen;
    }

    public int getFontColorBlue() {
        return this.fontcolorblue;
    }

    public void setFontSize(int fontsize) {
        this.fontsize = fontsize;
    }

    private void setDefaultFont() {
        this.fontname = null;
        this.fontsize = -1;
        this.fontbold = false;
        this.fontitalic = false;
        this.fontcolorred = 0;
        this.fontcolorgreen = 0;
        this.fontcolorblue = 0;
        this.backgroundcolorred = 255;
        this.backgroundcolorgreen = 165;
        this.backgroundcolorblue = 0;
        this.bordercolorred = 100;
        this.bordercolorgreen = 100;
        this.bordercolorblue = 100;
        this.drawshadow = true;
    }
}

