/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleSupport;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.i18n.BaseMessages;

public class KettleLifecycleSupport {
    private static Class<?> PKG = Const.class;
    private Set<KettleLifecycleListener> kettleLifecycleListeners = LifecycleSupport.loadPlugins(KettleLifecyclePluginType.class, KettleLifecycleListener.class);

    public void onEnvironmentInit() throws KettleException {
        for (KettleLifecycleListener listener : this.kettleLifecycleListeners) {
            try {
                listener.onEnvironmentInit();
            }
            catch (LifecycleException ex) {
                String message = BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener});
                if (ex.isSevere()) {
                    throw new KettleException(message, (Throwable)ex);
                }
                LogChannel.GENERAL.logError(message, (Throwable)ex);
            }
            catch (Throwable t) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener}), t);
            }
        }
    }

    public void onEnvironmentShutdown() {
        for (KettleLifecycleListener listener : this.kettleLifecycleListeners) {
            try {
                listener.onEnvironmentShutdown();
            }
            catch (Throwable t) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener}), t);
            }
        }
    }
}

