/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.BufferLine;
import org.pentaho.di.core.logging.Log4jBufferAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.util.EnvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralLogStore {
    private static CentralLogStore store;
    private Log4jBufferAppender appender;
    private Timer logCleanerTimer;

    private CentralLogStore(int maxSize, int maxLogTimeoutMinutes) {
        this.appender = new Log4jBufferAppender(maxSize);
        LogWriter.getInstance().addAppender((Appender)this.appender);
        this.replaceLogCleaner(maxLogTimeoutMinutes);
    }

    public void replaceLogCleaner(final int maxLogTimeoutMinutes) {
        if (this.logCleanerTimer != null) {
            this.logCleanerTimer.cancel();
        }
        this.logCleanerTimer = new Timer(true);
        final AtomicBoolean busy = new AtomicBoolean(false);
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!busy.get()) {
                    busy.set(true);
                    if (maxLogTimeoutMinutes > 0) {
                        long minTimeBoundary = new Date().getTime() - (long)(maxLogTimeoutMinutes * 60 * 1000);
                        Log4jBufferAppender log4jBufferAppender = CentralLogStore.this.appender;
                        synchronized (log4jBufferAppender) {
                            Iterator i = CentralLogStore.this.appender.getBufferIterator();
                            while (i.hasNext()) {
                                BufferLine bufferLine = (BufferLine)i.next();
                                if (bufferLine.getEvent().timeStamp >= minTimeBoundary) break;
                                i.remove();
                            }
                        }
                    }
                    busy.set(false);
                }
            }
        };
        this.logCleanerTimer.schedule(timerTask, 10000L, 10000L);
    }

    public static void init(int maxSize, int maxLogTimeoutMinutes) {
        if (maxSize > 0 || maxLogTimeoutMinutes > 0) {
            CentralLogStore.init0(maxSize, maxLogTimeoutMinutes);
        } else {
            CentralLogStore.init();
        }
    }

    public static void init() {
        int maxSize = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_SIZE_IN_LINES"), (int)5000);
        int maxLogTimeoutMinutes = Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES"), (int)1440);
        CentralLogStore.init0(maxSize, maxLogTimeoutMinutes);
    }

    private static synchronized void init0(int maxSize, int maxLogTimeoutMinutes) {
        if (store != null) {
            CentralLogStore.store.appender.setMaxNrLines(maxSize);
            store.replaceLogCleaner(maxLogTimeoutMinutes);
        } else {
            store = new CentralLogStore(maxSize, maxLogTimeoutMinutes);
        }
    }

    private static CentralLogStore getInstance() {
        if (store == null) {
            throw new RuntimeException("Central Log Store is not initialized!!!");
        }
        return store;
    }

    public static int getLastBufferLineNr() {
        return CentralLogStore.getInstance().appender.getLastBufferLineNr();
    }

    public static List<LoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        return CentralLogStore.getInstance().appender.getLogBufferFromTo(parentLogChannelId, includeGeneral, from, to);
    }

    public static List<LoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        return CentralLogStore.getInstance().appender.getLogBufferFromTo(channelId, includeGeneral, from, to);
    }

    public static Log4jBufferAppender getAppender() {
        return CentralLogStore.getInstance().appender;
    }

    public static void discardLines(String parentLogChannelId, boolean includeGeneralMessages) {
        LoggingRegistry registry = LoggingRegistry.getInstance();
        List ids = registry.getLogChannelChildren(parentLogChannelId);
        Log4jBufferAppender bufferAppender = CentralLogStore.getInstance().appender;
        for (String id : ids) {
            bufferAppender.removeChannelFromBuffer(id);
            registry.getMap().remove(id);
        }
        if (includeGeneralMessages) {
            bufferAppender.removeGeneralMessages();
        }
    }
}

